/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.streamquery.stream.core.lambda.function;

import java.io.Serializable;
import java.util.Objects;
import java.util.stream.Stream;
import org.dromara.streamquery.stream.core.lambda.LambdaInvokeException;

@FunctionalInterface
public interface SerArgsPred<T>
extends Serializable {
    @SafeVarargs
    public static <T> SerArgsPred<T> multiAnd(SerArgsPred<T> ... predicates) {
        return Stream.of(predicates).reduce(SerArgsPred::and).orElseGet(() -> o -> true);
    }

    @SafeVarargs
    public static <T> SerArgsPred<T> multiOr(SerArgsPred<T> ... predicates) {
        return Stream.of(predicates).reduce(SerArgsPred::or).orElseGet(() -> o -> false);
    }

    public static <T> SerArgsPred<T> isEqual(Object ... targetRef) {
        return null == targetRef ? Objects::isNull : object -> Stream.of(targetRef).allMatch(target -> target.equals(object));
    }

    public boolean testing(T ... var1) throws Throwable;

    default public boolean test(T ... t) {
        try {
            return this.testing(t);
        }
        catch (Throwable e) {
            throw new LambdaInvokeException(e);
        }
    }

    default public SerArgsPred<T> and(SerArgsPred<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) && other.test(t);
    }

    default public SerArgsPred<T> negate() {
        return t -> !this.test(t);
    }

    default public SerArgsPred<T> or(SerArgsPred<? super T> other) {
        Objects.requireNonNull(other);
        return t -> this.test(t) || other.test(t);
    }
}

