/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.streamquery.stream.core.stream;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;
import java.util.stream.Stream;
import org.dromara.streamquery.stream.core.optional.Opp;
import org.dromara.streamquery.stream.core.stream.Steam;
import org.dromara.streamquery.stream.core.stream.collector.Collective;

public interface CollectableStream<T>
extends Stream<T> {
    default public String join() {
        return this.join("");
    }

    default public String join(CharSequence delimiter) {
        return this.join(delimiter, "", "");
    }

    default public String join(CharSequence delimiter, CharSequence prefix, CharSequence suffix) {
        return this.map(String::valueOf).collect(Collective.joining(delimiter, prefix, suffix));
    }

    default public <C extends Collection<T>> C toCollection(Supplier<C> collectionFactory) {
        return (C)((Collection)this.collect(Collective.toCollection(collectionFactory)));
    }

    @Override
    default public List<T> toList() {
        return this.collect(Collective.toList());
    }

    default public List<T> toUnmodifiableList() {
        List<T> result = this.toList();
        return Collections.unmodifiableList(result);
    }

    default public Set<T> toSet() {
        return this.collect(Collective.toSet());
    }

    default public Set<T> toUnmodifiableSet() {
        return Collections.unmodifiableSet(this.toSet());
    }

    default public <K> Map<K, T> toMap(Function<? super T, ? extends K> keyMapper) {
        return this.toMap(keyMapper, Function.identity());
    }

    default public <K, U> Map<K, U> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return this.toMap(keyMapper, valueMapper, (l, r) -> r);
    }

    default public <U> Map<Integer, U> toIdxMap(Function<? super T, ? extends U> valueMapper) {
        AtomicInteger index = new AtomicInteger(-1);
        return Steam.of(this.toList()).toMap(e -> index.incrementAndGet(), valueMapper, (l, r) -> r);
    }

    default public Map<Integer, T> toIdxMap() {
        return this.toIdxMap(Function.identity());
    }

    default public <K, U> Map<K, U> toUnmodifiableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        Map<? extends K, ? extends U> result = this.toMap(keyMapper, valueMapper);
        return Collections.unmodifiableMap(result);
    }

    default public <K, U> Map<K, U> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return this.toMap(keyMapper, valueMapper, mergeFunction, HashMap::new);
    }

    default public <K, U> Map<K, U> toUnmodifiableMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        HashMap result = this.toMap(keyMapper, valueMapper, mergeFunction, HashMap::new);
        return Collections.unmodifiableMap(result);
    }

    default public <K, U, M extends Map<K, U>> M toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction, Supplier<M> mapSupplier) {
        return (M)((Map)this.collect(Collective.toMap(keyMapper, valueMapper, mergeFunction, mapSupplier)));
    }

    default public <R> Map<T, R> toZip(Iterable<R> other) {
        Iterator iterator = Opp.of(other).map(Iterable::iterator).orElseGet(Collections::emptyIterator);
        if (this.isParallel()) {
            List<T> keyList = this.toList();
            HashMap<T, Object> map = new HashMap<T, Object>(keyList.size());
            for (T key : keyList) {
                map.put(key, iterator.hasNext() ? (Object)iterator.next() : null);
            }
            return map;
        }
        return this.toMap(Function.identity(), e -> iterator.hasNext() ? iterator.next() : null);
    }

    default public <K> Map<K, List<T>> group(Function<? super T, ? extends K> classifier) {
        return this.group(classifier, Collective.toList());
    }

    default public <K, A, D> Map<K, D> group(Function<? super T, ? extends K> classifier, Collector<? super T, A, D> downstream) {
        return this.group(classifier, HashMap::new, downstream);
    }

    default public <K, D, A, M extends Map<K, D>> M group(Function<? super T, ? extends K> classifier, Supplier<M> mapFactory, Collector<? super T, A, D> downstream) {
        return (M)((Map)this.collect(Collective.groupingBy(classifier, mapFactory, downstream)));
    }

    default public Map<Boolean, List<T>> partition(Predicate<T> predicate) {
        return this.partition(predicate, ArrayList::new);
    }

    default public <C extends Collection<T>> Map<Boolean, C> partition(Predicate<T> predicate, Supplier<C> collFactory) {
        return this.partition(predicate, Collective.toCollection(collFactory));
    }

    default public <R> Map<Boolean, R> partition(Predicate<T> predicate, Collector<T, ?, R> downstream) {
        return this.collect(Collective.partitioningBy(predicate, downstream));
    }
}

