/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.streamquery.stream.plugin.mybatisplus;

import com.baomidou.mybatisplus.core.MybatisConfiguration;
import com.baomidou.mybatisplus.core.conditions.AbstractWrapper;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.interfaces.Join;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.enums.SqlMethod;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.metadata.TableFieldInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ArrayUtils;
import com.baomidou.mybatisplus.core.toolkit.Assert;
import com.baomidou.mybatisplus.core.toolkit.ClassUtils;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.ExceptionUtils;
import com.baomidou.mybatisplus.core.toolkit.GlobalConfigUtils;
import com.baomidou.mybatisplus.core.toolkit.LambdaUtils;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.StringUtils;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.sql.SqlInjectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.LambdaMeta;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.toolkit.SimpleQuery;
import com.baomidou.mybatisplus.extension.toolkit.SqlHelper;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Stream;
import net.bytebuddy.ByteBuddy;
import net.bytebuddy.description.type.TypeDefinition;
import net.bytebuddy.description.type.TypeDescription;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.logging.Log;
import org.apache.ibatis.logging.LogFactory;
import org.apache.ibatis.reflection.property.PropertyNamer;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.ibatis.type.SimpleTypeRegistry;
import org.dromara.streamquery.stream.core.collection.Lists;
import org.dromara.streamquery.stream.core.collection.Maps;
import org.dromara.streamquery.stream.core.lambda.function.SerBiCons;
import org.dromara.streamquery.stream.core.lambda.function.SerCons;
import org.dromara.streamquery.stream.core.lambda.function.SerFunc;
import org.dromara.streamquery.stream.core.lambda.function.SerSupp;
import org.dromara.streamquery.stream.core.optional.Opp;
import org.dromara.streamquery.stream.core.optional.Sf;
import org.dromara.streamquery.stream.core.reflect.ReflectHelper;
import org.dromara.streamquery.stream.core.stream.Steam;
import org.dromara.streamquery.stream.plugin.mybatisplus.WrapperHelper;
import org.dromara.streamquery.stream.plugin.mybatisplus.engine.constant.PluginConst;
import org.dromara.streamquery.stream.plugin.mybatisplus.engine.mapper.IMapper;
import org.mybatis.spring.SqlSessionUtils;

public class Database {
    private static final Log LOG = LogFactory.getLog(Database.class);
    private static final Map<Class<?>, Map<String, String>> TABLE_PROPERTY_COLUMN_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Map<String, String>> TABLE_COLUMN_PROPERTY_CACHE = new ConcurrentHashMap();
    private static final Map<Class<?>, Class<?>> ENTITY_MAPPER_CLASS_CACHE = new ConcurrentHashMap();

    private Database() {
    }

    public static boolean isActive(AbstractWrapper<?, ?, ?> wrapper) {
        return Objects.nonNull(wrapper) && (wrapper.getSqlComment() == null || !wrapper.getSqlComment().contains("WRAPPER_NOT_ACTIVE"));
    }

    public static boolean isNotActive(AbstractWrapper<?, ?, ?> wrapper) {
        return !Database.isActive(wrapper);
    }

    public static <W extends AbstractWrapper<T, ?, ?>, T, U extends R, R> R activeOrElse(W wrapper, Function<? super W, U> mapper, U other) {
        return (R)(Database.isActive(wrapper) ? mapper.apply(wrapper) : other);
    }

    public static <T extends Join<?>> T notActive(T wrapper) {
        return Database.notActive(true, wrapper);
    }

    public static <T extends Join<?>> T notActive(Boolean condition, T wrapper) {
        wrapper.comment(Boolean.TRUE.equals(condition), "WRAPPER_NOT_ACTIVE");
        return wrapper;
    }

    @Deprecated
    public static <T, E extends Serializable> Opp<LambdaQueryWrapper<T>> lambdaQuery(E data, SFunction<T, E> condition) {
        return Opp.of(data).map(value -> (LambdaQueryWrapper)Wrappers.lambdaQuery((Object)ClassUtils.newInstance((Class)SimpleQuery.getType((SFunction)condition))).eq((Object)condition, value)).filter(Database::isActive);
    }

    @Deprecated
    public static <T, E extends Serializable> Opp<LambdaQueryWrapper<T>> lambdaQuery(Collection<E> dataList, SFunction<T, E> condition) {
        return Opp.ofColl(dataList).map(value -> (LambdaQueryWrapper)Wrappers.lambdaQuery((Object)ClassUtils.newInstance((Class)SimpleQuery.getType((SFunction)condition))).in((Object)condition, new HashSet(value))).filter(Database::isActive);
    }

    public static <T, K> LambdaQueryWrapper<T> lambdaQuery(SFunction<T, K> keyFunction) {
        return Wrappers.lambdaQuery((Object)ClassUtils.newInstance((Class)SimpleQuery.getType(keyFunction)));
    }

    @Deprecated
    @SafeVarargs
    public static <T> LambdaQueryWrapper<T> select(LambdaQueryWrapper<T> wrapper, SFunction<T, ?> ... columns) {
        return Database.select(wrapper, LambdaQueryWrapper::select, columns);
    }

    @Deprecated
    @SafeVarargs
    public static <T> LambdaQueryWrapper<T> select(LambdaQueryWrapper<T> wrapper, SerBiCons<LambdaQueryWrapper<T>, SFunction<T, ?>[]> whenAllMatchColumn, SFunction<T, ?> ... columns) {
        return WrapperHelper.select(wrapper, whenAllMatchColumn, columns);
    }

    public static <T> boolean save(T entity) {
        if (Objects.isNull(entity)) {
            return false;
        }
        Class entityClass = (Class)SerFunc.cast().apply(entity.getClass());
        Integer result = (Integer)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.insert(entity));
        return SqlHelper.retBool((Integer)result);
    }

    public static <T> boolean saveBatch(Collection<T> entityList) {
        return Database.saveBatch(entityList, 1000);
    }

    public static <T> boolean saveBatch(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList) || batchSize <= 0) {
            return false;
        }
        Class<T> entityClass = Database.getEntityClass(entityList);
        Class<?> mapperClass = Database.getMapperClass(entityClass);
        String sqlStatement = SqlHelper.getSqlStatement(mapperClass, (SqlMethod)SqlMethod.INSERT_ONE);
        return SqlHelper.executeBatch(entityClass, (Log)LOG, entityList, (int)batchSize, (sqlSession, entity) -> sqlSession.insert(sqlStatement, entity));
    }

    public static <T> boolean saveFewSql(Collection<T> entityList) {
        return Database.saveFewSql(entityList, 1000);
    }

    public static <T> boolean saveOrUpdateFewSql(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList) || batchSize < 0) {
            return false;
        }
        Class<T> entityClass = Database.getEntityClass(entityList);
        TableInfo tableInfo = Database.getTableInfo(entityClass);
        Map isInsertDataListMap = Steam.of(entityList).partition(entity -> Objects.isNull(tableInfo.getPropertyValue(entity, tableInfo.getKeyProperty())));
        List saveList = (List)isInsertDataListMap.get(true);
        List updateList = (List)isInsertDataListMap.get(false);
        boolean isSuccess = true;
        if (Lists.isNotEmpty((Collection)saveList)) {
            isSuccess = Database.saveFewSql(saveList, batchSize);
        }
        if (Lists.isNotEmpty((Collection)updateList)) {
            boolean isUpdateSuccess = Database.updateFewSql(updateList, batchSize);
            if (isSuccess) {
                isSuccess = isUpdateSuccess;
            }
        }
        return isSuccess;
    }

    public static <T> boolean saveOrUpdateFewSql(Collection<T> entityList) {
        return Database.saveOrUpdateFewSql(entityList, 1000);
    }

    public static <T> boolean saveFewSql(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList) || batchSize <= 0) {
            return false;
        }
        return (Boolean)Database.execute(Database.getEntityClass(entityList), (SFunction & Serializable)baseMapper -> (long)entityList.size() == baseMapper.saveFewSql(entityList, batchSize));
    }

    public static <T> boolean updateOneSql(Collection<T> entityList) {
        if (CollectionUtils.isEmpty(entityList)) {
            return false;
        }
        return (Boolean)Database.execute(Database.getEntityClass(entityList), (SFunction & Serializable)baseMapper -> (long)entityList.size() == baseMapper.updateOneSql(entityList));
    }

    public static <T> boolean updateFewSql(Collection<T> entityList) {
        return Database.updateFewSql(entityList, 1000);
    }

    public static <T> boolean updateFewSql(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList) || batchSize <= 0) {
            return false;
        }
        return (Boolean)Database.execute(Database.getEntityClass(entityList), (SFunction & Serializable)baseMapper -> (long)entityList.size() == baseMapper.updateFewSql(entityList, batchSize));
    }

    public static <T> boolean saveOrUpdateBatch(Collection<T> entityList) {
        return Database.saveOrUpdateBatch(entityList, 1000);
    }

    public static <T> boolean saveOrUpdateBatch(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList) || batchSize < 0) {
            return false;
        }
        Class<T> entityClass = Database.getEntityClass(entityList);
        TableInfo tableInfo = Database.getTableInfo(entityClass);
        Class<?> mapperClass = Database.getMapperClass(entityClass);
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for primary key from entity!", (Object[])new Object[0]);
        return SqlHelper.saveOrUpdateBatch(entityClass, mapperClass, (Log)LOG, entityList, (int)batchSize, (sqlSession, entity) -> {
            Object idVal = tableInfo.getPropertyValue(entity, keyProperty);
            return StringUtils.checkValNull((Object)idVal) || CollectionUtils.isEmpty((Collection)sqlSession.selectList(SqlHelper.getSqlStatement((Class)mapperClass, (SqlMethod)SqlMethod.SELECT_BY_ID), entity));
        }, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(SqlHelper.getSqlStatement((Class)mapperClass, (SqlMethod)SqlMethod.UPDATE_BY_ID), (Object)param);
        });
    }

    public static <T, U extends Serializable & Comparable<? super U>> boolean removeById(U id, Class<T> entityClass) {
        return (Boolean)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> SqlHelper.retBool((Integer)baseMapper.deleteById(id)));
    }

    public static <T> boolean removeById(T entity) {
        if (Objects.isNull(entity)) {
            return false;
        }
        Class entityClass = (Class)SerFunc.cast().apply(entity.getClass());
        return (Boolean)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> SqlHelper.retBool((Integer)baseMapper.deleteById(entity)));
    }

    public static <T> boolean remove(AbstractWrapper<T, ?, ?> queryWrapper) {
        return (Boolean)Database.execute(Database.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> (Boolean)Database.activeOrElse(queryWrapper, w -> SqlHelper.retBool((Integer)baseMapper.delete((Wrapper)w)), false));
    }

    public static <T> boolean updateById(T entity) {
        if (Objects.isNull(entity)) {
            return false;
        }
        Class entityClass = (Class)SerFunc.cast().apply(entity.getClass());
        return (Boolean)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> SqlHelper.retBool((Integer)baseMapper.updateById(entity)));
    }

    @SafeVarargs
    public static <T> boolean updateForceById(T entity, SFunction<T, ?> ... updateKeys) {
        if (Objects.isNull(entity) || ArrayUtils.isEmpty((Object[])updateKeys)) {
            return Database.updateById(entity);
        }
        Class entityClass = (Class)SerFunc.cast().apply(entity.getClass());
        TableInfo tableInfo = Database.getTableInfo(entityClass);
        Object bean = ClassUtils.newInstance((Class)entityClass);
        String keyProperty = tableInfo.getKeyProperty();
        ReflectHelper.setFieldValue((Object)bean, (String)keyProperty, (Object)ReflectionKit.getFieldValue(entity, (String)keyProperty));
        LambdaUpdateWrapper updateWrapper = Stream.of(updateKeys).reduce(Wrappers.lambdaUpdate((Object)bean), (wrapper, field) -> (LambdaUpdateWrapper)wrapper.set(field, field.apply(entity)), (l, r) -> r);
        return Database.update(bean, updateWrapper);
    }

    public static <T> boolean update(AbstractWrapper<T, ?, ?> updateWrapper) {
        return Database.update(null, updateWrapper);
    }

    public static <T> boolean update(T entity, AbstractWrapper<T, ?, ?> updateWrapper) {
        return (Boolean)Database.execute(Database.getEntityClass(updateWrapper), (SFunction & Serializable)baseMapper -> (Boolean)Database.activeOrElse(updateWrapper, w -> SqlHelper.retBool((Integer)baseMapper.update(entity, (Wrapper)w)), false));
    }

    public static <T> boolean updateBatchById(Collection<T> entityList) {
        return Database.updateBatchById(entityList, 1000);
    }

    public static <T> boolean updateBatchById(Collection<T> entityList, int batchSize) {
        if (CollectionUtils.isEmpty(entityList) || batchSize <= 0) {
            return false;
        }
        Class<T> entityClass = Database.getEntityClass(entityList);
        Class<?> mapperClass = Database.getMapperClass(entityClass);
        String sqlStatement = SqlHelper.getSqlStatement(mapperClass, (SqlMethod)SqlMethod.UPDATE_BY_ID);
        return SqlHelper.executeBatch(entityClass, (Log)LOG, entityList, (int)batchSize, (sqlSession, entity) -> {
            MapperMethod.ParamMap param = new MapperMethod.ParamMap();
            param.put((Object)"et", entity);
            sqlSession.update(sqlStatement, (Object)param);
        });
    }

    public static <T, U extends Serializable & Comparable<? super U>> boolean removeByIds(Collection<U> list, Class<T> entityClass) {
        if (Lists.isEmpty(list)) {
            return false;
        }
        return (Boolean)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> SqlHelper.retBool((Integer)baseMapper.deleteBatchIds(list)));
    }

    public static <T> boolean removeByIds(Collection<T> list) {
        if (Lists.isEmpty(list)) {
            return false;
        }
        return (Boolean)Database.execute(Database.getEntityClass(list), (SFunction & Serializable)baseMapper -> SqlHelper.retBool((Integer)baseMapper.deleteBatchIds(list)));
    }

    public static <T> boolean removeByMap(Map<String, Object> columnMap, Class<T> entityClass) {
        return (Boolean)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> SqlHelper.retBool((Integer)baseMapper.deleteByMap(columnMap)));
    }

    public static <T, U extends Serializable & Comparable<? super U>> boolean saveOrUpdate(T entity) {
        if (Objects.isNull(entity)) {
            return false;
        }
        Class entityClass = (Class)SerFunc.cast().apply(entity.getClass());
        TableInfo tableInfo = TableInfoHelper.getTableInfo((Class)entityClass);
        if (tableInfo == null) {
            throw ExceptionUtils.mpe((String)"error: can not execute. because can not find cache of TableInfo for entity!", (Object[])new Object[0]);
        }
        String keyProperty = tableInfo.getKeyProperty();
        Assert.notEmpty((String)keyProperty, (String)"error: can not execute. because can not find column for id from entity!", (Object[])new Object[0]);
        Serializable idVal = (Serializable)tableInfo.getPropertyValue(entity, tableInfo.getKeyProperty());
        return StringUtils.checkValNull((Object)idVal) || Objects.isNull(Database.getById(idVal, entityClass)) ? Database.save(entity) : Database.updateById(entity);
    }

    public static <T, U extends Serializable & Comparable<? super U>> T getById(U id, Class<T> entityClass) {
        return (T)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectById(id));
    }

    public static <T> T getOne(AbstractWrapper<T, ?, ?> queryWrapper) {
        return Database.getOne(queryWrapper, true);
    }

    public static <T> T getOne(AbstractWrapper<T, ?, ?> queryWrapper, boolean throwEx) {
        if (!Database.isActive(queryWrapper)) {
            return null;
        }
        Class<T> entityClass = Database.getEntityClass(queryWrapper);
        return (T)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectOne((Wrapper)queryWrapper, throwEx));
    }

    public static <T> List<T> listByMap(Map<String, Object> columnMap, Class<T> entityClass) {
        return (List)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectByMap(columnMap));
    }

    public static <T, U extends Serializable & Comparable<? super U>> List<T> listByIds(Collection<U> idList, Class<T> entityClass) {
        if (Lists.isEmpty(idList)) {
            return Lists.empty();
        }
        return (List)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectBatchIds(idList));
    }

    public static <T> Map<String, Object> getMap(AbstractWrapper<T, ?, ?> queryWrapper) {
        return (Map)Database.execute(Database.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> (Map)Database.activeOrElse(queryWrapper, w -> (Map)SqlHelper.getObject((Log)LOG, (List)baseMapper.selectMaps((Wrapper)w)), null));
    }

    public static <T> long count(Class<T> entityClass) {
        return (Long)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectCount(null));
    }

    public static <T> long count(AbstractWrapper<T, ?, ?> queryWrapper) {
        return (Long)Database.execute(Database.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> (Long)Database.activeOrElse(queryWrapper, arg_0 -> ((BaseMapper)baseMapper).selectCount(arg_0), 0L));
    }

    public static <T> List<T> list(AbstractWrapper<T, ?, ?> queryWrapper) {
        return (List)Database.execute(Database.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> (List)Database.activeOrElse(queryWrapper, arg_0 -> ((BaseMapper)baseMapper).selectList(arg_0), new ArrayList()));
    }

    public static <T> List<T> list(Class<T> entityClass) {
        return (List)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectList(null));
    }

    public static <T> List<Map<String, Object>> listMaps(AbstractWrapper<T, ?, ?> queryWrapper) {
        return (List)Database.execute(Database.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> (List)Database.activeOrElse(queryWrapper, arg_0 -> ((BaseMapper)baseMapper).selectMaps(arg_0), new ArrayList()));
    }

    public static <T> List<Map<String, Object>> listMaps(Class<T> entityClass) {
        return (List)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectMaps(null));
    }

    public static <T> List<T> listObjs(Class<T> entityClass) {
        return Database.listObjs(entityClass, (SFunction & Serializable)i -> i);
    }

    public static <T> List<Object> listObjs(AbstractWrapper<T, ?, ?> queryWrapper) {
        return (List)Database.execute(Database.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> (List)Database.activeOrElse(queryWrapper, arg_0 -> ((BaseMapper)baseMapper).selectObjs(arg_0), new ArrayList()));
    }

    public static <T, V> List<V> listObjs(AbstractWrapper<T, ?, ?> queryWrapper, SFunction<? super T, V> mapper) {
        return (List)Database.execute(Database.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> (List)Database.activeOrElse(queryWrapper, w -> Steam.of((Iterable)baseMapper.selectList((Wrapper)w)).map((Function)mapper).toList(), new ArrayList()));
    }

    public static <T, V> List<V> listObjs(Class<T> entityClass, SFunction<? super T, V> mapper) {
        return (List)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> Steam.of((Iterable)baseMapper.selectList(null)).map((Function)mapper).toList());
    }

    public static <T, E extends IPage<Map<String, Object>>> E pageMaps(E page, Class<T> entityClass) {
        return (E)((IPage)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectMapsPage(page, null)));
    }

    public static <T, E extends IPage<Map<String, Object>>> E pageMaps(E page, AbstractWrapper<T, ?, ?> queryWrapper) {
        return (E)((IPage)Database.execute(Database.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> (IPage)Database.activeOrElse(queryWrapper, w -> baseMapper.selectMapsPage(page, (Wrapper)w), page)));
    }

    public static <T> IPage<T> page(IPage<T> page, Class<T> entityClass) {
        return (IPage)Database.execute(entityClass, (SFunction & Serializable)baseMapper -> baseMapper.selectPage(page, null));
    }

    public static <T> IPage<T> page(IPage<T> page, AbstractWrapper<T, ?, ?> queryWrapper) {
        return (IPage)Database.execute(Database.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> (IPage)Database.activeOrElse(queryWrapper, w -> baseMapper.selectPage(page, (Wrapper)w), page));
    }

    public static <T> boolean saveOrUpdate(T entity, AbstractWrapper<T, ?, ?> updateWrapper) {
        if (!Database.isActive(updateWrapper)) {
            return false;
        }
        return Database.update(entity, updateWrapper) || Database.saveOrUpdate(entity);
    }

    public static <T, V> V getObj(AbstractWrapper<T, ?, ?> queryWrapper, SFunction<? super T, V> mapper) {
        return (V)Database.execute(Database.getEntityClass(queryWrapper), (SFunction & Serializable)baseMapper -> Database.activeOrElse(queryWrapper, w -> mapper.apply(baseMapper.selectOne((Wrapper)w)), null));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, R, M extends BaseMapper<T>> R execute(Class<T> entityClass, SFunction<M, R> sFunction) {
        SqlSession sqlSession = SqlHelper.sqlSession(entityClass);
        try {
            Object object = sFunction.apply(Database.getMapper(entityClass, sqlSession));
            return (R)object;
        }
        finally {
            SqlSessionUtils.closeSqlSession((SqlSession)sqlSession, (SqlSessionFactory)GlobalConfigUtils.currentSessionFactory(entityClass));
        }
    }

    public static void buildMapper(Configuration configuration, Class<?> entityClass) {
        if (!(configuration instanceof MybatisConfiguration)) {
            throw new IllegalArgumentException("configuration must be MybatisConfiguration");
        }
        Maps.computeIfAbsent(ENTITY_MAPPER_CLASS_CACHE, entityClass, k -> {
            Class dynamicMapper = new ByteBuddy().makeInterface(new TypeDefinition[]{TypeDescription.Generic.Builder.parameterizedType(IMapper.class, (Type[])new Type[]{entityClass}).build()}).name(String.format("%s.%sMapper", PluginConst.DYNAMIC_MAPPER_PREFIX, entityClass.getName())).make().load(ClassUtils.class.getClassLoader()).getLoaded();
            configuration.addMapper(dynamicMapper);
            return dynamicMapper;
        });
    }

    public static <T, M extends BaseMapper<T>> M getMapper(Class<T> entityClass, SqlSession sqlSession) {
        if (entityClass == null) {
            throw ExceptionUtils.mpe((String)"entityClass can't be null!", (Object[])new Object[0]);
        }
        TableInfo tableInfo = Optional.ofNullable(TableInfoHelper.getTableInfo(entityClass)).orElseThrow(() -> ExceptionUtils.mpe((String)"Can not find TableInfo from Class: \"%s\".", (Object[])new Object[]{entityClass.getName()}));
        Class<?> mapperClass = Database.getMapperClass(entityClass);
        return (M)((BaseMapper)tableInfo.getConfiguration().getMapper(mapperClass, sqlSession));
    }

    public static Map<Class<?>, Class<?>> getEntityMapperClassCache() {
        return ENTITY_MAPPER_CLASS_CACHE;
    }

    public static <T> Class<?> getMapperClass(Class<T> clazz) {
        if (clazz == null || clazz.isPrimitive() || SimpleTypeRegistry.isSimpleType(clazz) || clazz.isInterface()) {
            throw ExceptionUtils.mpe((String)"\u627e\u4e0d\u5230\u6307\u5b9a\u7684class\uff01\u8bf7\u4ec5\u5728\u660e\u786e\u786e\u5b9a\u4f1a\u6709 class \u7684\u65f6\u5019\uff0c\u8c03\u7528\u8be5\u65b9\u6cd5", (Object[])new Object[0]);
        }
        Class targetClass = ClassUtils.getUserClass(clazz);
        Class<?> mapperClass = ENTITY_MAPPER_CLASS_CACHE.get(targetClass);
        if (null != mapperClass) {
            return mapperClass;
        }
        for (Class<T> currentClass = clazz; null == mapperClass && Object.class != currentClass; currentClass = currentClass.getSuperclass()) {
            mapperClass = ENTITY_MAPPER_CLASS_CACHE.get(ClassUtils.getUserClass(currentClass));
        }
        if (mapperClass == null) {
            mapperClass = ClassUtils.toClassConfident((String)Database.getTableInfo(clazz).getCurrentNamespace());
        }
        if (mapperClass != null) {
            ENTITY_MAPPER_CLASS_CACHE.put(targetClass, mapperClass);
        }
        return mapperClass;
    }

    public static Map<String, String> getPropertyColumnMap(Class<?> entityClass) {
        return (Map)Maps.computeIfAbsent(TABLE_PROPERTY_COLUMN_CACHE, entityClass, clazz -> {
            TableInfo tableInfo = Database.getTableInfo(clazz);
            Map propertyColumnMap = Steam.of((Iterable)tableInfo.getFieldList()).toMap(TableFieldInfo::getProperty, TableFieldInfo::getColumn);
            propertyColumnMap.put(tableInfo.getKeyProperty(), tableInfo.getKeyColumn());
            return Collections.unmodifiableMap(propertyColumnMap);
        });
    }

    public static Map<String, String> getColumnPropertyMap(Class<?> entityClass) {
        return (Map)Maps.computeIfAbsent(TABLE_COLUMN_PROPERTY_CACHE, entityClass, clazz -> {
            TableInfo tableInfo = Database.getTableInfo(clazz);
            Map columnPropertyMap = Steam.of((Iterable)tableInfo.getFieldList()).toMap(TableFieldInfo::getColumn, TableFieldInfo::getProperty);
            columnPropertyMap.put(tableInfo.getKeyColumn(), tableInfo.getKeyProperty());
            return Collections.unmodifiableMap(columnPropertyMap);
        });
    }

    public static <T, R extends Comparable<? super R>> String propertyToColumn(SFunction<T, R> property) {
        LambdaMeta lambdaMeta = LambdaUtils.extract(property);
        return Database.propertyToColumn(lambdaMeta.getInstantiatedClass(), PropertyNamer.methodToProperty((String)lambdaMeta.getImplMethodName()));
    }

    public static String propertyToColumn(Class<?> clazz, String property) {
        return Database.getPropertyColumnMap(clazz).get(property);
    }

    public static String columnToProperty(Class<?> clazz, String column) {
        return Database.getColumnPropertyMap(clazz).get(column);
    }

    public static <T> void ordersPropertyToColumn(Page<T> page, Class<T> clazz) {
        page.getOrders().forEach(SerCons.multi((SerCons[])new SerCons[]{(SerCons & Serializable)order -> Sf.of((Object)order.getColumn()).takeUnless(SqlInjectionUtils::check).require((SerSupp & Serializable)() -> new IllegalArgumentException(String.format("order column { %s } must not null or be sql injection", order.getColumn()))), (SerCons & Serializable)order -> order.setColumn(Database.propertyToColumn(clazz, order.getColumn()))}));
    }

    protected static <T> Class<T> getEntityClass(Collection<T> entityList) {
        Class entityClass = null;
        for (T entity : entityList) {
            if (entity == null) continue;
            entityClass = (Class)SerFunc.cast().apply(entity.getClass());
            break;
        }
        if (entityClass == null) {
            throw ExceptionUtils.mpe((String)"error: can not get entityClass from entityList", (Object[])new Object[0]);
        }
        Assert.isFalse((boolean)SimpleTypeRegistry.isSimpleType(entityClass), (String)"error: entityClass can not be simple type", (Object[])new Object[0]);
        return entityClass;
    }

    protected static <T> Class<T> getEntityClass(AbstractWrapper<T, ?, ?> queryWrapper) {
        Object entity;
        Class entityClass = queryWrapper.getEntityClass();
        if (entityClass == null && (entity = queryWrapper.getEntity()) != null) {
            entityClass = (Class)SerFunc.cast().apply(entity.getClass());
        }
        if (entityClass == null) {
            throw ExceptionUtils.mpe((String)"error: can not get entityClass from wrapper", (Object[])new Object[0]);
        }
        return entityClass;
    }

    private static <T> TableInfo getTableInfo(Class<T> entityClass) {
        return Optional.ofNullable(TableInfoHelper.getTableInfo(entityClass)).orElseThrow(() -> ExceptionUtils.mpe((String)"error: can not find TableInfo from Class: \"%s\".", (Object[])new Object[]{entityClass.getName()}));
    }

    public static boolean isDynamicMapper(String mapperClassName) {
        return mapperClassName.startsWith(PluginConst.DYNAMIC_MAPPER_PREFIX);
    }
}

