/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.streamquery.stream.plugin.mybatisplus.engine.configuration;

import com.baomidou.mybatisplus.core.injector.AbstractMethod;
import com.baomidou.mybatisplus.core.injector.DefaultSqlInjector;
import com.baomidou.mybatisplus.core.mapper.Mapper;
import com.baomidou.mybatisplus.core.metadata.TableInfo;
import com.baomidou.mybatisplus.core.metadata.TableInfoHelper;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import java.util.List;
import org.apache.ibatis.builder.MapperBuilderAssistant;
import org.apache.ibatis.session.SqlSessionFactory;
import org.dromara.streamquery.stream.core.lambda.LambdaHelper;
import org.dromara.streamquery.stream.core.reflect.ReflectHelper;
import org.dromara.streamquery.stream.plugin.mybatisplus.Database;
import org.dromara.streamquery.stream.plugin.mybatisplus.engine.configuration.StreamPluginConfig;
import org.dromara.streamquery.stream.plugin.mybatisplus.engine.configuration.StreamPluginProperties;
import org.dromara.streamquery.stream.plugin.mybatisplus.engine.configuration.StreamScannerConfigurer;
import org.dromara.streamquery.stream.plugin.mybatisplus.engine.handler.JsonPostInitTableInfoHandler;
import org.dromara.streamquery.stream.plugin.mybatisplus.engine.mapper.DynamicMapperHandler;
import org.dromara.streamquery.stream.plugin.mybatisplus.engine.methods.SaveOneSql;
import org.dromara.streamquery.stream.plugin.mybatisplus.engine.methods.UpdateOneSql;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.core.annotation.Order;

@EnableConfigurationProperties(value={StreamPluginProperties.class})
public class StreamPluginAutoConfiguration {
    private static final String CURRENT_NAMESPACE = LambdaHelper.getPropertyName(TableInfo::getCurrentNamespace);

    public StreamPluginAutoConfiguration(StreamPluginProperties properties) {
        StreamPluginConfig.setSafeModeEnabled(properties.isSafeMode());
    }

    @Bean
    @Order
    @ConditionalOnMissingBean(value={DefaultSqlInjector.class})
    public DefaultSqlInjector defaultSqlInjector() {
        return new DefaultSqlInjector(){

            public List<AbstractMethod> getMethodList(Class<?> mapperClass, TableInfo tableInfo) {
                List methodList = super.getMethodList(mapperClass, tableInfo);
                methodList.add(new SaveOneSql());
                methodList.add(new UpdateOneSql());
                return methodList;
            }

            public void inspectInject(MapperBuilderAssistant builderAssistant, Class<?> mapperClass) {
                super.inspectInject(builderAssistant, mapperClass);
                Class modelClass = ReflectionKit.getSuperClassGenericType(mapperClass, Mapper.class, (int)0);
                if (modelClass == null) {
                    return;
                }
                TableInfo tableInfo = TableInfoHelper.initTableInfo((MapperBuilderAssistant)builderAssistant, (Class)modelClass);
                if (Database.isDynamicMapper(tableInfo.getCurrentNamespace()) && !mapperClass.getName().equals(tableInfo.getCurrentNamespace())) {
                    ReflectHelper.setFieldValue((Object)tableInfo, (String)CURRENT_NAMESPACE, (Object)mapperClass.getName());
                }
                if (!Database.isDynamicMapper(mapperClass.getName())) {
                    Database.getEntityMapperClassCache().put(modelClass, mapperClass);
                }
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={DynamicMapperHandler.class})
    public DynamicMapperHandler dynamicMapperHandler(SqlSessionFactory sqlSessionFactory, StreamScannerConfigurer streamScannerConfigurer) {
        return new DynamicMapperHandler(sqlSessionFactory, streamScannerConfigurer.getEntityClasses());
    }

    @Bean
    @ConditionalOnMissingBean(value={JsonPostInitTableInfoHandler.class})
    public JsonPostInitTableInfoHandler jsonPostInitTableInfoHandler() {
        return new JsonPostInitTableInfoHandler();
    }
}

