/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.streamquery.stream.plugin.mybatisplus.engine.interceptor;

import com.baomidou.mybatisplus.extension.plugins.handler.TenantLineHandler;
import com.baomidou.mybatisplus.extension.plugins.inner.TenantLineInnerInterceptor;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.insert.Insert;
import org.dromara.streamquery.stream.plugin.mybatisplus.engine.configuration.StreamPluginConfig;
import org.dromara.streamquery.stream.plugin.mybatisplus.engine.utils.SqlInjectionUtilSq;

public class SqTenantLineInnerInterceptor
extends TenantLineInnerInterceptor {
    public SqTenantLineInnerInterceptor(TenantLineHandler tenantLineHandler) {
        super(tenantLineHandler);
    }

    protected void processInsert(Insert insert, int index, String sql, Object obj) {
        this.checkTenantId();
        super.processInsert(insert, index, sql, obj);
    }

    public Expression buildTableExpression(Table table, Expression where, String whereSegment) {
        this.checkTenantId();
        return super.buildTableExpression(table, where, whereSegment);
    }

    private void checkTenantId() {
        StringValue stringValue;
        String tenantIdStr;
        if (!StreamPluginConfig.isSafeModeEnabled()) {
            return;
        }
        Expression tenantId = this.getTenantLineHandler().getTenantId();
        if (tenantId instanceof StringValue && SqlInjectionUtilSq.check(tenantIdStr = (stringValue = (StringValue)tenantId).getValue())) {
            throw new IllegalArgumentException("SQL Injection attempt detected in 'TenantLineInnerInterceptor'");
        }
    }
}

