/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core;

import java.lang.reflect.Constructor;
import java.util.function.Supplier;
import org.dromara.warm.flow.core.config.WarmFlow;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.Form;
import org.dromara.warm.flow.core.entity.HisTask;
import org.dromara.warm.flow.core.entity.Instance;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.entity.Task;
import org.dromara.warm.flow.core.entity.User;
import org.dromara.warm.flow.core.handler.DataFillHandler;
import org.dromara.warm.flow.core.handler.PermissionHandler;
import org.dromara.warm.flow.core.handler.TenantHandler;
import org.dromara.warm.flow.core.invoker.FrameInvoker;
import org.dromara.warm.flow.core.json.JsonConvert;
import org.dromara.warm.flow.core.listener.GlobalListener;
import org.dromara.warm.flow.core.service.ChartService;
import org.dromara.warm.flow.core.service.DefService;
import org.dromara.warm.flow.core.service.FormService;
import org.dromara.warm.flow.core.service.HisTaskService;
import org.dromara.warm.flow.core.service.InsService;
import org.dromara.warm.flow.core.service.NodeService;
import org.dromara.warm.flow.core.service.SkipService;
import org.dromara.warm.flow.core.service.TaskService;
import org.dromara.warm.flow.core.service.UserService;
import org.dromara.warm.flow.core.utils.ClassUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StringUtils;

public class FlowEngine {
    private static final DefService defService = null;
    private static final NodeService nodeService = null;
    private static final SkipService skipService = null;
    private static final InsService insService = null;
    private static final TaskService taskService = null;
    private static final HisTaskService hisTaskService = null;
    private static final UserService userService = null;
    private static final FormService formService = null;
    private static final ChartService chartService = null;
    private static Supplier<Definition> defSupplier;
    private static Supplier<Node> nodeSupplier;
    private static Supplier<Skip> skipSupplier;
    private static Supplier<Instance> insSupplier;
    private static Supplier<Task> taskSupplier;
    private static Supplier<HisTask> hisTaskSupplier;
    private static Supplier<User> userSupplier;
    private static Supplier<Form> formSupplier;
    private static WarmFlow flowConfig;
    private static DataFillHandler dataFillHandler;
    private static TenantHandler tenantHandler;
    private static PermissionHandler permissionHandler;
    private static GlobalListener globalListener;
    public static JsonConvert jsonConvert;

    public static DefService defService() {
        return FlowEngine.getObj(defService, DefService.class);
    }

    public static NodeService nodeService() {
        return FlowEngine.getObj(nodeService, NodeService.class);
    }

    public static SkipService skipService() {
        return FlowEngine.getObj(skipService, SkipService.class);
    }

    public static InsService insService() {
        return FlowEngine.getObj(insService, InsService.class);
    }

    public static TaskService taskService() {
        return FlowEngine.getObj(taskService, TaskService.class);
    }

    public static HisTaskService hisTaskService() {
        return FlowEngine.getObj(hisTaskService, HisTaskService.class);
    }

    public static UserService userService() {
        return FlowEngine.getObj(userService, UserService.class);
    }

    public static FormService formService() {
        return FlowEngine.getObj(formService, FormService.class);
    }

    public static ChartService chartService() {
        return FlowEngine.getObj(chartService, ChartService.class);
    }

    public static void setNewDef(Supplier<Definition> supplier) {
        defSupplier = supplier;
    }

    public static Definition newDef() {
        return defSupplier.get();
    }

    public static void setNewNode(Supplier<Node> supplier) {
        nodeSupplier = supplier;
    }

    public static Node newNode() {
        return nodeSupplier.get();
    }

    public static void setNewSkip(Supplier<Skip> supplier) {
        skipSupplier = supplier;
    }

    public static Skip newSkip() {
        return skipSupplier.get();
    }

    public static void setNewIns(Supplier<Instance> supplier) {
        insSupplier = supplier;
    }

    public static Instance newIns() {
        return insSupplier.get();
    }

    public static void setNewTask(Supplier<Task> supplier) {
        taskSupplier = supplier;
    }

    public static Task newTask() {
        return taskSupplier.get();
    }

    public static void setNewHisTask(Supplier<HisTask> supplier) {
        hisTaskSupplier = supplier;
    }

    public static HisTask newHisTask() {
        return hisTaskSupplier.get();
    }

    public static void setNewUser(Supplier<User> supplier) {
        userSupplier = supplier;
    }

    public static User newUser() {
        return userSupplier.get();
    }

    public static void setNewForm(Supplier<Form> supplier) {
        formSupplier = supplier;
    }

    public static Form newForm() {
        return formSupplier.get();
    }

    public static WarmFlow getFlowConfig() {
        return flowConfig;
    }

    public static void setFlowConfig(WarmFlow flowConfig) {
        FlowEngine.flowConfig = flowConfig;
    }

    public static void initDataFillHandler(String handlerPath) {
        dataFillHandler = FlowEngine.initBean(DataFillHandler.class, handlerPath, () -> new DataFillHandler(){});
    }

    public static void initTenantHandler(String handlerPath) {
        tenantHandler = FlowEngine.initBean(TenantHandler.class, handlerPath, null);
    }

    public static void initPermissionHandler() {
        permissionHandler = FlowEngine.initBean(PermissionHandler.class, null, null);
    }

    public static void initGlobalListener() {
        globalListener = FlowEngine.initBean(GlobalListener.class, null, null);
    }

    public static DataFillHandler dataFillHandler() {
        return dataFillHandler;
    }

    public static PermissionHandler permissionHandler() {
        return permissionHandler;
    }

    public static TenantHandler tenantHandler() {
        return tenantHandler;
    }

    public static GlobalListener globalListener() {
        return globalListener;
    }

    public static String dataSourceType() {
        return flowConfig.getDataSourceType();
    }

    public static <T> T getObj(T t, Class<T> tClass) {
        if (ObjectUtil.isNotNull(t)) {
            return t;
        }
        t = FrameInvoker.getBean(tClass);
        return t;
    }

    private static <T> T initBean(Class<T> tClazz, String beanPath, Supplier<T> supplier) {
        T hander = null;
        try {
            Class<?> clazz;
            if (!StringUtils.isEmpty(beanPath) && (clazz = ClassUtil.getClazz(beanPath)) != null && tClazz.isAssignableFrom(clazz)) {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                hander = tClazz.cast(constructor.newInstance(new Object[0]));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (hander == null) {
            hander = FrameInvoker.getBean(tClazz);
        }
        if (hander == null && supplier != null) {
            hander = supplier.get();
        }
        return hander;
    }
}

