/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.chart;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.util.ArrayList;
import java.util.List;
import org.dromara.warm.flow.core.chart.FlowChart;
import org.dromara.warm.flow.core.chart.TextChart;
import org.dromara.warm.flow.core.dto.NodeJson;
import org.dromara.warm.flow.core.enums.ChartStatus;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StringUtils;

public class BetweenChart
extends FlowChart {
    public Color c;
    private int x;
    private int y;
    private int width = 100;
    private int height = 80;
    private int arcWidth = 20;
    private List<TextChart> textCharts;
    private NodeJson nodeJson;

    public BetweenChart(int x, int y, Color c, List<TextChart> textCharts, NodeJson nodeJson) {
        this.x = x;
        this.y = y;
        this.c = c;
        this.textCharts = CollUtil.isNotEmpty(textCharts) ? textCharts : new ArrayList<TextChart>();
        this.nodeJson = nodeJson;
    }

    @Override
    public void draw(Graphics2D graphics) {
        graphics.setColor(this.lightColor(this.c));
        graphics.fillRoundRect((this.x - 50) * this.n, (this.y - 40) * this.n, this.width * this.n, this.height * this.n, this.arcWidth * this.n, this.arcWidth * this.n);
        graphics.setColor(this.c);
        Stroke originalStroke = graphics.getStroke();
        if (ChartStatus.getToDo().equals(this.c)) {
            float[] dashPattern = new float[]{10.0f, 5.0f};
            BasicStroke dashedStroke = new BasicStroke(2.5f, 0, 0, 10.0f, dashPattern, 0.0f);
            graphics.setStroke(dashedStroke);
        }
        graphics.drawRoundRect((this.x - 50) * this.n, (this.y - 40) * this.n, this.width * this.n, this.height * this.n, this.arcWidth * this.n, this.arcWidth * this.n);
        graphics.setStroke(originalStroke);
        if (CollUtil.isNotEmpty(this.textCharts)) {
            for (int i = 0; i < this.textCharts.size(); ++i) {
                TextChart textChart2 = this.textCharts.get(i);
                if (!ObjectUtil.isNotNull(textChart2) || !StringUtils.isNotEmpty(textChart2.getTitle())) continue;
                String[] lines = textChart2.getTitle().split("\n");
                for (int j = 0; j < lines.length; ++j) {
                    TextChart textChartNew = this.copyText(lines[j], textChart2);
                    if (j == 0) {
                        this.textCharts.set(i, textChartNew);
                        continue;
                    }
                    this.textCharts.add(++i, textChartNew);
                }
            }
            int y = this.y - this.height / 2;
            int unitHeight = this.height / (this.textCharts.size() + 1);
            for (int i = 0; i < this.textCharts.size(); ++i) {
                TextChart textChart3 = this.textCharts.get(i);
                if (!ObjectUtil.isNotNull(textChart3) || !StringUtils.isNotEmpty(textChart3.getTitle())) continue;
                if (textChart3.getX() == null) {
                    textChart3.setX(this.x);
                }
                if (textChart3.getY() != null) continue;
                textChart3.setY(y + (i + 1) * unitHeight);
            }
            this.textCharts.forEach(textChart -> {
                if (ObjectUtil.isNotNull(textChart) && StringUtils.isNotEmpty(textChart.getTitle())) {
                    textChart.setN(this.n).draw(graphics);
                }
            });
        }
    }

    @Override
    public void toOffset(int offsetW, int offsetH) {
        this.x += offsetW;
        this.y += offsetH;
    }

    public TextChart copyText(String title, TextChart orgText) {
        TextChart textChart = new TextChart(title, orgText.getFont());
        if (orgText.getX() != null) {
            textChart.setX(orgText.getX());
        }
        if (orgText.getY() != null) {
            textChart.setY(orgText.getY());
        }
        textChart.setN(orgText.n);
        textChart.setC(orgText.c);
        return textChart;
    }

    public void topText(String title) {
        this.textCharts.add(new TextChart(title).setY(this.y - this.height / 2 - 10));
    }

    public void topText(String title, Color c) {
        this.textCharts.add(new TextChart(title).setC(c).setY(this.y - this.height / 2 - 10));
    }

    public void addText(String title) {
        this.textCharts.add(new TextChart(title));
    }

    public void addText(String title, Color c) {
        this.textCharts.add(new TextChart(title).setC(c));
    }

    public Color getC() {
        return this.c;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getArcWidth() {
        return this.arcWidth;
    }

    public List<TextChart> getTextCharts() {
        return this.textCharts;
    }

    public NodeJson getNodeJson() {
        return this.nodeJson;
    }

    public BetweenChart setC(Color c) {
        this.c = c;
        return this;
    }

    public BetweenChart setX(int x) {
        this.x = x;
        return this;
    }

    public BetweenChart setY(int y) {
        this.y = y;
        return this;
    }

    public BetweenChart setWidth(int width) {
        this.width = width;
        return this;
    }

    public BetweenChart setHeight(int height) {
        this.height = height;
        return this;
    }

    public BetweenChart setArcWidth(int arcWidth) {
        this.arcWidth = arcWidth;
        return this;
    }

    public BetweenChart setTextCharts(List<TextChart> textCharts) {
        this.textCharts = textCharts;
        return this;
    }

    public BetweenChart setNodeJson(NodeJson nodeJson) {
        this.nodeJson = nodeJson;
        return this;
    }
}

