/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.chart;

import java.awt.Color;
import java.awt.Graphics2D;
import org.dromara.warm.flow.core.enums.ChartStatus;

public abstract class FlowChart {
    public int n;
    public boolean offsetEnable = true;

    abstract void draw(Graphics2D var1);

    public Color lightColor(Color c) {
        if (ChartStatus.getNotDone().equals(c)) {
            return Color.WHITE;
        }
        float red = (float)c.getRed() / 255.0f;
        float green = (float)c.getGreen() / 255.0f;
        float blue = (float)c.getBlue() / 255.0f;
        float alpha = 0.15f;
        return new Color(red, green, blue, alpha);
    }

    public void offset(int offsetW, int offsetH) {
        if (this.offsetEnable) {
            this.toOffset(offsetW, offsetH);
        }
    }

    public void toOffset(int offsetW, int offsetH) {
    }

    public int getN() {
        return this.n;
    }

    public boolean isOffsetEnable() {
        return this.offsetEnable;
    }

    public FlowChart setN(int n) {
        this.n = n;
        return this;
    }

    public FlowChart setOffsetEnable(boolean offsetEnable) {
        this.offsetEnable = offsetEnable;
        return this;
    }
}

