/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.chart;

import java.awt.BasicStroke;
import java.awt.Font;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.List;
import org.dromara.warm.flow.core.chart.BetweenChart;
import org.dromara.warm.flow.core.chart.FlowChart;
import org.dromara.warm.flow.core.chart.TextChart;
import org.dromara.warm.flow.core.enums.ChartStatus;
import org.dromara.warm.flow.core.utils.CollUtil;

public class FlowChartChain {
    private int width;
    private int height;
    private int n;
    private final List<FlowChart> flowChartList = new ArrayList<FlowChart>();

    public void addFlowChart(FlowChart flowChart) {
        this.flowChartList.add(flowChart);
    }

    public void draw(int width, int height, int offsetW, int offsetH, Graphics2D graphics, int n) {
        this.width = width;
        this.height = height;
        this.n = n;
        this.setExample(width, n);
        this.setFlowTitle(width, height, n);
        for (FlowChart flowChart : this.flowChartList) {
            flowChart.offset(offsetW, offsetH);
        }
        graphics.setStroke(new BasicStroke(2.5f));
        for (FlowChart flowChart : this.flowChartList) {
            flowChart.setN(n).draw(graphics);
        }
    }

    private void setFlowTitle(int width, int height, int n) {
        int textX = (width - 400) / n;
        int textY = (height - 50) / n;
        Font font = new Font("\u5fae\u8f6f\u96c5\u9ed1", 1, 20 * n);
        String title = "Warm-Flow";
        TextChart textChart = new TextChart(textX, textY, title, font).setAlpha(0.8f);
        textChart.setOffsetEnable(false);
        this.addFlowChart(textChart);
    }

    private void setExample(int width, int n) {
        int tmp = width - 600;
        for (ChartStatus value : ChartStatus.values()) {
            int nodeX = tmp / n + 50;
            int nodeY = 40;
            int textX = nodeX - 20;
            int textY = nodeY - 25;
            TextChart textChart = new TextChart(textX, textY, value.getValue());
            this.addFlowChart(new BetweenChart(nodeX, nodeY, ChartStatus.getColorByKey(value), CollUtil.toList(textChart), null).setWidth(60).setHeight(20).setArcWidth(5).setOffsetEnable(false));
            tmp += 140;
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getN() {
        return this.n;
    }

    public List<FlowChart> getFlowChartList() {
        return this.flowChartList;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setN(int n) {
        this.n = n;
    }
}

