/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.chart;

import java.awt.Color;
import java.awt.Graphics2D;
import org.dromara.warm.flow.core.chart.FlowChart;
import org.dromara.warm.flow.core.chart.TextChart;
import org.dromara.warm.flow.core.dto.NodeJson;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StringUtils;

public class OvalChart
extends FlowChart {
    public Color c;
    private int x;
    private int y;
    private TextChart textChart;
    private NodeJson nodeJson;

    public OvalChart(int x, int y, Color c, TextChart textChart, NodeJson nodeJson) {
        this.x = x;
        this.y = y;
        this.c = c;
        this.textChart = textChart;
        this.nodeJson = nodeJson;
    }

    @Override
    public void draw(Graphics2D graphics) {
        graphics.setColor(this.lightColor(this.c));
        graphics.fillOval((this.x - 20) * this.n, (this.y - 20) * this.n, 40 * this.n, 40 * this.n);
        graphics.setColor(this.c);
        graphics.drawOval((this.x - 20) * this.n, (this.y - 20) * this.n, 40 * this.n, 40 * this.n);
        if (ObjectUtil.isNotNull(this.textChart) && StringUtils.isNotEmpty(this.textChart.getTitle())) {
            this.textChart.setY(this.y + 5);
            this.textChart.setN(this.n).draw(graphics);
        }
    }

    @Override
    public void toOffset(int offsetW, int offsetH) {
        this.x += offsetW;
        this.y += offsetH;
        if (ObjectUtil.isNotNull(this.textChart) && StringUtils.isNotEmpty(this.textChart.getTitle())) {
            this.textChart.offset(offsetW, offsetH);
        }
    }

    public Color getC() {
        return this.c;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public TextChart getTextChart() {
        return this.textChart;
    }

    public NodeJson getNodeJson() {
        return this.nodeJson;
    }

    public OvalChart setC(Color c) {
        this.c = c;
        return this;
    }

    public OvalChart setX(int x) {
        this.x = x;
        return this;
    }

    public OvalChart setY(int y) {
        this.y = y;
        return this;
    }

    public OvalChart setTextChart(TextChart textChart) {
        this.textChart = textChart;
        return this;
    }

    public OvalChart setNodeJson(NodeJson nodeJson) {
        this.nodeJson = nodeJson;
        return this;
    }
}

