/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.chart;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import org.dromara.warm.flow.core.chart.FlowChart;

public class TextChart
extends FlowChart {
    public Color c;
    private Integer x;
    private Integer y;
    private String title;
    private Font font;
    private float alpha = 1.0f;

    public TextChart(String title) {
        this.title = title;
    }

    public TextChart(int x, int y, String title) {
        this.x = x;
        this.y = y;
        this.title = title;
    }

    public TextChart(String title, Font font) {
        this.title = title;
        this.font = font;
    }

    public TextChart(int x, int y, String title, Font font) {
        this.x = x;
        this.y = y;
        this.title = title;
        this.font = font;
    }

    @Override
    public void draw(Graphics2D graphics) {
        graphics.setColor(this.c == null ? Color.BLACK : this.c);
        if (this.font != null) {
            graphics.setFont(this.font);
        }
        graphics.setComposite(AlphaComposite.getInstance(3, this.alpha));
        this.setX(this.getX() - graphics.getFontMetrics().stringWidth(this.title) / (2 * this.n));
        graphics.drawString(this.title, this.x * this.n, this.y * this.n);
    }

    @Override
    public void toOffset(int offsetW, int offsetH) {
        TextChart textChart = this;
        textChart.x = textChart.x + offsetW;
        textChart = this;
        textChart.y = textChart.y + offsetH;
    }

    public Color getC() {
        return this.c;
    }

    public Integer getX() {
        return this.x;
    }

    public Integer getY() {
        return this.y;
    }

    public String getTitle() {
        return this.title;
    }

    public Font getFont() {
        return this.font;
    }

    public float getAlpha() {
        return this.alpha;
    }

    public TextChart setC(Color c) {
        this.c = c;
        return this;
    }

    public TextChart setX(Integer x) {
        this.x = x;
        return this;
    }

    public TextChart setY(Integer y) {
        this.y = y;
        return this;
    }

    public TextChart setTitle(String title) {
        this.title = title;
        return this;
    }

    public TextChart setFont(Font font) {
        this.font = font;
        return this;
    }

    public TextChart setAlpha(float alpha) {
        this.alpha = alpha;
        return this;
    }
}

