/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.dto;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.dto.DefChart;
import org.dromara.warm.flow.core.dto.FlowCombine;
import org.dromara.warm.flow.core.dto.NodeJson;
import org.dromara.warm.flow.core.dto.SkipJson;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.utils.CollUtil;

public class DefJson {
    private Long id;
    private String flowCode;
    private String flowName;
    private String category;
    private String version;
    private String formCustom;
    private String formPath;
    private String listenerType;
    private String listenerPath;
    private String ext;
    private Map<String, Object> extMap;
    private List<NodeJson> nodeList = new ArrayList<NodeJson>();
    private List<String> chartStatusColor;
    private String topText;

    public static DefJson copyDef(Definition definition) {
        DefJson defJson = new DefJson().setFlowCode(definition.getFlowCode()).setFlowName(definition.getFlowName()).setVersion(definition.getVersion()).setCategory(definition.getCategory()).setFormCustom(definition.getFormCustom()).setFormPath(definition.getFormPath()).setListenerType(definition.getListenerType()).setListenerPath(definition.getListenerPath()).setExt(definition.getExt());
        ArrayList<NodeJson> nodeList = new ArrayList<NodeJson>();
        defJson.setNodeList(nodeList);
        for (Node node : definition.getNodeList()) {
            NodeJson nodeJson = new NodeJson().setNodeType(node.getNodeType()).setNodeCode(node.getNodeCode()).setNodeName(node.getNodeName()).setPermissionFlag(node.getPermissionFlag()).setNodeRatio(node.getNodeRatio()).setCoordinate(node.getCoordinate()).setAnyNodeSkip(node.getAnyNodeSkip()).setListenerType(node.getListenerType()).setListenerPath(node.getListenerPath()).setHandlerType(node.getHandlerType()).setHandlerPath(node.getHandlerPath()).setFormCustom(node.getFormCustom()).setFormPath(node.getFormPath()).setExt(node.getExt());
            nodeList.add(nodeJson);
            ArrayList<SkipJson> skipList = new ArrayList<SkipJson>();
            nodeJson.setSkipList(skipList);
            if (!CollUtil.isNotEmpty(node.getSkipList())) continue;
            for (Skip skip : node.getSkipList()) {
                skipList.add(new SkipJson().setCoordinate(skip.getCoordinate()).setSkipType(skip.getSkipType()).setSkipName(skip.getSkipName()).setSkipCondition(skip.getSkipCondition()).setNowNodeCode(skip.getNowNodeCode()).setNextNodeCode(skip.getNextNodeCode()));
            }
        }
        return defJson;
    }

    public static Definition copyDef(DefJson defJson) {
        Definition definition = FlowEngine.newDef().setId(defJson.getId()).setFlowCode(defJson.getFlowCode()).setFlowName(defJson.getFlowName()).setVersion(defJson.getVersion()).setCategory(defJson.getCategory()).setFormCustom(defJson.getFormCustom()).setFormPath(defJson.getFormPath()).setListenerType(defJson.getListenerType()).setListenerPath(defJson.getListenerPath()).setExt(defJson.getExt());
        ArrayList<Node> nodeList = new ArrayList<Node>();
        definition.setNodeList(nodeList);
        for (NodeJson nodeJson : defJson.getNodeList()) {
            Node node = FlowEngine.newNode().setNodeType(nodeJson.getNodeType()).setNodeCode(nodeJson.getNodeCode()).setNodeName(nodeJson.getNodeName()).setPermissionFlag(nodeJson.getPermissionFlag()).setNodeRatio(nodeJson.getNodeRatio() != null ? nodeJson.getNodeRatio() : BigDecimal.ZERO).setCoordinate(nodeJson.getCoordinate()).setAnyNodeSkip(nodeJson.getAnyNodeSkip()).setListenerType(nodeJson.getListenerType()).setListenerPath(nodeJson.getListenerPath()).setHandlerType(nodeJson.getHandlerType()).setHandlerPath(nodeJson.getHandlerPath()).setFormCustom(nodeJson.getFormCustom()).setFormPath(nodeJson.getFormPath()).setExt(nodeJson.getExt());
            nodeList.add(node);
            ArrayList<Skip> skipList = new ArrayList<Skip>();
            node.setSkipList(skipList);
            if (!CollUtil.isNotEmpty(nodeJson.getSkipList())) continue;
            for (SkipJson skipJson : nodeJson.getSkipList()) {
                skipList.add(FlowEngine.newSkip().setCoordinate(skipJson.getCoordinate()).setSkipType(skipJson.getSkipType()).setSkipName(skipJson.getSkipName()).setSkipCondition(skipJson.getSkipCondition()).setNowNodeCode(skipJson.getNowNodeCode()).setNextNodeCode(skipJson.getNextNodeCode()));
            }
        }
        return definition;
    }

    public static DefChart copyChart(DefJson defJson) {
        DefChart defChart = new DefChart();
        defChart.setDefJson(defJson);
        defChart.setNodeJsonList(defJson.getNodeList());
        defChart.setSkipJsonList(Optional.of(defJson).map(DefJson::getNodeList).orElse(Collections.emptyList()).stream().map(NodeJson::getSkipList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList()));
        return defChart;
    }

    public static FlowCombine copyCombine(DefJson defJson) {
        Definition definition = DefJson.copyDef(defJson);
        FlowCombine flowCombine = new FlowCombine();
        flowCombine.setDefinition(definition);
        flowCombine.setAllNodes(definition.getNodeList());
        List<Skip> skipList = Optional.of(definition).map(Definition::getNodeList).orElse(Collections.emptyList()).stream().map(Node::getSkipList).filter(Objects::nonNull).flatMap(Collection::stream).collect(Collectors.toList());
        flowCombine.setAllSkips(skipList);
        return flowCombine;
    }

    public DefJson setId(Long id) {
        this.id = id;
        return this;
    }

    public DefJson setFlowCode(String flowCode) {
        this.flowCode = flowCode;
        return this;
    }

    public DefJson setFlowName(String flowName) {
        this.flowName = flowName;
        return this;
    }

    public DefJson setCategory(String category) {
        this.category = category;
        return this;
    }

    public DefJson setVersion(String version) {
        this.version = version;
        return this;
    }

    public DefJson setFormCustom(String formCustom) {
        this.formCustom = formCustom;
        return this;
    }

    public DefJson setFormPath(String formPath) {
        this.formPath = formPath;
        return this;
    }

    public DefJson setListenerType(String listenerType) {
        this.listenerType = listenerType;
        return this;
    }

    public DefJson setListenerPath(String listenerPath) {
        this.listenerPath = listenerPath;
        return this;
    }

    public DefJson setExt(String ext) {
        this.ext = ext;
        return this;
    }

    public DefJson setExtMap(Map<String, Object> extMap) {
        this.extMap = extMap;
        return this;
    }

    public DefJson setNodeList(List<NodeJson> nodeList) {
        this.nodeList = nodeList;
        return this;
    }

    public DefJson setChartStatusColor(List<String> chartStatusColor) {
        this.chartStatusColor = chartStatusColor;
        return this;
    }

    public DefJson setTopText(String topText) {
        this.topText = topText;
        return this;
    }

    public Long getId() {
        return this.id;
    }

    public String getFlowCode() {
        return this.flowCode;
    }

    public String getFlowName() {
        return this.flowName;
    }

    public String getCategory() {
        return this.category;
    }

    public String getVersion() {
        return this.version;
    }

    public String getFormCustom() {
        return this.formCustom;
    }

    public String getFormPath() {
        return this.formPath;
    }

    public String getListenerType() {
        return this.listenerType;
    }

    public String getListenerPath() {
        return this.listenerPath;
    }

    public String getExt() {
        return this.ext;
    }

    public Map<String, Object> getExtMap() {
        return this.extMap;
    }

    public List<NodeJson> getNodeList() {
        return this.nodeList;
    }

    public List<String> getChartStatusColor() {
        return this.chartStatusColor;
    }

    public String getTopText() {
        return this.topText;
    }

    public String toString() {
        return "DefJson(id=" + this.getId() + ", flowCode=" + this.getFlowCode() + ", flowName=" + this.getFlowName() + ", category=" + this.getCategory() + ", version=" + this.getVersion() + ", formCustom=" + this.getFormCustom() + ", formPath=" + this.getFormPath() + ", listenerType=" + this.getListenerType() + ", listenerPath=" + this.getListenerPath() + ", ext=" + this.getExt() + ", extMap=" + this.getExtMap() + ", nodeList=" + this.getNodeList() + ", chartStatusColor=" + this.getChartStatusColor() + ", topText=" + this.getTopText() + ")";
    }
}

