/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.enums;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StringUtils;

public enum ChartStatus {
    NOT_DONE(0, "\u672a\u529e\u7406", new Color(0, 0, 0)),
    TO_DO(1, "\u5f85\u529e\u7406", new Color(255, 205, 23)),
    DONE(2, "\u5df2\u529e\u7406", new Color(157, 255, 0));

    private final Integer key;
    private final String value;
    private final Color color;
    private static final Map<Integer, Color> CUSTOM_COLOR;

    public static void initCustomColor(List<String> chartStatusColor) {
        if (CollUtil.isNotEmpty(chartStatusColor) && chartStatusColor.size() == 3) {
            for (int i = 0; i < chartStatusColor.size(); ++i) {
                String[] colorArr;
                String statusColor = chartStatusColor.get(i);
                if (!StringUtils.isNotEmpty(statusColor) || (colorArr = statusColor.split(",")).length != 3) continue;
                CUSTOM_COLOR.put(i, new Color(Integer.parseInt(colorArr[0]), Integer.parseInt(colorArr[1]), Integer.parseInt(colorArr[2])));
            }
        }
    }

    public static Color getNotDone() {
        return ChartStatus.getColorByKey(NOT_DONE);
    }

    public static Color getToDo() {
        return ChartStatus.getColorByKey(TO_DO);
    }

    public static Color getDone() {
        return ChartStatus.getColorByKey(DONE);
    }

    public static Color getColorByKey(ChartStatus chartStatus) {
        Color color = CUSTOM_COLOR.get(chartStatus.getKey());
        return ObjectUtil.defaultNull(color, chartStatus.getColor());
    }

    public static Color getColorByKey(Integer key) {
        for (ChartStatus item : ChartStatus.values()) {
            if (!item.getKey().equals(key)) continue;
            Color color = CUSTOM_COLOR.get(key);
            return ObjectUtil.defaultNull(color, item.getColor());
        }
        return null;
    }

    public static Boolean isNotDone(Integer key) {
        return ObjectUtil.isNotNull(key) && NOT_DONE.getKey().equals(key);
    }

    public static Boolean isToDo(Integer key) {
        return ObjectUtil.isNotNull(key) && TO_DO.getKey().equals(key);
    }

    public static Boolean isDone(Integer key) {
        return ObjectUtil.isNotNull(key) && DONE.getKey().equals(key);
    }

    public Integer getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public Color getColor() {
        return this.color;
    }

    private ChartStatus(Integer key, String value, Color color) {
        this.key = key;
        this.value = value;
        this.color = color;
    }

    static {
        CUSTOM_COLOR = new HashMap<Integer, Color>();
    }
}

