/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.service.impl;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.chart.BetweenChart;
import org.dromara.warm.flow.core.chart.FlowChartChain;
import org.dromara.warm.flow.core.chart.OvalChart;
import org.dromara.warm.flow.core.chart.ParallelChart;
import org.dromara.warm.flow.core.chart.SerialChart;
import org.dromara.warm.flow.core.chart.SkipChart;
import org.dromara.warm.flow.core.chart.TextChart;
import org.dromara.warm.flow.core.dto.DefJson;
import org.dromara.warm.flow.core.dto.NodeJson;
import org.dromara.warm.flow.core.dto.PathWayData;
import org.dromara.warm.flow.core.dto.SkipJson;
import org.dromara.warm.flow.core.entity.Instance;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.enums.ChartStatus;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.enums.SkipType;
import org.dromara.warm.flow.core.exception.FlowException;
import org.dromara.warm.flow.core.service.ChartService;
import org.dromara.warm.flow.core.utils.Base64;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StreamUtils;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChartServiceImpl
implements ChartService {
    private static final Logger log = LoggerFactory.getLogger(ChartServiceImpl.class);

    @Override
    public String startMetadata(PathWayData pathWayData) {
        DefJson defJson = FlowEngine.defService().queryDesign(pathWayData.getDefId());
        List<NodeJson> nodeList = defJson.getNodeList();
        Map<String, NodeJson> nodeMap = StreamUtils.toMap(nodeList, NodeJson::getNodeCode, node -> node.setStatus(ChartStatus.NOT_DONE.getKey()));
        Map<String, SkipJson> skipMap = nodeList.stream().map(NodeJson::getSkipList).flatMap(Collection::stream).collect(Collectors.toMap(this::getSkipKey, skip -> skip.setStatus(ChartStatus.NOT_DONE.getKey())));
        pathWayData.getPathWayNodes().forEach(node -> ((NodeJson)nodeMap.get(node.getNodeCode())).setStatus(ChartStatus.DONE.getKey()));
        pathWayData.getPathWaySkips().forEach(skip -> ((SkipJson)skipMap.get(this.getSkipKey((Skip)skip))).setStatus(ChartStatus.DONE.getKey()));
        pathWayData.getTargetNodes().forEach(node -> ((NodeJson)nodeMap.get(node.getNodeCode())).setStatus(NodeType.isEnd(node.getNodeType()) != false ? ChartStatus.DONE.getKey() : ChartStatus.TO_DO.getKey()));
        return FlowEngine.jsonConvert.objToStr(defJson);
    }

    @Override
    public String skipMetadata(PathWayData pathWayData) {
        Instance instance = (Instance)FlowEngine.insService().getById(pathWayData.getInsId());
        DefJson defJson = FlowEngine.jsonConvert.strToBean(instance.getDefJson(), DefJson.class);
        List<NodeJson> nodeList = defJson.getNodeList();
        List skipList = StreamUtils.toListAll(defJson.getNodeList(), NodeJson::getSkipList);
        Map<String, NodeJson> nodeMap = StreamUtils.toMap(nodeList, NodeJson::getNodeCode, node -> node);
        Map<String, SkipJson> skipMap = StreamUtils.toMap(skipList, this::getSkipKey, skip -> skip);
        pathWayData.getPathWayNodes().forEach(node -> {
            NodeJson nodeJson = (NodeJson)nodeMap.get(node.getNodeCode());
            if (SkipType.isPass(pathWayData.getSkipType()).booleanValue()) {
                nodeJson.setStatus(ChartStatus.DONE.getKey());
            } else if (SkipType.isReject(pathWayData.getSkipType()).booleanValue()) {
                nodeJson.setStatus(ChartStatus.NOT_DONE.getKey());
            }
        });
        pathWayData.getPathWaySkips().forEach(skip -> {
            SkipJson skipJson = (SkipJson)skipMap.get(this.getSkipKey((Skip)skip));
            if (SkipType.isPass(pathWayData.getSkipType()).booleanValue()) {
                skipJson.setStatus(ChartStatus.DONE.getKey());
            } else if (SkipType.isReject(pathWayData.getSkipType()).booleanValue()) {
                skipJson.setStatus(ChartStatus.NOT_DONE.getKey());
            }
        });
        pathWayData.getTargetNodes().forEach(node -> {
            NodeJson nodeJson = (NodeJson)nodeMap.get(node.getNodeCode());
            if (NodeType.isEnd(node.getNodeType()).booleanValue()) {
                nodeJson.setStatus(ChartStatus.DONE.getKey());
            } else {
                nodeJson.setStatus(ChartStatus.TO_DO.getKey());
            }
        });
        if (SkipType.isReject(pathWayData.getSkipType()).booleanValue()) {
            Map<String, List<SkipJson>> skipNextMap = StreamUtils.groupByKeyFilter(skip -> SkipType.isReject(skip.getSkipType()) == false, skipList, SkipJson::getNowNodeCode);
            pathWayData.getTargetNodes().forEach(node -> this.rejectReset(node.getNodeCode(), skipNextMap, nodeMap));
        }
        pathWayData.getTargetNodes().forEach(node -> {
            if (NodeType.isEnd(node.getNodeType()).booleanValue()) {
                nodeList.forEach(nodeJson -> {
                    if (ChartStatus.isToDo(nodeJson.getStatus()).booleanValue()) {
                        nodeJson.setStatus(ChartStatus.NOT_DONE.getKey());
                    }
                });
            }
        });
        return FlowEngine.jsonConvert.objToStr(defJson);
    }

    @Override
    public List<String> getChartRgb() {
        ArrayList<String> chartStatusColor = new ArrayList<String>();
        Color done = ChartStatus.getDone();
        chartStatusColor.add(done.getRed() + "," + done.getGreen() + "," + done.getBlue());
        Color toDo = ChartStatus.getToDo();
        chartStatusColor.add(toDo.getRed() + "," + toDo.getGreen() + "," + toDo.getBlue());
        Color notDone = ChartStatus.getNotDone();
        chartStatusColor.add(notDone.getRed() + "," + notDone.getGreen() + "," + notDone.getBlue());
        return chartStatusColor;
    }

    private String getSkipKey(SkipJson skip) {
        return StringUtils.join(new String[]{skip.getNowNodeCode(), skip.getSkipType(), skip.getSkipCondition(), skip.getNextNodeCode()}, ":");
    }

    private String getSkipKey(Skip skip) {
        return StringUtils.join(new String[]{skip.getNowNodeCode(), skip.getSkipType(), skip.getSkipCondition(), skip.getNextNodeCode()}, ":");
    }

    private void rejectReset(String nodeCode, Map<String, List<SkipJson>> skipNextMap, Map<String, NodeJson> nodeMap) {
        List<SkipJson> oneNextSkips = skipNextMap.get(nodeCode);
        if (CollUtil.isNotEmpty(oneNextSkips)) {
            oneNextSkips.forEach(oneNextSkip -> {
                if (ObjectUtil.isNotNull(oneNextSkip) && !ChartStatus.isNotDone(oneNextSkip.getStatus()).booleanValue()) {
                    oneNextSkip.setStatus(ChartStatus.NOT_DONE.getKey());
                    NodeJson nodeJson = (NodeJson)nodeMap.get(oneNextSkip.getNextNodeCode());
                    if (ObjectUtil.isNotNull(nodeJson) && !ChartStatus.isNotDone(nodeJson.getStatus()).booleanValue()) {
                        nodeJson.setStatus(ChartStatus.NOT_DONE.getKey());
                        this.rejectReset(nodeJson.getNodeCode(), skipNextMap, nodeMap);
                    }
                }
            });
        }
    }

    private void initStatus(DefJson defJson) {
        List<NodeJson> nodeList = defJson.getNodeList();
        List<SkipJson> skipList = nodeList.stream().map(NodeJson::getSkipList).flatMap(Collection::stream).collect(Collectors.toList());
        nodeList.forEach(node -> node.setStatus(ChartStatus.NOT_DONE.getKey()));
        skipList.forEach(skip -> skip.setStatus(ChartStatus.NOT_DONE.getKey()));
    }

    private String basicFlowChart(List<NodeJson> nodeJsonList, List<SkipJson> skipJsonList, Consumer<FlowChartChain> consumer) {
        try {
            HashMap<String, Integer> chartXY = new HashMap<String, Integer>();
            chartXY.put("minX", 5000);
            chartXY.put("minY", 5000);
            chartXY.put("maxX", 0);
            chartXY.put("maxY", 0);
            FlowChartChain flowChartChain = new FlowChartChain();
            this.addNodeChart(chartXY, nodeJsonList, flowChartChain);
            this.addSkipChart(chartXY, skipJsonList, flowChartChain);
            int n = 2;
            int offset = 100;
            int offsetW = 0;
            int offsetH = 0;
            if ((Integer)chartXY.get("minX") < 0) {
                offsetW = offset - (Integer)chartXY.get("minX");
                chartXY.put("maxX", (Integer)chartXY.get("maxX") + offsetW);
                chartXY.put("minX", 0);
            }
            if ((Integer)chartXY.get("minY") < 0) {
                offsetH = offset - (Integer)chartXY.get("minY");
                chartXY.put("maxY", (Integer)chartXY.get("maxY") + offsetH);
                chartXY.put("minY", 0);
            }
            int width = ((Integer)chartXY.get("maxX") + (Integer)chartXY.get("minX")) * n + offset;
            int height = ((Integer)chartXY.get("maxY") + (Integer)chartXY.get("minY")) * n + offset;
            BufferedImage image = new BufferedImage(width, height, 1);
            Graphics2D graphics = image.createGraphics();
            graphics.setStroke(new BasicStroke(2 * n + 1, 2, 1));
            Font font = new Font("\u5b8b\u4f53", 1, 12 * n);
            graphics.setFont(font);
            graphics.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setColor(Color.WHITE);
            graphics.fillRect(0, 0, width, height);
            consumer.accept(flowChartChain);
            flowChartChain.draw(width, height, offsetW, offsetH, graphics, n);
            graphics.setPaintMode();
            graphics.dispose();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)image, "png", os);
            return Base64.encode(os.toByteArray());
        }
        catch (IOException e) {
            log.error("\u83b7\u53d6\u6d41\u7a0b\u56fe\u5f02\u5e38", (Throwable)e);
            throw new FlowException("\u83b7\u53d6\u6d41\u7a0b\u56fe\u5f02\u5e38");
        }
    }

    private void addNodeChart(Map<String, Integer> chartXY, List<NodeJson> nodeJsonList, FlowChartChain flowChartChain) {
        for (NodeJson nodeJson : nodeJsonList) {
            if (!StringUtils.isNotEmpty(nodeJson.getCoordinate())) continue;
            String[] coordinateSplit = nodeJson.getCoordinate().split("\\|");
            String[] nodeSplit = coordinateSplit[0].split(",");
            int nodeX = Integer.parseInt(nodeSplit[0].split("\\.")[0]);
            int nodeY = Integer.parseInt(nodeSplit[1].split("\\.")[0]);
            ChartServiceImpl.setChartXy(chartXY, nodeX, nodeY);
            TextChart textChart = null;
            if (coordinateSplit.length > 1) {
                String[] textSplit = coordinateSplit[1].split(",");
                int textX = Integer.parseInt(textSplit[0].split("\\.")[0]);
                int textY = Integer.parseInt(textSplit[1].split("\\.")[0]);
                textChart = NodeType.isBetween(nodeJson.getNodeType()) != false ? new TextChart(nodeJson.getNodeName()) : new TextChart(textX, textY, nodeJson.getNodeName());
            }
            Color c = ChartStatus.getColorByKey(nodeJson.getStatus());
            if (NodeType.isStart(nodeJson.getNodeType()).booleanValue()) {
                flowChartChain.addFlowChart(new OvalChart(nodeX, nodeY, c, textChart, nodeJson));
                continue;
            }
            if (NodeType.isBetween(nodeJson.getNodeType()).booleanValue()) {
                flowChartChain.addFlowChart(new BetweenChart(nodeX, nodeY, c, CollUtil.toList(textChart), nodeJson));
                continue;
            }
            if (NodeType.isGateWaySerial(nodeJson.getNodeType()).booleanValue()) {
                flowChartChain.addFlowChart(new SerialChart(nodeX, nodeY, c, textChart, nodeJson));
                continue;
            }
            if (NodeType.isGateWayParallel(nodeJson.getNodeType()).booleanValue()) {
                flowChartChain.addFlowChart(new ParallelChart(nodeX, nodeY, c, nodeJson));
                continue;
            }
            if (!NodeType.isEnd(nodeJson.getNodeType()).booleanValue()) continue;
            flowChartChain.addFlowChart(new OvalChart(nodeX, nodeY, c, textChart, nodeJson));
        }
    }

    private static void setChartXy(Map<String, Integer> chartXY, int nodeX, int nodeY) {
        if (nodeX > chartXY.get("maxX")) {
            chartXY.put("maxX", nodeX);
        }
        if (nodeX < chartXY.get("minX")) {
            chartXY.put("minX", nodeX);
        }
        if (nodeY > chartXY.get("maxY")) {
            chartXY.put("maxY", nodeY);
        }
        if (nodeY < chartXY.get("minY")) {
            chartXY.put("minY", nodeY);
        }
    }

    private void addSkipChart(Map<String, Integer> chartXY, List<SkipJson> skipJsonList, FlowChartChain flowChartChain) {
        for (SkipJson skipJson : skipJsonList) {
            if (!StringUtils.isNotEmpty(skipJson.getCoordinate())) continue;
            String[] coordinateSplit = skipJson.getCoordinate().split("\\|");
            TextChart textChart = null;
            if (coordinateSplit.length > 1) {
                String[] textSplit = coordinateSplit[1].split(",");
                int textX = Integer.parseInt(textSplit[0].split("\\.")[0]);
                int textY = Integer.parseInt(textSplit[1].split("\\.")[0]);
                textChart = new TextChart(textX, textY, skipJson.getSkipName());
            }
            String[] skipSplit = coordinateSplit[0].split(";");
            int[] skipX = new int[skipSplit.length];
            int[] skipY = new int[skipSplit.length];
            for (int i = 0; i < skipSplit.length; ++i) {
                skipX[i] = Integer.parseInt(skipSplit[i].split(",")[0].split("\\.")[0]);
                skipY[i] = Integer.parseInt(skipSplit[i].split(",")[1].split("\\.")[0]);
                ChartServiceImpl.setChartXy(chartXY, skipX[i], skipY[i]);
            }
            Color c = ChartStatus.getColorByKey(skipJson.getStatus());
            flowChartChain.addFlowChart(new SkipChart(skipX, skipY, c, textChart));
        }
    }
}

