/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.service.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.dto.DefJson;
import org.dromara.warm.flow.core.dto.FlowCombine;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.Instance;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.enums.ActivityStatus;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.enums.PublishStatus;
import org.dromara.warm.flow.core.enums.SkipType;
import org.dromara.warm.flow.core.exception.FlowException;
import org.dromara.warm.flow.core.orm.dao.FlowDefinitionDao;
import org.dromara.warm.flow.core.orm.service.impl.WarmServiceImpl;
import org.dromara.warm.flow.core.service.DefService;
import org.dromara.warm.flow.core.utils.AssertUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.FlowConfigUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefServiceImpl
extends WarmServiceImpl<FlowDefinitionDao<Definition>, Definition>
implements DefService {
    private static final Logger log = LoggerFactory.getLogger(DefServiceImpl.class);

    public DefService setDao(FlowDefinitionDao<Definition> warmDao) {
        this.warmDao = warmDao;
        return this;
    }

    @Override
    public Definition importIs(InputStream is) {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(is));){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            throw new FlowException("\u8bfb\u53d6is\u6d41\u5931\u8d25");
        }
        return this.importJson(stringBuilder.toString());
    }

    @Override
    public Definition importJson(String defJson) {
        return this.importDef(FlowEngine.jsonConvert.strToBean(defJson, DefJson.class));
    }

    @Override
    public Definition importDef(DefJson defJson) {
        Definition definition = DefJson.copyDef(defJson);
        FlowCombine flowCombine = FlowConfigUtil.structureFlow(definition);
        return this.insertFlow(flowCombine.getDefinition(), flowCombine.getAllNodes(), flowCombine.getAllSkips());
    }

    @Override
    public Definition insertFlow(Definition definition, List<Node> nodeList, List<Skip> skipList) {
        definition.setVersion(this.getNewVersion(definition));
        for (Node node : nodeList) {
            node.setVersion(definition.getVersion());
        }
        FlowEngine.defService().save(definition);
        FlowEngine.nodeService().saveBatch(nodeList);
        FlowEngine.skipService().saveBatch(skipList);
        return definition;
    }

    @Override
    public boolean saveAndInitNode(Definition definition) {
        definition.setVersion(this.getNewVersion(definition));
        FlowEngine.dataFillHandler().idFill(definition);
        ArrayList<Node> nodeList = new ArrayList<Node>();
        ArrayList<Skip> skipList = new ArrayList<Skip>();
        Node startNode = FlowEngine.newNode().setDefinitionId(definition.getId()).setNodeCode(NodeType.START.getValue()).setNodeName("\u5f00\u59cb").setNodeType(NodeType.START.getKey()).setCoordinate("260,200|260,200").setNodeRatio(BigDecimal.ZERO).setVersion(definition.getVersion());
        nodeList.add(startNode);
        Node betweenOneNode = FlowEngine.newNode().setDefinitionId(definition.getId()).setNodeCode("submit").setNodeName("\u4e2d\u95f4\u8282\u70b9-\u6216\u7b7e1").setNodeType(NodeType.BETWEEN.getKey()).setCoordinate("420,200|420,200").setNodeRatio(BigDecimal.ZERO).setVersion(definition.getVersion());
        nodeList.add(betweenOneNode);
        Node betweenTwoNode = FlowEngine.newNode().setDefinitionId(definition.getId()).setNodeCode("approval").setNodeName("\u4e2d\u95f4\u8282\u70b9-\u6216\u7b7e2").setNodeType(NodeType.BETWEEN.getKey()).setCoordinate("600,200|600,200").setNodeRatio(BigDecimal.ZERO).setVersion(definition.getVersion());
        nodeList.add(betweenTwoNode);
        Node endNode = FlowEngine.newNode().setDefinitionId(definition.getId()).setNodeCode(NodeType.END.getValue()).setNodeName("\u7ed3\u675f").setNodeType(NodeType.END.getKey()).setCoordinate("760,200|760,200").setNodeRatio(BigDecimal.ZERO).setVersion(definition.getVersion());
        nodeList.add(endNode);
        skipList.add(FlowEngine.newSkip().setDefinitionId(definition.getId()).setNowNodeCode(startNode.getNodeCode()).setNowNodeType(startNode.getNodeType()).setNextNodeCode(betweenOneNode.getNodeCode()).setNextNodeType(betweenOneNode.getNodeType()).setSkipType(SkipType.PASS.getKey()).setCoordinate("280,200;370,200"));
        skipList.add(FlowEngine.newSkip().setDefinitionId(definition.getId()).setNowNodeCode(betweenOneNode.getNodeCode()).setNowNodeType(betweenOneNode.getNodeType()).setNextNodeCode(betweenTwoNode.getNodeCode()).setNextNodeType(betweenTwoNode.getNodeType()).setSkipType(SkipType.PASS.getKey()).setCoordinate("470,200;550,200"));
        skipList.add(FlowEngine.newSkip().setDefinitionId(definition.getId()).setNowNodeCode(betweenTwoNode.getNodeCode()).setNowNodeType(betweenTwoNode.getNodeType()).setNextNodeCode(endNode.getNodeCode()).setNextNodeType(endNode.getNodeType()).setSkipType(SkipType.PASS.getKey()).setCoordinate("650,200;740,200"));
        FlowEngine.nodeService().saveBatch(nodeList);
        FlowEngine.skipService().saveBatch(skipList);
        return this.save(definition);
    }

    @Override
    public boolean checkAndSave(Definition definition) {
        return this.save(definition.setVersion(this.getNewVersion(definition)));
    }

    @Override
    public void saveDef(DefJson defJson) {
        if (ObjectUtil.isNull(defJson)) {
            return;
        }
        FlowCombine flowCombine = DefJson.copyCombine(defJson);
        this.checkFlowLegal(flowCombine);
        this.saveNodeAndSkip(flowCombine.getDefinition().getId(), flowCombine);
    }

    @Override
    public String exportJson(Long id) {
        return FlowEngine.jsonConvert.objToStr(DefJson.copyDef(this.getAllDataDefinition(id)));
    }

    @Override
    public Definition getAllDataDefinition(Long id) {
        Definition definition = (Definition)((FlowDefinitionDao)this.getDao()).selectById(id);
        List<Node> nodeList = FlowEngine.nodeService().getByDefId(id);
        definition.setNodeList(nodeList);
        List<Skip> skips = FlowEngine.skipService().getByDefId(id);
        Map<String, List<Skip>> flowSkipMap = skips.stream().collect(Collectors.groupingBy(Skip::getNowNodeCode));
        nodeList.forEach(flowNode -> flowNode.setSkipList((List)flowSkipMap.get(flowNode.getNodeCode())));
        return definition;
    }

    @Override
    public FlowCombine getFlowCombine(Long id) {
        return this.getFlowCombine((Definition)((FlowDefinitionDao)this.getDao()).selectById(id));
    }

    @Override
    public FlowCombine getFlowCombineNoDef(Long id) {
        FlowCombine flowCombine = new FlowCombine();
        flowCombine.setAllNodes(FlowEngine.nodeService().getByDefId(id));
        flowCombine.setAllSkips(FlowEngine.skipService().getByDefId(id));
        return flowCombine;
    }

    @Override
    public FlowCombine getFlowCombine(Definition definition) {
        FlowCombine flowCombine = this.getFlowCombineNoDef(definition.getId());
        flowCombine.setDefinition(definition);
        return flowCombine;
    }

    @Override
    public DefJson queryDesign(Long id) {
        return DefJson.copyDef(this.getAllDataDefinition(id));
    }

    @Override
    public List<Definition> queryByCodeList(List<String> flowCodeList) {
        return ((FlowDefinitionDao)this.getDao()).queryByCodeList(flowCodeList);
    }

    @Override
    public void updatePublishStatus(List<Long> ids, Integer publishStatus) {
        ((FlowDefinitionDao)this.getDao()).updatePublishStatus(ids, publishStatus);
    }

    @Override
    public boolean removeDef(List<Long> ids) {
        ids.forEach(id -> {
            List<Instance> instances = FlowEngine.insService().getByDefId((Long)id);
            AssertUtil.isNotEmpty(instances, "\u6d41\u7a0b\u5b9a\u4e49\u5df2\u5f00\u542f\u8fc7\u5ba1\u6279\u4efb\u52a1\uff0c\u4e0d\u53ef\u64cd\u4f5c!");
        });
        FlowEngine.nodeService().deleteNodeByDefIds(ids);
        FlowEngine.skipService().deleteSkipByDefIds(ids);
        return this.removeByIds(ids);
    }

    @Override
    public boolean publish(Long id) {
        Definition definition = (Definition)this.getById(id);
        List<Definition> definitions = this.getByFlowCode(definition.getFlowCode());
        List<Long> otherDefIds = definitions.stream().filter(item -> !Objects.equals(definition.getId(), item.getId()) && PublishStatus.PUBLISHED.getKey().equals(item.getIsPublish())).map(Definition::getId).collect(Collectors.toList());
        if (CollUtil.isNotEmpty(otherDefIds)) {
            Set<Long> useDefIds;
            List<Instance> instanceList = FlowEngine.insService().listByDefIds(otherDefIds);
            if (CollUtil.isNotEmpty(instanceList) && CollUtil.isNotEmpty(useDefIds = StreamUtils.toSet(instanceList, Instance::getDefinitionId))) {
                this.updatePublishStatus(new ArrayList<Long>(useDefIds), PublishStatus.EXPIRED.getKey());
                otherDefIds.removeIf(useDefIds::contains);
            }
            if (CollUtil.isNotEmpty(otherDefIds)) {
                this.updatePublishStatus(otherDefIds, PublishStatus.UNPUBLISHED.getKey());
            }
        }
        Definition flowDefinition = FlowEngine.newDef();
        flowDefinition.setId(id);
        flowDefinition.setIsPublish(PublishStatus.PUBLISHED.getKey());
        return this.updateById(flowDefinition);
    }

    @Override
    public boolean unPublish(Long id) {
        List<Instance> instances = FlowEngine.insService().getByDefId(id);
        AssertUtil.isNotEmpty(instances, "\u6d41\u7a0b\u5b9a\u4e49\u5df2\u5f00\u542f\u8fc7\u5ba1\u6279\u4efb\u52a1\uff0c\u4e0d\u53ef\u64cd\u4f5c!");
        Definition definition = FlowEngine.newDef().setId(id);
        definition.setIsPublish(PublishStatus.UNPUBLISHED.getKey());
        return this.updateById(definition);
    }

    @Override
    public boolean copyDef(Long id) {
        Definition definition = ((Definition)this.getById(id)).copy();
        definition.setVersion(this.getNewVersion(definition));
        AssertUtil.isNull(definition, "\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u5b58\u5728!");
        List<Node> nodeList = FlowEngine.nodeService().getByDefId(id).stream().map(Node::copy).collect(Collectors.toList());
        List<Skip> skipList = FlowEngine.skipService().getByDefId(id).stream().map(Skip::copy).collect(Collectors.toList());
        FlowEngine.dataFillHandler().idFill(definition);
        nodeList.forEach(node -> node.setDefinitionId(definition.getId()).setVersion(definition.getVersion()));
        FlowEngine.nodeService().saveBatch(nodeList);
        skipList.forEach(skip -> skip.setDefinitionId(definition.getId()));
        FlowEngine.skipService().saveBatch(skipList);
        return this.save(definition);
    }

    @Override
    public boolean active(Long id) {
        Definition definition = (Definition)this.getById(id);
        AssertUtil.isTrue(definition.getActivityStatus().equals(ActivityStatus.ACTIVITY.getKey()), "\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u5df2\u7ecf\u6fc0\u6d3b");
        definition.setActivityStatus(ActivityStatus.ACTIVITY.getKey());
        return this.updateById(definition);
    }

    @Override
    public boolean unActive(Long id) {
        Definition definition = (Definition)this.getById(id);
        AssertUtil.isTrue(definition.getActivityStatus().equals(ActivityStatus.SUSPENDED.getKey()), "\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u5df2\u7ecf\u6302\u8d77");
        definition.setActivityStatus(ActivityStatus.SUSPENDED.getKey());
        return this.updateById(definition);
    }

    @Override
    public List<Definition> getByFlowCode(String flowCode) {
        return this.list(FlowEngine.newDef().setFlowCode(flowCode));
    }

    @Override
    public Definition getPublishByFlowCode(String flowCode) {
        return FlowEngine.defService().getOne(FlowEngine.newDef().setFlowCode(flowCode).setIsPublish(PublishStatus.PUBLISHED.getKey()));
    }

    private String getNewVersion(Definition definition) {
        List<String> flowCodeList = Collections.singletonList(definition.getFlowCode());
        List<Definition> definitions = this.queryByCodeList(flowCodeList);
        int highestVersion = 0;
        String latestNonPositiveVersion = null;
        long latestTimestamp = Long.MIN_VALUE;
        for (Definition otherDef : definitions) {
            if (!definition.getFlowCode().equals(otherDef.getFlowCode())) continue;
            try {
                int version = Integer.parseInt(otherDef.getVersion());
                if (version <= highestVersion) continue;
                highestVersion = version;
            }
            catch (NumberFormatException e) {
                long timestamp = otherDef.getCreateTime().getTime();
                if (timestamp <= latestTimestamp) continue;
                latestTimestamp = timestamp;
                latestNonPositiveVersion = otherDef.getVersion();
            }
        }
        String version = "1";
        if (highestVersion > 0) {
            version = String.valueOf(highestVersion + 1);
        } else if (latestNonPositiveVersion != null) {
            version = latestNonPositiveVersion + "_1";
        }
        return version;
    }

    private void checkFlowLegal(FlowCombine flowCombine) {
        Definition definition = flowCombine.getDefinition();
        String flowName = definition.getFlowName();
        AssertUtil.isEmpty(definition.getFlowCode(), "\u3010" + flowName + "\u3011\u6d41\u7a0bflowCode\u4e3a\u7a7a!");
        List<Node> allNodes = flowCombine.getAllNodes();
        List<Skip> allSkips = flowCombine.getAllSkips();
        Map<String, List<Skip>> skipMap = StreamUtils.groupByKey(allSkips, Skip::getNowNodeCode);
        allNodes.forEach(node -> {
            node.setSkipList((List)skipMap.get(node.getNodeCode()));
            skipMap.remove(node.getNodeCode());
        });
        AssertUtil.isNotEmpty(skipMap, "[" + flowName + "]" + "\u5b58\u5728\u65e0\u7528\u7684\u8df3\u8f6c");
        HashSet<String> nodeCodeSet = new HashSet<String>();
        int startNum = 0;
        for (Node node2 : allNodes) {
            FlowConfigUtil.initNodeAndCondition(node2, definition.getId(), definition.getVersion());
            startNum = FlowConfigUtil.checkStartAndSame(node2, startNum, flowName, nodeCodeSet);
        }
        AssertUtil.isTrue(startNum == 0, "[" + flowName + "]" + "\u6d41\u7a0b\u7f3a\u5c11\u5f00\u59cb\u8282\u70b9!");
        FlowConfigUtil.checkSkipNode(allSkips);
        FlowConfigUtil.validaIsExistDestNode(allSkips, nodeCodeSet);
    }

    private void saveNodeAndSkip(Long defId, FlowCombine flowCombine) {
        List<Node> allNodes = flowCombine.getAllNodes();
        List<Skip> allSkips = flowCombine.getAllSkips();
        FlowEngine.nodeService().remove(FlowEngine.newNode().setDefinitionId(defId));
        FlowEngine.skipService().remove(FlowEngine.newSkip().setDefinitionId(defId));
        allNodes.forEach(node -> node.setId(null).setDefinitionId(defId).setCreateTime(null).setUpdateTime(null));
        allSkips.forEach(skip -> skip.setId(null).setDefinitionId(defId).setCreateTime(null).setUpdateTime(null));
        FlowEngine.nodeService().saveBatch(allNodes);
        FlowEngine.skipService().saveBatch(allSkips);
    }
}

