/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.service.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.dto.FlowCombine;
import org.dromara.warm.flow.core.dto.PathWayData;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.enums.PublishStatus;
import org.dromara.warm.flow.core.enums.SkipType;
import org.dromara.warm.flow.core.orm.dao.FlowNodeDao;
import org.dromara.warm.flow.core.orm.service.impl.WarmServiceImpl;
import org.dromara.warm.flow.core.service.NodeService;
import org.dromara.warm.flow.core.utils.AssertUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ExpressionUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StreamUtils;
import org.dromara.warm.flow.core.utils.StringUtils;

public class NodeServiceImpl
extends WarmServiceImpl<FlowNodeDao<Node>, Node>
implements NodeService {
    public NodeService setDao(FlowNodeDao<Node> warmDao) {
        this.warmDao = warmDao;
        return this;
    }

    @Override
    public List<Node> getPublishByFlowCode(String flowCode) {
        Definition definition = FlowEngine.defService().getOne(FlowEngine.newDef().setFlowCode(flowCode).setIsPublish(PublishStatus.PUBLISHED.getKey()));
        if (ObjectUtil.isNotNull(definition)) {
            return this.list(FlowEngine.newNode().setDefinitionId(definition.getId()));
        }
        return Collections.emptyList();
    }

    @Override
    public List<Node> getByNodeCodes(List<String> nodeCodes, Long definitionId) {
        return ((FlowNodeDao)this.getDao()).getByNodeCodes(nodeCodes, definitionId);
    }

    @Override
    public List<Node> previousNodeList(Long nodeId) {
        Node nowNode = (Node)this.getById(nodeId);
        return this.previousNodeList(nowNode.getDefinitionId(), nowNode.getNodeCode());
    }

    @Override
    public List<Node> previousNodeList(Long definitionId, String nowNodeCode) {
        return this.prefixOrSuffixNodes(definitionId, nowNodeCode, "previous");
    }

    @Override
    public List<Node> suffixNodeList(Long nodeId) {
        Node nowNode = (Node)this.getById(nodeId);
        return this.suffixNodeList(nowNode.getDefinitionId(), nowNode.getNodeCode());
    }

    @Override
    public List<Node> suffixNodeList(Long definitionId, String nowNodeCode) {
        return this.prefixOrSuffixNodes(definitionId, nowNodeCode, "suffix");
    }

    @Override
    public List<Node> suffixNodeList(String nowNodeCode, FlowCombine flowCombine) {
        return this.prefixOrSuffixNodes(nowNodeCode, "suffix", flowCombine);
    }

    @Override
    public List<Node> getByDefId(Long definitionId) {
        return this.list(FlowEngine.newNode().setDefinitionId(definitionId));
    }

    @Override
    public Node getByDefIdAndNodeCode(Long definitionId, String nodeCode) {
        return this.getOne(FlowEngine.newNode().setDefinitionId(definitionId).setNodeCode(nodeCode));
    }

    @Override
    public Node getStartNode(Long definitionId) {
        return this.getOne(FlowEngine.newNode().setDefinitionId(definitionId).setNodeType(NodeType.START.getKey()));
    }

    @Override
    public List<Node> getBetweenNode(Long definitionId) {
        return this.list(FlowEngine.newNode().setDefinitionId(definitionId).setNodeType(NodeType.END.getKey()));
    }

    @Override
    public Node getEndNode(Long definitionId) {
        return this.getOne(FlowEngine.newNode().setDefinitionId(definitionId).setNodeType(NodeType.END.getKey()));
    }

    public List<Node> prefixOrSuffixNodes(Long definitionId, String nowNodeCode, String type) {
        FlowCombine flowCombine = new FlowCombine();
        flowCombine.setAllNodes(FlowEngine.nodeService().getByDefId(definitionId));
        flowCombine.setAllSkips(FlowEngine.skipService().getByDefId(definitionId));
        return this.prefixOrSuffixNodes(nowNodeCode, type, flowCombine);
    }

    public List<Node> prefixOrSuffixNodes(String nowNodeCode, String type, FlowCombine flowCombine) {
        Map<String, Node> nodeMap = StreamUtils.toMap(flowCombine.getAllNodes(), Node::getNodeCode, node -> node);
        Map skipMap = flowCombine.getAllSkips().stream().filter(skip -> SkipType.isPass(skip.getSkipType())).collect(Collectors.groupingBy("previous".equals(type) ? Skip::getNextNodeCode : Skip::getNowNodeCode, LinkedHashMap::new, Collectors.toList()));
        ArrayList<Node> prefixOrSuffixNodes = new ArrayList<Node>();
        List<String> prefixOrSuffixCode = this.prefixOrSuffixCodes(skipMap, nowNodeCode, "previous".equals(type) ? Skip::getNowNodeCode : Skip::getNextNodeCode);
        for (String nodeCode : prefixOrSuffixCode) {
            Node node2 = nodeMap.get(nodeCode);
            if (NodeType.isGateWay(node2.getNodeType()).booleanValue()) continue;
            prefixOrSuffixNodes.add(node2);
        }
        Collections.reverse(prefixOrSuffixNodes);
        HashSet sameCode = new HashSet();
        prefixOrSuffixNodes.removeIf(node -> {
            if (sameCode.contains(node.getNodeCode())) {
                return true;
            }
            sameCode.add(node.getNodeCode());
            return false;
        });
        Collections.reverse(prefixOrSuffixNodes);
        return prefixOrSuffixNodes;
    }

    @Override
    public List<Node> getNextNodeList(Long definitionId, String nowNodeCode, String anyNodeCode, String skipType, Map<String, Object> variable) {
        AssertUtil.isEmpty(nowNodeCode, "\u8282\u70b9\u7f16\u7801\u7f3a\u5931");
        FlowCombine flowCombine = FlowEngine.defService().getFlowCombineNoDef(definitionId);
        Node nowNode = StreamUtils.filterOne(flowCombine.getAllNodes(), t -> t.getNodeCode().equals(nowNodeCode));
        return this.getNextByCheckGateway(variable, this.getNextNode(nowNode, anyNodeCode, skipType, null, flowCombine), null, flowCombine);
    }

    @Override
    public Node getNextNode(Long definitionId, String nowNodeCode, String anyNodeCode, String skipType) {
        FlowCombine flowCombine = FlowEngine.defService().getFlowCombineNoDef(definitionId);
        Node nowNode = StreamUtils.filterOne(flowCombine.getAllNodes(), t -> t.getNodeCode().equals(nowNodeCode));
        return this.getNextNode(nowNode, anyNodeCode, skipType, null, flowCombine);
    }

    @Override
    public List<Node> getNextNodeList(Node nowNode, String anyNodeCode, String skipType, Map<String, Object> variable, PathWayData pathWayData, FlowCombine flowCombine) {
        return this.getNextByCheckGateway(variable, this.getNextNode(nowNode, anyNodeCode, skipType, pathWayData, flowCombine), pathWayData, flowCombine);
    }

    @Override
    public Node getNextNode(Node nowNode, String anyNodeCode, String skipType, PathWayData pathWayData, FlowCombine flowCombine) {
        AssertUtil.isNull(nowNode, "\u8282\u70b9\u7f16\u7801\u7f3a\u5931");
        AssertUtil.isNull(nowNode.getDefinitionId(), "\u6d41\u7a0b\u5b9a\u4e49id\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtil.isEmpty(skipType, "\u8df3\u8f6c\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
        if (pathWayData != null) {
            pathWayData.getPathWayNodes().add(nowNode);
        }
        Node nextNode = null;
        if (StringUtils.isNotEmpty(anyNodeCode)) {
            nextNode = StreamUtils.filterOne(flowCombine.getAllNodes(), node -> anyNodeCode.equals(node.getNodeCode()));
        }
        if (StringUtils.isNotEmpty(nowNode.getAnyNodeSkip()) && SkipType.isReject(skipType).booleanValue()) {
            nextNode = StreamUtils.filterOne(flowCombine.getAllNodes(), node -> nowNode.getAnyNodeSkip().equals(node.getNodeCode()));
        }
        if (ObjectUtil.isNotNull(nextNode)) {
            AssertUtil.isTrue(NodeType.isGateWay(nextNode.getNodeType()), "\u76ee\u6807\u8282\u70b9\u4e0d\u80fd\u662f\u7f51\u5173\u8282\u70b9!");
            return nextNode;
        }
        List<Skip> skips = StreamUtils.filter(flowCombine.getAllSkips(), skip -> nowNode.getNodeCode().equals(skip.getNowNodeCode()));
        AssertUtil.isNull(skips, "\u65e0\u6cd5\u4ed6\u8df3\u8f6c\uff0c\u672a\u914d\u7f6e\u76ee\u6807\u8282\u70b9!");
        Skip nextSkip = this.getSkipByCheck(skips, skipType);
        nextNode = StreamUtils.filterOne(flowCombine.getAllNodes(), node -> nextSkip.getNextNodeCode().equals(node.getNodeCode()));
        AssertUtil.isNull(nextNode, "\u76ee\u6807\u8282\u70b9\u7f16\u7801\u4e0d\u5b58\u5728!");
        AssertUtil.isTrue(NodeType.isStart(nextNode.getNodeType()), "\u7981\u6b62\u9000\u56de\u5230\u7b2c\u4e00\u4e2a\u8282\u70b9");
        if (pathWayData != null) {
            pathWayData.getPathWayNodes().add(nextNode);
            pathWayData.getPathWaySkips().add(nextSkip);
        }
        return nextNode;
    }

    @Override
    public List<Node> getNextByCheckGateway(Map<String, Object> variable, Node nextNode, PathWayData pathWayData, FlowCombine flowCombine) {
        if (NodeType.isGateWay(nextNode.getNodeType()).booleanValue()) {
            List<Skip> skipsGateway = StreamUtils.filter(flowCombine.getAllSkips(), skip -> nextNode.getNodeCode().equals(skip.getNowNodeCode()));
            if (CollUtil.isEmpty(skipsGateway)) {
                return null;
            }
            if (!NodeType.isStart(nextNode.getNodeType()).booleanValue() && NodeType.isGateWaySerial(nextNode.getNodeType()).booleanValue()) {
                Skip skipOne = null;
                for (Skip skip2 : skipsGateway) {
                    if (StringUtils.isNotEmpty(skip2.getSkipCondition())) {
                        if (!ExpressionUtil.evalCondition(skip2.getSkipCondition(), variable)) continue;
                        skipOne = skip2;
                        break;
                    }
                    skipOne = skip2;
                }
                skipsGateway = skipOne == null ? null : CollUtil.toList(skipOne);
            }
            AssertUtil.isEmpty(skipsGateway, "\u672a\u627e\u5230\u8df3\u8f6c\u6761\u4ef6\uff0c\u4e0d\u652f\u6301\u8df3\u8f6c!");
            List<String> nextNodeCodes = StreamUtils.toList(skipsGateway, Skip::getNextNodeCode);
            List<Node> nextNodes = StreamUtils.filter(flowCombine.getAllNodes(), node -> nextNodeCodes.contains(node.getNodeCode()));
            AssertUtil.isEmpty(nextNodes, "\u6d41\u7a0b\u8282\u70b9\u6570\u636e\u7f3a\u5931!");
            if (pathWayData != null) {
                pathWayData.getPathWayNodes().addAll(nextNodes);
                pathWayData.getPathWaySkips().addAll(skipsGateway);
            }
            ArrayList<Node> newNextNodes = new ArrayList<Node>();
            for (Node node2 : nextNodes) {
                List<Node> nodeList = this.getNextByCheckGateway(variable, node2, pathWayData, flowCombine);
                newNextNodes.addAll(nodeList);
            }
            return newNextNodes;
        }
        if (pathWayData != null) {
            pathWayData.getPathWayNodes().remove(nextNode);
        }
        AssertUtil.isTrue(NodeType.isStart(nextNode.getNodeType()), "\u5f00\u59cb\u8282\u70b9\u4e0d\u5141\u8bb8\u8df3\u8f6c!");
        return CollUtil.toList(nextNode);
    }

    @Override
    public int deleteNodeByDefIds(Collection<? extends Serializable> defIds) {
        return ((FlowNodeDao)this.getDao()).deleteNodeByDefIds(defIds);
    }

    private List<String> prefixOrSuffixCodes(Map<String, List<Skip>> skipMap, String nodeCode, Function<Skip, String> supplier) {
        ArrayList<String> prefixOrSuffixCode = new ArrayList<String>();
        List<Skip> skipList = skipMap.get(nodeCode);
        if (CollUtil.isNotEmpty(skipList)) {
            for (Skip skip : skipList) {
                if (!SkipType.isPass(skip.getSkipType()).booleanValue()) continue;
                prefixOrSuffixCode.add(supplier.apply(skip));
                prefixOrSuffixCode.addAll(this.prefixOrSuffixCodes(skipMap, supplier.apply(skip), supplier));
            }
        }
        return prefixOrSuffixCode;
    }

    private Skip getSkipByCheck(List<Skip> skips, String skipType) {
        if (CollUtil.isEmpty(skips)) {
            return null;
        }
        skips = skips.stream().filter(t -> {
            if (StringUtils.isNotEmpty(t.getSkipType())) {
                return skipType.equals(t.getSkipType());
            }
            return true;
        }).collect(Collectors.toList());
        AssertUtil.isEmpty(skips, "\u65e0\u6cd5\u8df3\u8f6c\u5230\u76ee\u6807\u8282\u70b9,\u8bf7\u68c0\u67e5\u8df3\u8f6c\u7c7b\u578b\u662f\u5426\u5339\u914d!");
        return skips.get(0);
    }
}

