/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.service.impl;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.dto.DefJson;
import org.dromara.warm.flow.core.dto.FlowCombine;
import org.dromara.warm.flow.core.dto.FlowDto;
import org.dromara.warm.flow.core.dto.FlowParams;
import org.dromara.warm.flow.core.dto.NodeJson;
import org.dromara.warm.flow.core.dto.PathWayData;
import org.dromara.warm.flow.core.dto.SkipJson;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.Form;
import org.dromara.warm.flow.core.entity.HisTask;
import org.dromara.warm.flow.core.entity.Instance;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.entity.Task;
import org.dromara.warm.flow.core.entity.User;
import org.dromara.warm.flow.core.enums.ActivityStatus;
import org.dromara.warm.flow.core.enums.CooperateType;
import org.dromara.warm.flow.core.enums.FlowStatus;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.enums.SkipType;
import org.dromara.warm.flow.core.enums.UserType;
import org.dromara.warm.flow.core.listener.ListenerVariable;
import org.dromara.warm.flow.core.orm.dao.FlowTaskDao;
import org.dromara.warm.flow.core.orm.service.impl.WarmServiceImpl;
import org.dromara.warm.flow.core.service.TaskService;
import org.dromara.warm.flow.core.utils.AssertUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ExpressionUtil;
import org.dromara.warm.flow.core.utils.ListenerUtil;
import org.dromara.warm.flow.core.utils.MapUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.SqlHelper;
import org.dromara.warm.flow.core.utils.StreamUtils;
import org.dromara.warm.flow.core.utils.StringUtils;

public class TaskServiceImpl
extends WarmServiceImpl<FlowTaskDao<Task>, Task>
implements TaskService {
    public TaskService setDao(FlowTaskDao<Task> warmDao) {
        this.warmDao = warmDao;
        return this;
    }

    @Override
    public Instance pass(Long taskId, String message, Map<String, Object> variable) {
        return this.skip(taskId, new FlowParams(SkipType.PASS.getKey(), message, variable));
    }

    @Override
    public Instance passAtWill(Long taskId, String nodeCode, String message, Map<String, Object> variable) {
        return this.skip(taskId, new FlowParams(nodeCode, SkipType.PASS.getKey(), message, variable));
    }

    @Override
    public Instance pass(Long taskId, String message, Map<String, Object> variable, String flowStatus, String hisStatus) {
        return this.skip(taskId, new FlowParams(SkipType.PASS.getKey(), message, variable, flowStatus, hisStatus));
    }

    @Override
    public Instance passAtWill(Long taskId, String nodeCode, String message, Map<String, Object> variable, String flowStatus, String hisStatus) {
        return this.skip(taskId, new FlowParams(nodeCode, SkipType.PASS.getKey(), message, variable, flowStatus, hisStatus));
    }

    @Override
    public Instance reject(Long taskId, String message, Map<String, Object> variable) {
        return this.skip(taskId, new FlowParams(SkipType.REJECT.getKey(), message, variable));
    }

    @Override
    public Instance rejectAtWill(Long taskId, String nodeCode, String message, Map<String, Object> variable) {
        return this.skip(taskId, new FlowParams(nodeCode, SkipType.REJECT.getKey(), message, variable));
    }

    @Override
    public Instance reject(Long taskId, String message, Map<String, Object> variable, String flowStatus, String hisStatus) {
        return this.skip(taskId, new FlowParams(SkipType.REJECT.getKey(), message, variable, flowStatus, hisStatus));
    }

    @Override
    public Instance rejectAtWill(Long taskId, String nodeCode, String message, Map<String, Object> variable, String flowStatus, String hisStatus) {
        return this.skip(taskId, new FlowParams(nodeCode, SkipType.REJECT.getKey(), message, variable, flowStatus, hisStatus));
    }

    @Override
    public Instance skip(Long taskId, FlowParams flowParams) {
        Task task = (Task)this.getById(taskId);
        return this.skip(flowParams, task);
    }

    @Override
    public Instance skipByInsId(Long instanceId, FlowParams flowParams) {
        return this.skip(flowParams, this.getTask(instanceId));
    }

    @Override
    public Instance rejectLastByInsId(Long instanceId, FlowParams flowParams) {
        return this.rejectLast(this.getTask(instanceId), flowParams);
    }

    @Override
    public Instance rejectLast(Long taskId, FlowParams flowParams) {
        return this.rejectLast((Task)this.getById(taskId), flowParams);
    }

    @Override
    public Instance rejectLast(Task task, FlowParams flowParams) {
        flowParams.skipType(SkipType.REJECT.getKey());
        AssertUtil.isNull(task, "\u672a\u627e\u5230\u5f85\u529e\u4efb\u52a1!");
        List<HisTask> hisTaskList = FlowEngine.hisTaskService().getByInsId(task.getInstanceId());
        HisTask lastHisTask = hisTaskList.stream().filter(hisTask -> StringUtils.isNotEmpty(hisTask.getTargetNodeCode())).filter(hisTask -> SkipType.isPass(hisTask.getSkipType())).filter(hisTask -> {
            String targetCode = hisTask.getTargetNodeCode();
            if (targetCode.contains(",")) {
                return Arrays.asList(targetCode.split(",")).contains(task.getNodeCode());
            }
            return targetCode.equals(task.getNodeCode());
        }).max(Comparator.comparingLong(HisTask::getId)).orElse(null);
        AssertUtil.isNull(lastHisTask, "\u672a\u627e\u5230\u524d\u7f6e\u4efb\u52a1!");
        flowParams.nodeCode(lastHisTask.getNodeCode());
        return this.skip(flowParams, task);
    }

    @Override
    public Instance taskBackByInsId(Long instanceId, FlowParams flowParams) {
        HisTask lastHisTask = this.taskBack(flowParams, instanceId);
        List<Node> suffixNodeList = FlowEngine.nodeService().suffixNodeList(lastHisTask.getDefinitionId(), lastHisTask.getNodeCode());
        List<String> suffixNodeCodes = StreamUtils.toList(suffixNodeList, Node::getNodeCode);
        List<Task> taskList = FlowEngine.taskService().getByInsIdAndNodeCodes(instanceId, suffixNodeCodes);
        AssertUtil.isEmpty(taskList, "\u62ff\u56de\u7684\u4efb\u52a1\u672a\u529e\u7406!");
        return this.skip(flowParams, taskList.get(0));
    }

    @Override
    public Instance taskBack(Long taskId, FlowParams flowParams) {
        Task task = (Task)this.getById(taskId);
        AssertUtil.isNull(task, "\u672a\u627e\u5230\u5f85\u529e\u4efb\u52a1!");
        this.taskBack(flowParams, task.getInstanceId());
        return this.skip(flowParams, task);
    }

    @Override
    public Instance skip(FlowParams flowParams, Task task) {
        R r = this.getAndCheck(task);
        flowParams.variable(MapUtil.mergeAll(r.instance.getVariableMap(), flowParams.getVariable()));
        if (!NodeType.isStart(task.getNodeType()).booleanValue()) {
            AssertUtil.isFalse(StringUtils.isNotEmpty(flowParams.getSkipType()), "\u8df3\u8f6c\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a!");
        }
        task.setUserList(FlowEngine.userService().listByAssociatedAndTypes(task.getId(), new String[0]));
        FlowCombine flowCombine = FlowEngine.defService().getFlowCombineNoDef(r.definition.getId());
        ListenerUtil.executeListener(new ListenerVariable(r.definition, r.instance, r.nowNode, flowParams.getVariable(), task).setFlowParams(flowParams), "start");
        if (!flowParams.isIgnoreDepute() && this.handleDepute(task, flowParams)) {
            return r.instance;
        }
        this.checkAuth(task, flowParams);
        if (!flowParams.isIgnoreCooperate() && this.cooperate(r.nowNode, task, flowParams)) {
            return r.instance;
        }
        PathWayData pathWayData = new PathWayData().setInsId(task.getInstanceId()).setSkipType(flowParams.getSkipType());
        Node nextNode = FlowEngine.nodeService().getNextNode(r.nowNode, flowParams.getNodeCode(), flowParams.getSkipType(), pathWayData, flowCombine);
        List<Node> nextNodes = FlowEngine.nodeService().getNextByCheckGateway(flowParams.getVariable(), nextNode, pathWayData, flowCombine);
        this.filterCanNewTask(pathWayData, r.instance, nextNodes);
        pathWayData.getTargetNodes().addAll(nextNodes);
        r.instance.setDefJson(FlowEngine.chartService().skipMetadata(pathWayData));
        List<Task> addTasks = StreamUtils.toList(nextNodes, node -> this.addTask((Node)node, r.instance, r.definition, flowParams));
        ExpressionUtil.evalVariable(addTasks, flowParams.variable(MapUtil.mergeAll(r.instance.getVariableMap(), flowParams.getVariable())));
        ListenerUtil.executeListener(new ListenerVariable(r.definition, r.instance, r.nowNode, flowParams.getVariable(), task, nextNodes, addTasks).setFlowParams(flowParams), "assignment");
        this.updateFlowInfo(task, r.instance, addTasks, flowParams, nextNodes);
        if (CollUtil.isNotEmpty(nextNodes) && SkipType.isReject(flowParams.getSkipType()).booleanValue()) {
            this.oneVoteVeto(task, nextNodes.get(0).getNodeCode(), flowCombine);
        }
        this.handUndoneTask(r.instance);
        ListenerUtil.endCreateListener(new ListenerVariable(r.definition, r.instance, r.nowNode, flowParams.getVariable(), task, nextNodes, addTasks).setFlowParams(flowParams));
        return r.instance;
    }

    @Override
    public Instance revoke(Long instanceId, FlowParams flowParams) {
        flowParams.skipType(SkipType.REJECT.getKey());
        if (StringUtils.isEmpty(flowParams.getFlowStatus())) {
            flowParams.flowStatus(FlowStatus.CANCEL.getKey());
        }
        Instance instance = (Instance)FlowEngine.insService().getById(instanceId);
        flowParams.variable(MapUtil.mergeAll(instance.getVariableMap(), flowParams.getVariable()));
        AssertUtil.isNull(instance, "\u6d41\u7a0b\u5b9e\u4f8b\u83b7\u53d6\u5931\u8d25!");
        Definition definition = (Definition)FlowEngine.defService().getById(instance.getDefinitionId());
        AssertUtil.isFalse(this.judgeActivityStatus(definition, instance), "\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u6216\u8005\u5b9e\u4f8b\u5df2\u7ecf\u6302\u8d77\uff0c\u8bf7\u5148\u6fc0\u6d3b");
        AssertUtil.isTrue(NodeType.isEnd(instance.getNodeType()), "\u6d41\u7a0b\u5df2\u5b8c\u6210\uff01");
        flowParams.variable(MapUtil.mergeAll(instance.getVariableMap(), flowParams.getVariable()));
        List<Task> taskList = this.getByInsId(instanceId);
        FlowCombine flowCombine = FlowEngine.defService().getFlowCombine(definition);
        Map<String, Node> nodeMap = StreamUtils.toMap(flowCombine.getAllNodes(), Node::getNodeCode, node -> node);
        taskList.forEach(task -> ListenerUtil.executeListener(new ListenerVariable(definition, instance, (Node)nodeMap.get(task.getNodeCode()), flowParams.getVariable(), (Task)task).setFlowParams(flowParams), "start"));
        if (flowParams.isIgnore()) {
            AssertUtil.isFalse(instance.getCreateBy().equals(flowParams.getHandler()), "\u4e0d\u662f\u5f53\u524d\u6d41\u7a0b\u7684\u53d1\u8d77\u4eba\uff0c\u65e0\u6cd5\u64a4\u9500");
        }
        Node startNode = StreamUtils.filterOne(flowCombine.getAllNodes(), node -> NodeType.isStart(node.getNodeType()));
        PathWayData pathWayData = new PathWayData().setInsId(instanceId).setSkipType(flowParams.getSkipType());
        Node nextNode = FlowEngine.nodeService().getNextNode(startNode, null, SkipType.PASS.getKey(), null, flowCombine);
        List<Node> nextNodes = FlowEngine.nodeService().getNextByCheckGateway(flowParams.getVariable(), nextNode, pathWayData, flowCombine);
        pathWayData.getTargetNodes().addAll(nextNodes);
        instance.setDefJson(FlowEngine.chartService().skipMetadata(pathWayData));
        List<Task> curTaskList = this.list(FlowEngine.newTask().setInstanceId(instance.getId()));
        AssertUtil.isEmpty(curTaskList, "\u672a\u83b7\u53d6\u5230\u6d41\u7a0b\u4efb\u52a1");
        List<Task> addTasks = StreamUtils.toList(nextNodes, node -> this.addTask((Node)node, instance, definition, flowParams));
        ExpressionUtil.evalVariable(addTasks, flowParams.variable(MapUtil.mergeAll(instance.getVariableMap(), flowParams.getVariable())));
        taskList.forEach(task -> ListenerUtil.executeListener(new ListenerVariable(definition, instance, (Node)nodeMap.get(task.getNodeCode()), flowParams.getVariable(), (Task)task, nextNodes, addTasks).setFlowParams(flowParams), "assignment"));
        List<HisTask> insHisList = FlowEngine.hisTaskService().setSkipHisList(curTaskList, nextNodes, flowParams);
        FlowEngine.hisTaskService().saveBatch(insHisList);
        this.removeAndUser(curTaskList);
        List<User> users = FlowEngine.userService().taskAddUsers(addTasks);
        this.setInsFinishInfo(instance, addTasks, flowParams);
        if (CollUtil.isNotEmpty(addTasks)) {
            this.saveBatch(addTasks);
        }
        FlowEngine.insService().updateById(instance);
        FlowEngine.userService().saveBatch(users);
        taskList.forEach(task -> ListenerUtil.endCreateListener(new ListenerVariable(definition, instance, (Node)nodeMap.get(task.getNodeCode()), flowParams.getVariable(), (Task)task, nextNodes, addTasks).setFlowParams(flowParams)));
        return instance;
    }

    @Override
    public Instance terminationByInsId(Long instanceId, FlowParams flowParams) {
        List<Task> taskList = FlowEngine.taskService().getByInsId(instanceId);
        AssertUtil.isEmpty(taskList, "\u672a\u627e\u5230\u5f85\u529e\u4efb\u52a1!");
        Task task = taskList.get(0);
        return this.termination(task, flowParams);
    }

    @Override
    public Instance termination(Long taskId, FlowParams flowParams) {
        return this.termination((Task)this.getById(taskId), flowParams);
    }

    @Override
    public Instance termination(Task task, FlowParams flowParams) {
        R r = this.getAndCheck(task);
        flowParams.skipType(SkipType.PASS.getKey());
        flowParams.variable(MapUtil.mergeAll(r.instance.getVariableMap(), flowParams.getVariable()));
        ListenerUtil.executeListener(new ListenerVariable(r.definition, r.instance, r.nowNode, flowParams.getVariable(), task).setFlowParams(flowParams), "start");
        task.setUserList(FlowEngine.userService().listByAssociatedAndTypes(task.getId(), new String[0]));
        this.checkAuth(task, flowParams);
        Node endNode = FlowEngine.nodeService().getEndNode(r.instance.getDefinitionId());
        PathWayData pathWayData = new PathWayData().setInsId(task.getInstanceId()).setSkipType(flowParams.getSkipType()).setPathWayNodes(Collections.singletonList(r.nowNode)).setTargetNodes(Collections.singletonList(endNode));
        r.instance.setDefJson(FlowEngine.chartService().skipMetadata(pathWayData));
        r.instance.setNodeType(endNode.getNodeType()).setNodeCode(endNode.getNodeCode()).setNodeName(endNode.getNodeName()).setFlowStatus(StringUtils.emptyDefault(flowParams.getFlowStatus(), FlowStatus.TERMINATE.getKey()));
        flowParams.flowStatus(r.instance.getFlowStatus());
        HisTask insHis = FlowEngine.hisTaskService().setSkipInsHis(task, Collections.singletonList(endNode), flowParams);
        FlowEngine.hisTaskService().save(insHis);
        FlowEngine.insService().updateById(r.instance);
        FlowEngine.userService().deleteByTaskIds(Collections.singletonList(task.getId()));
        this.handUndoneTask(r.instance);
        ListenerUtil.executeListener(new ListenerVariable(r.definition, r.instance, r.nowNode, flowParams.getVariable(), task), "finish");
        return r.instance;
    }

    @Override
    public boolean deleteByInsIds(List<Long> instanceIds) {
        List instanceList = FlowEngine.insService().getByIds(instanceIds);
        for (Instance instance : instanceList) {
            Definition definition = (Definition)FlowEngine.defService().getById(instance.getDefinitionId());
            AssertUtil.isFalse(this.judgeActivityStatus(definition, instance), "\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u6216\u8005\u5b9e\u4f8b\u5df2\u7ecf\u6302\u8d77\uff0c\u8bf7\u5148\u6fc0\u6d3b");
        }
        return SqlHelper.retBool(((FlowTaskDao)this.getDao()).deleteByInsIds(instanceIds));
    }

    @Override
    public boolean transfer(Long taskId, FlowParams flowParams) {
        AssertUtil.isNotNull(taskId, "\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtil.isNotNull(flowParams.getHandler(), "\u529e\u7406\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull(flowParams.getAddHandlers(), "\u8f6c\u529e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        List<User> users = FlowEngine.userService().getByProcessedBys(taskId, flowParams.getAddHandlers(), UserType.TRANSFER.getKey());
        AssertUtil.isNotEmpty(users, "\u5df2\u7ecf\u662f\u8f6c\u529e\u4eba\uff0c\u4e0d\u53ef\u8f6c\u529e");
        flowParams.cooperateType(CooperateType.TRANSFER.getKey()).reductionHandlers(Collections.singletonList(flowParams.getHandler()));
        return this.updateHandler(taskId, flowParams);
    }

    @Override
    public boolean depute(Long taskId, FlowParams flowParams) {
        AssertUtil.isNotNull(taskId, "\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtil.isNotNull(flowParams.getHandler(), "\u529e\u7406\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull(flowParams.getAddHandlers(), "\u59d4\u6258\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        List<User> users = FlowEngine.userService().getByProcessedBys(taskId, flowParams.getAddHandlers(), UserType.DEPUTE.getKey());
        AssertUtil.isNotEmpty(users, "\u5df2\u7ecf\u662f\u53d7\u6258\u4eba\uff0c\u4e0d\u53ef\u59d4\u6258");
        flowParams.cooperateType(CooperateType.DEPUTE.getKey()).reductionHandlers(Collections.singletonList(flowParams.getHandler()));
        return this.updateHandler(taskId, flowParams);
    }

    @Override
    public boolean addSignature(Long taskId, FlowParams flowParams) {
        AssertUtil.isNotNull(taskId, "\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtil.isNotNull(flowParams.getHandler(), "\u529e\u7406\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull(flowParams.getAddHandlers(), "\u52a0\u7b7e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        List<User> users = FlowEngine.userService().getByProcessedBys(taskId, flowParams.getAddHandlers(), UserType.APPROVAL.getKey());
        AssertUtil.isNotEmpty(users, "\u5df2\u7ecf\u662f\u5f85\u529e\u4eba\uff0c\u4e0d\u53ef\u52a0\u7b7e");
        flowParams.cooperateType(CooperateType.ADD_SIGNATURE.getKey());
        return this.updateHandler(taskId, flowParams);
    }

    @Override
    public boolean reductionSignature(Long taskId, FlowParams flowParams) {
        AssertUtil.isNotNull(taskId, "\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a!");
        AssertUtil.isNotNull(flowParams.getHandler(), "\u529e\u7406\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNotNull(flowParams.getReductionHandlers(), "\u51cf\u7b7e\u5bf9\u8c61\u4e0d\u80fd\u4e3a\u7a7a");
        List<User> users = FlowEngine.userService().listByAssociatedAndTypes(taskId, UserType.APPROVAL.getKey(), UserType.TRANSFER.getKey());
        AssertUtil.isTrue(CollUtil.isEmpty(users) || users.size() == 1, "\u529e\u7406\u4eba\u4e0d\u8db3\u6216\u8005\u53ea\u6709\u4e00\u4eba\uff0c\u4e0d\u53ef\u51cf\u7b7e");
        flowParams.cooperateType(CooperateType.REDUCTION_SIGNATURE.getKey());
        return this.updateHandler(taskId, flowParams);
    }

    @Override
    public boolean updateHandler(Long taskId, FlowParams flowParams) {
        R r = this.getAndCheck(taskId);
        flowParams.variable(MapUtil.mergeAll(r.instance.getVariableMap(), flowParams.getVariable()));
        ListenerUtil.executeListener(new ListenerVariable(r.definition, r.instance, r.nowNode, null, r.task), "start");
        if (!flowParams.isIgnore()) {
            List<String> permissions = flowParams.getPermissionFlag();
            List<String> taskPermissions = FlowEngine.userService().getPermission(taskId, UserType.APPROVAL.getKey(), UserType.TRANSFER.getKey(), UserType.DEPUTE.getKey());
            AssertUtil.isTrue(CollUtil.isNotEmpty(taskPermissions) && (CollUtil.isEmpty(permissions) || CollUtil.notContainsAny(permissions, (Collection<String>)taskPermissions)), "\u8bf7\u68c0\u67e5\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u6743\u9650!");
        }
        flowParams.skipType(SkipType.NONE.getKey());
        HisTask hisTask = null;
        if (CollUtil.isNotEmpty(flowParams.getReductionHandlers())) {
            for (String reductionHandler : flowParams.getReductionHandlers()) {
                FlowEngine.userService().remove(FlowEngine.newUser().setAssociated(taskId).setProcessedBy(reductionHandler));
            }
            hisTask = FlowEngine.hisTaskService().setCooperateHis(r.task, r.nowNode, flowParams, flowParams.getReductionHandlers());
        }
        if (CollUtil.isNotEmpty(flowParams.getAddHandlers())) {
            String type = CooperateType.TRANSFER.getKey().equals(flowParams.getCooperateType()) ? UserType.TRANSFER.getKey() : (CooperateType.DEPUTE.getKey().equals(flowParams.getCooperateType()) ? UserType.DEPUTE.getKey() : UserType.APPROVAL.getKey());
            FlowEngine.userService().saveBatch(StreamUtils.toList(flowParams.getAddHandlers(), permission -> FlowEngine.userService().structureUser(taskId, (String)permission, type, flowParams.getHandler())));
            hisTask = FlowEngine.hisTaskService().setCooperateHis(r.task, r.nowNode, flowParams, flowParams.getAddHandlers());
        }
        if (ObjectUtil.isNotNull(hisTask)) {
            FlowEngine.hisTaskService().save(hisTask);
        }
        ListenerUtil.executeListener(new ListenerVariable(r.definition, r.instance, r.nowNode, flowParams.getVariable(), r.task), "finish");
        return true;
    }

    @Override
    public Task addTask(Node node, Instance instance, Definition definition, FlowParams flowParams) {
        Task addTask = FlowEngine.newTask();
        FlowEngine.dataFillHandler().idFill(addTask);
        addTask.setDefinitionId(instance.getDefinitionId()).setInstanceId(instance.getId()).setNodeCode(node.getNodeCode()).setNodeName(node.getNodeName()).setNodeType(node.getNodeType()).setFlowStatus(StringUtils.emptyDefault(flowParams.getFlowStatus(), this.setFlowStatus(node.getNodeType(), flowParams.getSkipType()))).setCreateTime(new Date()).setPermissionList(StringUtils.str2List(node.getPermissionFlag(), "@@"));
        if (StringUtils.isNotEmpty(node.getFormCustom()) && StringUtils.isNotEmpty(node.getFormPath())) {
            addTask.setFormCustom(node.getFormCustom()).setFormPath(node.getFormPath());
        } else {
            addTask.setFormCustom(definition.getFormCustom()).setFormPath(definition.getFormPath());
        }
        return addTask;
    }

    @Override
    public List<Task> getByInsId(Long instanceId) {
        return this.list(FlowEngine.newTask().setInstanceId(instanceId));
    }

    @Override
    public List<Task> getByInsIdAndNodeCodes(Long instanceId, List<String> nodeCodes) {
        return ((FlowTaskDao)this.getDao()).getByInsIdAndNodeCodes(instanceId, nodeCodes);
    }

    @Override
    public void setInsFinishInfo(Instance instance, List<Task> addTasks, FlowParams flowParams) {
        instance.setUpdateTime(new Date());
        this.mergeVariable(instance, flowParams.getVariable());
        if (CollUtil.isNotEmpty(addTasks)) {
            AtomicReference<Task> finallyTask = new AtomicReference<Task>();
            addTasks.removeIf(addTask -> {
                if (NodeType.isEnd(addTask.getNodeType()).booleanValue()) {
                    finallyTask.set((Task)addTask);
                    return true;
                }
                return false;
            });
            if (ObjectUtil.isNull(finallyTask.get())) {
                finallyTask.set(this.getNextTask(addTasks));
            }
            instance.setNodeType(((Task)finallyTask.get()).getNodeType()).setNodeCode(((Task)finallyTask.get()).getNodeCode()).setNodeName(((Task)finallyTask.get()).getNodeName()).setFlowStatus(((Task)finallyTask.get()).getFlowStatus());
        }
    }

    @Override
    public void mergeVariable(Instance instance, Map<String, Object> variable) {
        if (MapUtil.isNotEmpty(variable)) {
            String variableStr = instance.getVariable();
            Map<String, Object> deserialize = FlowEngine.jsonConvert.strToMap(variableStr);
            deserialize.putAll(variable);
            instance.setVariable(FlowEngine.jsonConvert.objToStr(deserialize));
        }
    }

    private HisTask taskBack(FlowParams flowParams, Long instanceId) {
        flowParams.skipType(SkipType.REJECT.getKey()).ignore(true).ignoreDepute(true).ignoreCooperate(true).flowStatus(StringUtils.emptyDefault(flowParams.getFlowStatus(), FlowStatus.TASK_BACK.getKey()));
        List<HisTask> hisTaskList = FlowEngine.hisTaskService().getByInsId(instanceId);
        HisTask lastHisTask = hisTaskList.stream().filter(hisTask -> StringUtils.isNotEmpty(hisTask.getApprover())).filter(hisTask -> SkipType.isPass(hisTask.getSkipType())).filter(hisTask -> hisTask.getApprover().equals(flowParams.getHandler())).max(Comparator.comparingLong(HisTask::getId)).orElse(null);
        AssertUtil.isNull(lastHisTask, "\u4e3a\u627e\u5230\u60a8\u5df2\u529e\u7406\u8fc7\u7684\u4efb\u52a1!");
        flowParams.nodeCode(lastHisTask.getNodeCode());
        return lastHisTask;
    }

    private Task getTask(Long instanceId) {
        List<Task> taskList = this.getByInsId(instanceId);
        AssertUtil.isEmpty(taskList, "\u672a\u627e\u5230\u5f85\u529e\u4efb\u52a1!");
        AssertUtil.isTrue(taskList.size() > 1, "\u6b64\u63a5\u53e3\u4e0d\u80fd\u540c\u65f6\u8df3\u8f6c\u591a\u4e2a\u5f85\u529e\u4efb\u52a1\uff0c\u8bf7\u66f4\u6362!");
        return taskList.get(0);
    }

    private String setFlowStatus(Integer nodeType, String skipType) {
        if (NodeType.isStart(nodeType).booleanValue()) {
            return FlowStatus.TOBESUBMIT.getKey();
        }
        if (NodeType.isEnd(nodeType).booleanValue()) {
            return FlowStatus.FINISHED.getKey();
        }
        if (SkipType.isReject(skipType).booleanValue()) {
            return FlowStatus.REJECT.getKey();
        }
        return FlowStatus.APPROVAL.getKey();
    }

    private Task getNextTask(List<Task> tasks) {
        if (tasks.size() == 1) {
            return tasks.get(0);
        }
        for (Task task : tasks) {
            if (!NodeType.isEnd(task.getNodeType()).booleanValue()) continue;
            return task;
        }
        return tasks.stream().max(Comparator.comparingLong(Task::getId)).orElse(null);
    }

    private void removeAndUser(List<Task> taskList) {
        this.removeByIds(StreamUtils.toList(taskList, Task::getId));
        FlowEngine.userService().deleteByTaskIds(StreamUtils.toList(taskList, Task::getId));
    }

    private R getAndCheck(Long taskId) {
        AssertUtil.isNotNull(taskId, "\u4efb\u52a1id\u4e0d\u80fd\u4e3a\u7a7a!");
        return this.getAndCheck((Task)this.getById(taskId));
    }

    private R getAndCheck(Task task) {
        AssertUtil.isNull(task, "\u672a\u627e\u5230\u5f85\u529e\u4efb\u52a1!");
        Instance instance = (Instance)FlowEngine.insService().getById(task.getInstanceId());
        AssertUtil.isNull(instance, "\u6d41\u7a0b\u5b9e\u4f8b\u83b7\u53d6\u5931\u8d25!");
        Definition definition = (Definition)FlowEngine.defService().getById(instance.getDefinitionId());
        AssertUtil.isFalse(this.judgeActivityStatus(definition, instance), "\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u6216\u8005\u5b9e\u4f8b\u5df2\u7ecf\u6302\u8d77\uff0c\u8bf7\u5148\u6fc0\u6d3b");
        AssertUtil.isTrue(NodeType.isEnd(instance.getNodeType()), "\u6d41\u7a0b\u5df2\u5b8c\u6210\uff01");
        Node nowNode = FlowEngine.nodeService().getByDefIdAndNodeCode(task.getDefinitionId(), task.getNodeCode());
        AssertUtil.isNull(nowNode, "\u5f53\u524d\u6d41\u7a0b\u8282\u70b9\u4e22\u5931!");
        return new R(instance, definition, nowNode, task);
    }

    private boolean handleDepute(Task task, FlowParams flowParams) {
        List<User> entrustedUserList = StreamUtils.filter(task.getUserList(), user -> UserType.DEPUTE.getKey().equals(user.getType()) && Objects.equals(flowParams.getHandler(), user.getProcessedBy()));
        if (CollUtil.isEmpty(entrustedUserList)) {
            return false;
        }
        User entrustedUser = entrustedUserList.get(0);
        HisTask hisTask = FlowEngine.hisTaskService().setDeputeHisTask(task, flowParams, entrustedUser);
        FlowEngine.hisTaskService().save(hisTask);
        FlowEngine.userService().removeById(entrustedUser.getId());
        User deputeUser = FlowEngine.userService().getOne(FlowEngine.newUser().setAssociated(task.getId()).setProcessedBy(entrustedUser.getCreateBy()).setType(UserType.APPROVAL.getKey()));
        if (ObjectUtil.isNull(deputeUser)) {
            User newUser = FlowEngine.userService().structureUser(entrustedUser.getAssociated(), entrustedUser.getCreateBy(), UserType.APPROVAL.getKey(), entrustedUser.getProcessedBy());
            FlowEngine.userService().save(newUser);
        }
        return true;
    }

    private boolean cooperate(Node nowNode, Task task, FlowParams flowParams) {
        BigDecimal nodeRatio = nowNode.getNodeRatio();
        if (CooperateType.isOrSign(nodeRatio)) {
            return false;
        }
        List<User> todoList = FlowEngine.userService().listByAssociatedAndTypes(task.getId(), UserType.APPROVAL.getKey(), UserType.TRANSFER.getKey(), UserType.DEPUTE.getKey());
        AssertUtil.isEmpty(flowParams.getHandler(), "\u4f1a\u7b7e\u7968\u7b7e\u65f6\uff0c\u529e\u7406\u4eba\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        User todoUser = CollUtil.getOne(StreamUtils.filter(todoList, u -> Objects.equals(u.getProcessedBy(), flowParams.getHandler())));
        AssertUtil.isNull(todoUser, "\u8bf7\u68c0\u67e5\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u6743\u9650!");
        if (todoList.size() == 1) {
            return false;
        }
        List<User> restList = StreamUtils.filter(todoList, u -> !Objects.equals(u.getProcessedBy(), flowParams.getHandler()));
        if (CooperateType.isCountersign(nodeRatio) && SkipType.isReject(flowParams.getSkipType()).booleanValue()) {
            FlowEngine.userService().removeByIds(StreamUtils.toList(restList, User::getId));
            return false;
        }
        List<HisTask> doneList = FlowEngine.hisTaskService().listByTaskIdAndCooperateTypes(task.getId(), CooperateType.isCountersign(nodeRatio) ? CooperateType.COUNTERSIGN.getKey() : CooperateType.VOTE.getKey());
        doneList = CollUtil.emptyDefault(doneList);
        BigDecimal all = BigDecimal.ZERO.add(BigDecimal.valueOf(todoList.size())).add(BigDecimal.valueOf(doneList.size()));
        List<HisTask> donePassList = StreamUtils.filter(doneList, hisTask -> Objects.equals(hisTask.getSkipType(), SkipType.PASS.getKey()));
        List<HisTask> doneRejectList = StreamUtils.filter(doneList, hisTask -> Objects.equals(hisTask.getSkipType(), SkipType.REJECT.getKey()));
        boolean isPass = SkipType.isPass(flowParams.getSkipType());
        BigDecimal passRatio = (isPass ? BigDecimal.ONE : BigDecimal.ZERO).add(BigDecimal.valueOf(donePassList.size())).divide(all, 4, RoundingMode.HALF_UP).multiply(CooperateType.ONE_HUNDRED);
        BigDecimal rejectRatio = (isPass ? BigDecimal.ZERO : BigDecimal.ONE).add(BigDecimal.valueOf(doneRejectList.size())).divide(all, 4, RoundingMode.HALF_UP).multiply(CooperateType.ONE_HUNDRED);
        if (!isPass && rejectRatio.compareTo(CooperateType.ONE_HUNDRED.subtract(nodeRatio)) > 0) {
            FlowEngine.userService().removeByIds(StreamUtils.toList(restList, User::getId));
            return false;
        }
        if (passRatio.compareTo(nodeRatio) >= 0) {
            FlowEngine.userService().removeByIds(StreamUtils.toList(restList, User::getId));
            return false;
        }
        HisTask hisTask2 = FlowEngine.hisTaskService().setSignHisTask(task, flowParams, nodeRatio, isPass);
        FlowEngine.hisTaskService().save(hisTask2);
        FlowEngine.userService().removeById(todoUser.getId());
        return true;
    }

    private void filterCanNewTask(PathWayData pathWayData, Instance instance, List<Node> nextNodes) {
        if (SkipType.isReject(pathWayData.getSkipType()).booleanValue()) {
            return;
        }
        Map<String, List<Skip>> skipLastMap = StreamUtils.groupByKey(pathWayData.getPathWaySkips(), Skip::getNextNodeCode);
        DefJson defJson = FlowEngine.jsonConvert.strToBean(instance.getDefJson(), DefJson.class);
        Map<String, NodeJson> nodeJsonMap = StreamUtils.toMap(defJson.getNodeList(), NodeJson::getNodeCode, node -> node);
        List skipList = StreamUtils.toListAll(defJson.getNodeList(), NodeJson::getSkipList);
        Map<String, List<SkipJson>> skipJsonLastMap = StreamUtils.groupByKey(skipList, SkipJson::getNextNodeCode);
        nextNodes.removeIf(targetNode -> {
            List skips = (List)skipLastMap.get(targetNode.getNodeCode());
            if (CollUtil.isEmpty(skips)) {
                return false;
            }
            if (!NodeType.isGateWayParallel(((Skip)skips.get(0)).getNowNodeType()).booleanValue()) {
                return false;
            }
            NodeJson lastGateWayParallel = (NodeJson)nodeJsonMap.get(((Skip)skips.get(0)).getNowNodeCode());
            if (lastGateWayParallel == null) {
                return false;
            }
            List<NodeJson> noGateWayParallelNodes = this.noGateWayParallel(lastGateWayParallel.getNodeCode(), nodeJsonMap, skipJsonLastMap);
            long statusTwoCount = noGateWayParallelNodes.stream().filter(node -> node.getStatus() == 2).count();
            return statusTwoCount != (long)(noGateWayParallelNodes.size() - 1);
        });
    }

    private List<NodeJson> noGateWayParallel(String nodeCode, Map<String, NodeJson> nodeMap, Map<String, List<SkipJson>> skipLastMap) {
        ArrayList<NodeJson> noGateWayParallelList = new ArrayList<NodeJson>();
        List<SkipJson> skipJsonList = skipLastMap.get(nodeCode);
        for (SkipJson skipJson : skipJsonList) {
            NodeJson nextNodeJson = nodeMap.get(skipJson.getNowNodeCode());
            if (!NodeType.isGateWayParallel(nextNodeJson.getNodeType()).booleanValue()) {
                noGateWayParallelList.add(nextNodeJson);
                continue;
            }
            noGateWayParallelList.addAll(this.noGateWayParallel(nextNodeJson.getNodeCode(), nodeMap, skipLastMap));
        }
        return noGateWayParallelList;
    }

    private void checkAuth(Task task, FlowParams flowParams) {
        if (flowParams.isIgnore()) {
            return;
        }
        List<String> permissions = StreamUtils.toList(task.getUserList(), User::getProcessedBy);
        AssertUtil.isTrue(CollUtil.isNotEmpty(permissions) && (CollUtil.isEmpty(flowParams.getPermissionFlag()) || CollUtil.notContainsAny(flowParams.getPermissionFlag(), permissions)), "\u65e0\u6cd5\u8df3\u8f6c\u5230\u8be5\u8282\u70b9,\u8bf7\u68c0\u67e5\u5f53\u524d\u7528\u6237\u662f\u5426\u6709\u6743\u9650!");
    }

    private void oneVoteVeto(Task task, String nextNodeCode, FlowCombine flowCombine) {
        List<Task> tasks = this.list(FlowEngine.newTask().setInstanceId(task.getInstanceId()));
        ArrayList<Task> noDoneTasks = new ArrayList<Task>();
        List<Node> suffixNodeList = FlowEngine.nodeService().suffixNodeList(nextNodeCode, flowCombine);
        List<String> suffixCodes = StreamUtils.toList(suffixNodeList, Node::getNodeCode);
        for (Task flowTask : tasks) {
            if (!suffixCodes.contains(flowTask.getNodeCode())) continue;
            noDoneTasks.add(flowTask);
        }
        if (CollUtil.isNotEmpty(noDoneTasks)) {
            this.removeAndUser(noDoneTasks);
        }
    }

    private void handUndoneTask(Instance instance) {
        List<Task> taskList;
        if (NodeType.isEnd(instance.getNodeType()).booleanValue() && CollUtil.isNotEmpty(taskList = this.list(FlowEngine.newTask().setInstanceId(instance.getId())))) {
            this.removeAndUser(taskList);
        }
    }

    private void updateFlowInfo(Task task, Instance instance, List<Task> addTasks, FlowParams flowParams, List<Node> nextNodes) {
        HisTask insHis = FlowEngine.hisTaskService().setSkipInsHis(task, nextNodes, flowParams);
        FlowEngine.hisTaskService().save(insHis);
        this.removeAndUser(Collections.singletonList(task));
        List<User> users = FlowEngine.userService().taskAddUsers(addTasks);
        this.setInsFinishInfo(instance, addTasks, flowParams);
        if (CollUtil.isNotEmpty(addTasks)) {
            this.saveBatch(addTasks);
        }
        FlowEngine.insService().updateById(instance);
        FlowEngine.userService().saveBatch(users);
    }

    private boolean judgeActivityStatus(Definition definition, Instance instance) {
        return Objects.equals(definition.getActivityStatus(), ActivityStatus.ACTIVITY.getKey()) && Objects.equals(instance.getActivityStatus(), ActivityStatus.ACTIVITY.getKey());
    }

    @Override
    public FlowDto load(Long taskId, FlowParams flowParams) {
        R r = this.getAndCheck(taskId);
        ListenerVariable listenerVariable = new ListenerVariable(r.definition, r.instance, r.nowNode, flowParams.getVariable(), r.task);
        FlowDto flowDto = new FlowDto();
        if ("Y".equals(r.nowNode.getFormCustom())) {
            ListenerUtil.execute(listenerVariable, "formLoad", r.nowNode.getListenerPath(), r.nowNode.getListenerType());
            Form form = FlowEngine.formService().getById(Long.valueOf(r.task.getFormPath()));
            flowDto.setForm(form);
        } else if (StringUtils.isEmpty(r.nowNode.getFormCustom()) && "Y".equals(r.definition.getFormCustom())) {
            ListenerUtil.execute(listenerVariable, "formLoad", r.definition.getListenerPath(), r.definition.getListenerType());
            Form form = FlowEngine.formService().getById(Long.valueOf(r.definition.getFormPath()));
            flowDto.setForm(form);
        }
        flowDto.setData(r.instance.getVariableMap().get("formData"));
        return flowDto;
    }

    @Override
    public FlowDto hisLoad(Long hisTaskId, FlowParams flowParams) {
        HisTask hisTask = (HisTask)FlowEngine.hisTaskService().getById(hisTaskId);
        AssertUtil.isNull(hisTask, "\u672a\u83b7\u53d6\u5230\u6d41\u7a0b\u4efb\u52a1");
        Definition definition = (Definition)FlowEngine.defService().getById(hisTask.getDefinitionId());
        AssertUtil.isNull(definition, "\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u5b58\u5728!");
        Node nowNode = CollUtil.getOne(FlowEngine.nodeService().getByNodeCodes(Collections.singletonList(hisTask.getNodeCode()), hisTask.getDefinitionId()));
        AssertUtil.isNull(nowNode, "\u5f53\u524d\u6d41\u7a0b\u8282\u70b9\u4e22\u5931!");
        FlowDto flowDto = new FlowDto();
        if ("Y".equals(nowNode.getFormCustom())) {
            Form form = FlowEngine.formService().getById(Long.valueOf(hisTask.getFormPath()));
            flowDto.setForm(form);
        } else if (StringUtils.isEmpty(nowNode.getFormCustom()) && "Y".equals(definition.getFormCustom())) {
            Form form = FlowEngine.formService().getById(Long.valueOf(definition.getFormPath()));
            flowDto.setForm(form);
        }
        flowDto.setData(hisTask.getVariableMap().get("formData"));
        return flowDto;
    }

    private static class R {
        public final Instance instance;
        public final Definition definition;
        public final Node nowNode;
        public final Task task;

        public R(Instance instance, Definition definition, Node nowNode, Task task) {
            this.instance = instance;
            this.definition = definition;
            this.nowNode = nowNode;
            this.task = task;
        }
    }
}

