/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class ClassUtil {
    public static Class<?> getClazz(String className) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static <C> C clone(C origin) {
        if (Objects.isNull(origin)) {
            return null;
        }
        try {
            Field[] fields;
            Class<?> clazz = origin.getClass();
            Constructor<?> constructors = clazz.getConstructor(new Class[0]);
            Object instance = constructors.newInstance(new Object[0]);
            for (Field field : fields = clazz.getDeclaredFields()) {
                ClassUtil.makeAccessible(field);
                int modifiers = field.getModifiers();
                if (Modifier.isStatic(modifiers) || Modifier.isFinal(modifiers)) continue;
                Object value = field.get(origin);
                field.set(instance, value);
            }
            return (C)instance;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static void makeAccessible(Field field) {
        if (!(Modifier.isPublic(field.getModifiers()) && Modifier.isPublic(field.getDeclaringClass().getModifiers()) && !Modifier.isFinal(field.getModifiers()) || field.isAccessible())) {
            field.setAccessible(true);
        }
    }

    public static Set<Class<?>> findClasses(String packageName) throws IOException, ClassNotFoundException {
        HashSet classes = new HashSet();
        String packagePath = packageName.replace('.', '/');
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        Enumeration<URL> resources = classLoader.getResources(packagePath);
        while (resources.hasMoreElements()) {
            URL resource = resources.nextElement();
            String resourcePath = URLDecoder.decode(resource.getPath(), "UTF-8");
            if (resourcePath.startsWith("file:")) {
                resourcePath = resourcePath.substring(5);
            }
            if (resource.getProtocol().equals("file")) {
                ClassUtil.findClassesInFile(packageName, resourcePath, classes);
                continue;
            }
            if (!resource.getProtocol().equals("jar")) continue;
            ClassUtil.findClassesInJar(resourcePath, classes);
        }
        return classes;
    }

    private static void findClassesInFile(String packageName, String resourcePath, Set<Class<?>> classes) throws ClassNotFoundException {
        File dir = new File(resourcePath);
        if (!dir.exists() || !dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (File file : files) {
            if (file.isDirectory()) {
                ClassUtil.findClassesInFile(packageName + "." + file.getName(), file.getAbsolutePath(), classes);
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String className = packageName + '.' + file.getName().substring(0, file.getName().length() - 6);
            classes.add(Class.forName(className));
        }
    }

    private static void findClassesInJar(String resourcePath, Set<Class<?>> classes) throws IOException, ClassNotFoundException {
        int index = resourcePath.indexOf("!");
        String jarPath = resourcePath.substring(0, index);
        String packageInJarPath = resourcePath.substring(index + 2);
        try (JarFile jarFile = new JarFile(jarPath);){
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String entryName = entry.getName();
                if (!entryName.startsWith(packageInJarPath) || !entryName.endsWith(".class")) continue;
                String className = entryName.replace('/', '.').substring(0, entryName.length() - 6);
                classes.add(Class.forName(className));
            }
        }
    }
}

