/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.dto.FlowCombine;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.enums.SkipType;
import org.dromara.warm.flow.core.utils.AssertUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.StreamUtils;

public class FlowConfigUtil {
    private FlowConfigUtil() {
    }

    public static FlowCombine structureFlow(Definition definition) {
        FlowCombine combine = new FlowCombine();
        combine.setDefinition(definition);
        List<Node> allNodes = combine.getAllNodes();
        List<Skip> allSkips = combine.getAllSkips();
        String flowName = definition.getFlowName();
        AssertUtil.isEmpty(definition.getFlowCode(), "\u3010" + flowName + "\u3011\u6d41\u7a0bflowCode\u4e3a\u7a7a!");
        definition.setIsPublish(0);
        definition.setUpdateTime(new Date());
        FlowEngine.dataFillHandler().idFill(definition);
        List<Node> nodeList = definition.getNodeList();
        int startNum = 0;
        HashSet<String> nodeCodeSet = new HashSet<String>();
        for (Node node : nodeList) {
            FlowConfigUtil.initNodeAndCondition(node, definition.getId(), definition.getVersion());
            startNum = FlowConfigUtil.checkStartAndSame(node, startNum, flowName, nodeCodeSet);
            allNodes.add(node);
            allSkips.addAll(node.getSkipList());
        }
        Map<String, Integer> skipMap = StreamUtils.toMap(allNodes, Node::getNodeCode, Node::getNodeType);
        allSkips.forEach(allSkip -> allSkip.setNextNodeType((Integer)skipMap.get(allSkip.getNextNodeCode())));
        AssertUtil.isTrue(startNum == 0, "[" + flowName + "]" + "\u6d41\u7a0b\u7f3a\u5c11\u5f00\u59cb\u8282\u70b9!");
        FlowConfigUtil.checkSkipNode(allSkips);
        FlowConfigUtil.validaIsExistDestNode(allSkips, nodeCodeSet);
        return combine;
    }

    public static int checkStartAndSame(Node node, int startNum, String flowName, Set<String> nodeCodeSet) {
        if (NodeType.isStart(node.getNodeType()).booleanValue()) {
            AssertUtil.isTrue(++startNum > 1, "[" + flowName + "]" + "\u5f00\u59cb\u8282\u70b9\u4e0d\u80fd\u8d85\u8fc71\u4e2a!");
        }
        AssertUtil.contains(nodeCodeSet, node.getNodeCode(), "\u3010" + flowName + "\u3011" + "\u540c\u4e00\u6d41\u7a0b\u4e2d\u8282\u70b9\u7f16\u7801\u91cd\u590d!");
        nodeCodeSet.add(node.getNodeCode());
        return startNum;
    }

    public static void checkSkipNode(List<Skip> allSkips) {
        Map<String, List<Skip>> allSkipMap = StreamUtils.groupByKey(allSkips, Skip::getNowNodeCode);
        allSkipMap.forEach((key, values) -> {
            AtomicInteger passNum = new AtomicInteger();
            AtomicInteger rejectNum = new AtomicInteger();
            for (Skip value : values) {
                if (!NodeType.isBetween(value.getNowNodeType()).booleanValue() || !NodeType.isBetween(value.getNextNodeType()).booleanValue()) continue;
                if (SkipType.isPass(value.getSkipType()).booleanValue()) {
                    passNum.getAndIncrement();
                    continue;
                }
                rejectNum.getAndIncrement();
            }
            AssertUtil.isTrue(passNum.get() > 1 || rejectNum.get() > 1, "\u4e0d\u53ef\u540c\u65f6\u901a\u8fc7\u6216\u8005\u9000\u56de\u5230\u591a\u4e2a\u4e2d\u95f4\u8282\u70b9\uff0c\u5fc5\u987b\u5148\u6d41\u8f6c\u5230\u7f51\u5173\u8282\u70b9!");
        });
    }

    public static void validaIsExistDestNode(List<Skip> allSkips, Set<String> nodeCodeSet) {
        for (Skip allSkip : allSkips) {
            String nextNodeCode = allSkip.getNextNodeCode();
            AssertUtil.isTrue(!nodeCodeSet.contains(nextNodeCode), "\u3010" + nextNodeCode + "\u3011" + "\u76ee\u6807\u8282\u70b9\u7f16\u7801\u4e0d\u5b58\u5728!");
        }
    }

    public static void initNodeAndCondition(Node node, Long definitionId, String version) {
        String nodeName = node.getNodeName();
        String nodeCode = node.getNodeCode();
        List<Skip> skipList = node.getSkipList();
        if (!NodeType.isEnd(node.getNodeType()).booleanValue()) {
            AssertUtil.isEmpty(skipList, "\u5f00\u59cb\u6216\u8005\u4e2d\u95f4\u8282\u70b9\u5fc5\u987b\u753b\u8df3\u8f6c\u7ebf");
        }
        AssertUtil.isEmpty(nodeCode, "[" + nodeName + "]" + "\u8282\u70b9\u7f16\u7801\u7f3a\u5931");
        node.setVersion(version);
        node.setDefinitionId(definitionId);
        node.setUpdateTime(new Date());
        HashSet<String> betweenSet = new HashSet<String>();
        HashSet<String> gateWaySet = new HashSet<String>();
        int skipNum = 0;
        if (CollUtil.isNotEmpty(skipList)) {
            for (Skip skip : skipList) {
                String target;
                if (NodeType.isStart(node.getNodeType()).booleanValue()) {
                    AssertUtil.isTrue(++skipNum > 1, "[" + node.getNodeName() + "]" + "\u8282\u70b9\u6d41\u8f6c\u6761\u4ef6\u4e0d\u80fd\u8d85\u8fc71\u4e2a!");
                }
                AssertUtil.isEmpty(skip.getNextNodeCode(), "\u3010" + nodeName + "\u3011" + "\u76ee\u6807\u8282\u70b9\u4e3a\u7a7a!");
                FlowEngine.dataFillHandler().idFill(skip);
                skip.setDefinitionId(definitionId);
                skip.setNowNodeType(node.getNodeType());
                if (NodeType.isGateWaySerial(node.getNodeType()).booleanValue()) {
                    target = skip.getSkipCondition() + ":" + skip.getNextNodeCode();
                    AssertUtil.contains(gateWaySet, target, "[" + nodeName + "]" + "\u4e92\u65a5\u7f51\u5173\uff0c\u540c\u4e00\u4e2a\u8282\u70b9\u4e0d\u80fd\u6709\u76f8\u540c\u8df3\u8f6c\u6761\u4ef6\uff0c\u8df3\u8f6c\u540c\u4e00\u4e2a\u76ee\u6807\u8282\u70b9!");
                    gateWaySet.add(target);
                    continue;
                }
                if (NodeType.isGateWayParallel(node.getNodeType()).booleanValue()) {
                    target = skip.getNextNodeCode();
                    AssertUtil.contains(gateWaySet, target, "[" + nodeName + "]" + "\u5e76\u884c\u7f51\u5173\uff0c\u540c\u4e00\u4e2a\u8282\u70b9\u4e0d\u80fd\u8df3\u8f6c\u540c\u4e00\u4e2a\u76ee\u6807\u8282\u70b9!");
                    gateWaySet.add(target);
                    continue;
                }
                String value = skip.getSkipType() + ":" + skip.getNextNodeCode();
                AssertUtil.contains(betweenSet, value, "[" + nodeName + "]" + "\u4e2d\u95f4\u8282\u70b9\uff0c\u540c\u4e00\u4e2a\u8282\u70b9\u4e0d\u80fd\u6709\u76f8\u540c\u8df3\u8f6c\u7c7b\u578b\uff0c\u8df3\u8f6c\u540c\u4e00\u4e2a\u76ee\u6807\u8282\u70b9!");
                betweenSet.add(value);
            }
        }
    }
}

