/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.keygen.KenGen;
import org.dromara.warm.flow.core.keygen.SnowFlakeId14;
import org.dromara.warm.flow.core.keygen.SnowFlakeId15;
import org.dromara.warm.flow.core.keygen.SnowFlakeId19;

public class IdUtils {
    private static volatile KenGen instance;
    private static KenGen instanceNative;

    public static String nextIdStr() {
        return IdUtils.nextId().toString();
    }

    public static Long nextId() {
        return IdUtils.nextId(1L, 1L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Long nextId(long workerId, long datacenterId) {
        if (instance != null) return instance.nextId();
        Class<IdUtils> clazz = IdUtils.class;
        synchronized (IdUtils.class) {
            if (instance != null) return instance.nextId();
            String keyType = FlowEngine.getFlowConfig().getKeyType();
            if ("SnowId14".equals(keyType)) {
                instance = new SnowFlakeId14(workerId);
            } else if ("SnowId15".equals(keyType)) {
                instance = new SnowFlakeId15(workerId);
            }
            if (instance != null) return instance.nextId();
            instance = instanceNative != null ? instanceNative : new SnowFlakeId19(workerId, datacenterId);
            // ** MonitorExit[var4_2] (shouldn't be in output)
            return instance.nextId();
        }
    }

    public static void setInstanceNative(KenGen instanceNative) {
        IdUtils.instanceNative = instanceNative;
    }
}

