/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.dromara.warm.flow.core.exception.FlowException;
import org.dromara.warm.flow.core.utils.ClassUtil;

public class ReflectionUtil {
    public static Map<Class<?>, Object> scanAndInstance(String interfacePath, String implementPath) {
        HashMap instances = new HashMap();
        try {
            Set<Class<?>> interfaces = ClassUtil.findClasses(interfacePath);
            for (Class<?> interfaceClass : interfaces) {
                Set<Class<?>> implementSet = ClassUtil.findClasses(implementPath);
                Class implementationClass = implementSet.stream().filter(clazz -> ReflectionUtil.isDirectImplementation(clazz, interfaceClass) && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())).findFirst().orElse(null);
                if (implementationClass == null) continue;
                Object instance = implementationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                instances.put(interfaceClass, instance);
            }
        }
        catch (Exception e) {
            throw new FlowException("\u626b\u63cf\u5f02\u5e38");
        }
        return instances;
    }

    public static Map<Class<?>, Class<?>> scanAndClass(String interfacePath, String implementPath) {
        HashMap instances = new HashMap();
        try {
            Set<Class<?>> interfaces = ClassUtil.findClasses(interfacePath);
            for (Class<?> interfaceClass : interfaces) {
                Set<Class<?>> implementSet = ClassUtil.findClasses(implementPath);
                implementSet.stream().filter(clazz -> ReflectionUtil.isDirectImplementation(clazz, interfaceClass) && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())).findFirst().ifPresent(implementationClass -> instances.put(interfaceClass, (Class<?>)implementationClass));
            }
        }
        catch (Exception e) {
            throw new FlowException("\u626b\u63cf\u5f02\u5e38");
        }
        return instances;
    }

    public static Map<Class<?>, Supplier<?>> scanAndSupplier(String interfacePath, String implementPath) {
        HashMap suppliers = new HashMap();
        try {
            Set<Class<?>> interfaces = ClassUtil.findClasses(interfacePath);
            for (Class<?> interfaceClass : interfaces) {
                Set<Class<?>> implementSet = ClassUtil.findClasses(implementPath);
                implementSet.stream().filter(clazz -> ReflectionUtil.isDirectImplementation(clazz, interfaceClass) && !clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())).findFirst().ifPresent(implementationClass -> suppliers.put(interfaceClass, () -> {
                    try {
                        return implementationClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    catch (Exception e) {
                        throw new FlowException("\u626b\u63cf\u5f02\u5e38");
                    }
                }));
            }
        }
        catch (Exception e) {
            throw new FlowException("\u626b\u63cf\u5f02\u5e38");
        }
        return suppliers;
    }

    private static boolean isDirectImplementation(Class<?> clazz, Class<?> interfaceClass) {
        Class<?>[] interfaces;
        for (Class<?> iface : interfaces = clazz.getInterfaces()) {
            if (!iface.equals(interfaceClass)) continue;
            return true;
        }
        return false;
    }
}

