/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.dto;

import java.io.Serializable;

public class ApiResult<T>
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final int SUCCESS = 200;
    public static final int FAIL = 500;
    private int code;
    private String msg;
    private T data;

    public static <T> ApiResult<T> ok() {
        return ApiResult.restResult(null, 200, "\u64cd\u4f5c\u6210\u529f");
    }

    public static <T> ApiResult<T> ok(T data) {
        return ApiResult.restResult(data, 200, "\u64cd\u4f5c\u6210\u529f");
    }

    public static <T> ApiResult<T> ok(T data, String msg) {
        return ApiResult.restResult(data, 200, msg);
    }

    public static <T> ApiResult<T> fail() {
        return ApiResult.restResult(null, 500, "\u64cd\u4f5c\u5931\u8d25");
    }

    public static <T> ApiResult<T> fail(String msg) {
        return ApiResult.restResult(null, 500, msg);
    }

    public static <T> ApiResult<T> fail(T data) {
        return ApiResult.restResult(data, 500, "\u64cd\u4f5c\u5931\u8d25");
    }

    public static <T> ApiResult<T> fail(T data, String msg) {
        return ApiResult.restResult(data, 500, msg);
    }

    public static <T> ApiResult<T> fail(int code, String msg) {
        return ApiResult.restResult(null, code, msg);
    }

    private static <T> ApiResult<T> restResult(T data, int code, String msg) {
        ApiResult<T> apiResult = new ApiResult<T>();
        apiResult.setCode(code);
        apiResult.setData(data);
        apiResult.setMsg(msg);
        return apiResult;
    }

    public static <T> Boolean isError(ApiResult<T> ret) {
        return ApiResult.isSuccess(ret) == false;
    }

    public static <T> Boolean isSuccess(ApiResult<T> ret) {
        return 200 == ret.getCode();
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public void setData(T data) {
        this.data = data;
    }

    public int getCode() {
        return this.code;
    }

    public String getMsg() {
        return this.msg;
    }

    public T getData() {
        return this.data;
    }
}

