/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.dto;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.handler.PermissionHandler;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.StringUtils;

public class FlowParams
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String flowCode;
    private String handler;
    private String nodeCode;
    private List<String> permissionFlag;
    private String skipType;
    private String message;
    private Map<String, Object> variable;
    private String flowStatus;
    private String hisStatus;
    private Integer activityStatus;
    private Integer cooperateType;
    private String ext;
    private String hisTaskExt;
    private List<String> addHandlers;
    private List<String> reductionHandlers;
    private boolean ignore;
    private boolean ignoreDepute;
    private boolean ignoreCooperate;
    private String[] nextHandler;
    private boolean nextHandlerAppend;

    public FlowParams() {
    }

    public FlowParams(String skipType, String message, Map<String, Object> variable) {
        this.skipType = skipType;
        this.message = message;
        this.variable = variable;
    }

    public FlowParams(String nodeCode, String skipType, String message, Map<String, Object> variable) {
        this.nodeCode = nodeCode;
        this.skipType = skipType;
        this.message = message;
        this.variable = variable;
    }

    public FlowParams(String skipType, String message, Map<String, Object> variable, String flowStatus, String hisStatus) {
        this.skipType = skipType;
        this.message = message;
        this.variable = variable;
        this.flowStatus = flowStatus;
        this.hisStatus = hisStatus;
    }

    public FlowParams(String nodeCode, String skipType, String message, Map<String, Object> variable, String flowStatus, String hisStatus) {
        this.nodeCode = nodeCode;
        this.skipType = skipType;
        this.message = message;
        this.variable = variable;
        this.flowStatus = flowStatus;
        this.hisStatus = hisStatus;
    }

    public static FlowParams build() {
        return new FlowParams();
    }

    public FlowParams flowCode(String flowCode) {
        this.flowCode = flowCode;
        return this;
    }

    public FlowParams handler(String handler) {
        this.handler = handler;
        return this;
    }

    public FlowParams nodeCode(String nodeCode) {
        this.nodeCode = nodeCode;
        return this;
    }

    public FlowParams permissionFlag(List<String> permissionFlag) {
        this.permissionFlag = permissionFlag;
        return this;
    }

    public FlowParams message(String message) {
        this.message = message;
        return this;
    }

    public FlowParams variable(Map<String, Object> variable) {
        this.variable = variable;
        return this;
    }

    public FlowParams flowStatus(String flowStatus) {
        this.flowStatus = flowStatus;
        return this;
    }

    public FlowParams hisStatus(String hisStatus) {
        this.hisStatus = hisStatus;
        return this;
    }

    public FlowParams activityStatus(Integer activityStatus) {
        this.activityStatus = activityStatus;
        return this;
    }

    public FlowParams cooperateType(Integer cooperateType) {
        this.cooperateType = cooperateType;
        return this;
    }

    public FlowParams ext(String ext) {
        this.ext = ext;
        return this;
    }

    public FlowParams hisTaskExt(String hisTaskExt) {
        this.hisTaskExt = hisTaskExt;
        return this;
    }

    public FlowParams nextHandler(String ... nextHandler) {
        this.nextHandler = nextHandler;
        return this;
    }

    public String getVariableStr() {
        return FlowEngine.jsonConvert.objToStr(this.variable);
    }

    public String getHandler() {
        PermissionHandler permissionHandler;
        if (StringUtils.isEmpty(this.handler) && (permissionHandler = FlowEngine.permissionHandler()) != null) {
            this.handler = permissionHandler.getHandler();
        }
        return this.handler;
    }

    public List<String> getPermissionFlag() {
        PermissionHandler permissionHandler;
        if (CollUtil.isEmpty(this.permissionFlag) && (permissionHandler = FlowEngine.permissionHandler()) != null) {
            this.permissionFlag = permissionHandler.permissions();
        }
        return this.permissionFlag;
    }

    public FlowParams skipType(String skipType) {
        this.skipType = skipType;
        return this;
    }

    public FlowParams addHandlers(List<String> addHandlers) {
        this.addHandlers = addHandlers;
        return this;
    }

    public FlowParams reductionHandlers(List<String> reductionHandlers) {
        this.reductionHandlers = reductionHandlers;
        return this;
    }

    public FlowParams ignore(boolean ignore) {
        this.ignore = ignore;
        return this;
    }

    public FlowParams ignoreDepute(boolean ignoreDepute) {
        this.ignoreDepute = ignoreDepute;
        return this;
    }

    public FlowParams ignoreCooperate(boolean ignoreCooperate) {
        this.ignoreCooperate = ignoreCooperate;
        return this;
    }

    public FlowParams nextHandlerAppend(boolean nextHandlerAppend) {
        this.nextHandlerAppend = nextHandlerAppend;
        return this;
    }

    public FlowParams formData(Map<String, Object> formData) {
        if (this.variable == null) {
            this.variable = new HashMap<String, Object>();
        }
        this.variable.put("formData", formData);
        return this;
    }

    public String getFlowCode() {
        return this.flowCode;
    }

    public String getNodeCode() {
        return this.nodeCode;
    }

    public String getSkipType() {
        return this.skipType;
    }

    public String getMessage() {
        return this.message;
    }

    public Map<String, Object> getVariable() {
        return this.variable;
    }

    public String getFlowStatus() {
        return this.flowStatus;
    }

    public String getHisStatus() {
        return this.hisStatus;
    }

    public Integer getActivityStatus() {
        return this.activityStatus;
    }

    public Integer getCooperateType() {
        return this.cooperateType;
    }

    public String getExt() {
        return this.ext;
    }

    public String getHisTaskExt() {
        return this.hisTaskExt;
    }

    public List<String> getAddHandlers() {
        return this.addHandlers;
    }

    public List<String> getReductionHandlers() {
        return this.reductionHandlers;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    public boolean isIgnoreDepute() {
        return this.ignoreDepute;
    }

    public boolean isIgnoreCooperate() {
        return this.ignoreCooperate;
    }

    public String[] getNextHandler() {
        return this.nextHandler;
    }

    public boolean isNextHandlerAppend() {
        return this.nextHandlerAppend;
    }
}

