/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.enums;

import java.awt.Color;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dromara.warm.flow.core.enums.ModelEnum;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StringUtils;

public enum ChartStatus {
    NOT_DONE(0, "\u672a\u529e\u7406", new Color(166, 178, 189)),
    TO_DO(1, "\u5f85\u529e\u7406", new Color(255, 197, 90)),
    DONE(2, "\u5df2\u529e\u7406", new Color(135, 206, 250));

    private final Integer key;
    private final String value;
    private final Color color;
    private static final Map<Integer, Color> CUSTOM_COLOR;
    private static final Map<Integer, Color> CUSTOM_COLOR_CLASSICS;
    private static final Map<Integer, Color> CUSTOM_COLOR_MIMIC;

    public static void initCustomColor(List<String> chartStatusColor, List<String> chartStatusColorClassics, List<String> chartStatusColorMimic) {
        String[] colorArr;
        String statusColor;
        int i;
        if (CollUtil.isNotEmpty(chartStatusColor) && chartStatusColor.size() == 3) {
            for (i = 0; i < chartStatusColor.size(); ++i) {
                statusColor = chartStatusColor.get(i);
                if (!StringUtils.isNotEmpty(statusColor) || (colorArr = statusColor.split(",")).length != 3) continue;
                CUSTOM_COLOR.put(i, new Color(Integer.parseInt(colorArr[0]), Integer.parseInt(colorArr[1]), Integer.parseInt(colorArr[2])));
            }
        }
        if (CollUtil.isNotEmpty(chartStatusColorClassics) && chartStatusColorClassics.size() == 3) {
            for (i = 0; i < chartStatusColorClassics.size(); ++i) {
                statusColor = chartStatusColorClassics.get(i);
                if (!StringUtils.isNotEmpty(statusColor) || (colorArr = statusColor.split(",")).length != 3) continue;
                CUSTOM_COLOR_CLASSICS.put(i, new Color(Integer.parseInt(colorArr[0]), Integer.parseInt(colorArr[1]), Integer.parseInt(colorArr[2])));
            }
        }
        if (CollUtil.isNotEmpty(chartStatusColorMimic) && chartStatusColorMimic.size() == 3) {
            for (i = 0; i < chartStatusColorMimic.size(); ++i) {
                statusColor = chartStatusColorMimic.get(i);
                if (!StringUtils.isNotEmpty(statusColor) || (colorArr = statusColor.split(",")).length != 3) continue;
                CUSTOM_COLOR_MIMIC.put(i, new Color(Integer.parseInt(colorArr[0]), Integer.parseInt(colorArr[1]), Integer.parseInt(colorArr[2])));
            }
        }
    }

    public static Color getNotDone(String modelValue) {
        return ChartStatus.getColorByKey(NOT_DONE, modelValue);
    }

    public static Color getToDo(String modelValue) {
        return ChartStatus.getColorByKey(TO_DO, modelValue);
    }

    public static Color getDone(String modelValue) {
        return ChartStatus.getColorByKey(DONE, modelValue);
    }

    public static Color getColorByKey(ChartStatus chartStatus, String modelValue) {
        Color color = null;
        if (ModelEnum.CLASSICS.name().equals(modelValue)) {
            color = CUSTOM_COLOR_CLASSICS.get(chartStatus.getKey());
        } else if (ModelEnum.MIMIC.name().equals(modelValue)) {
            color = CUSTOM_COLOR_MIMIC.get(chartStatus.getKey());
        }
        if (ObjectUtil.isNull(color)) {
            color = CUSTOM_COLOR.get(chartStatus.getKey());
        }
        return ObjectUtil.defaultNull(color, chartStatus.getColor());
    }

    public static Color getColorByKey(Integer key) {
        for (ChartStatus item : ChartStatus.values()) {
            if (!item.getKey().equals(key)) continue;
            Color color = CUSTOM_COLOR.get(key);
            return ObjectUtil.defaultNull(color, item.getColor());
        }
        return null;
    }

    public static Boolean isNotDone(Integer key) {
        return ObjectUtil.isNotNull(key) && NOT_DONE.getKey().equals(key);
    }

    public static Boolean isToDo(Integer key) {
        return ObjectUtil.isNotNull(key) && TO_DO.getKey().equals(key);
    }

    public static Boolean isDone(Integer key) {
        return ObjectUtil.isNotNull(key) && DONE.getKey().equals(key);
    }

    public Integer getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    public Color getColor() {
        return this.color;
    }

    private ChartStatus(Integer key, String value, Color color) {
        this.key = key;
        this.value = value;
        this.color = color;
    }

    static {
        CUSTOM_COLOR = new HashMap<Integer, Color>();
        CUSTOM_COLOR_CLASSICS = new HashMap<Integer, Color>();
        CUSTOM_COLOR_MIMIC = new HashMap<Integer, Color>();
    }
}

