/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.handler;

import java.util.Date;
import java.util.Objects;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.entity.RootEntity;
import org.dromara.warm.flow.core.handler.PermissionHandler;
import org.dromara.warm.flow.core.utils.IdUtils;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface DataFillHandler {
    public static final Logger logger = LoggerFactory.getLogger(DataFillHandler.class);

    default public void idFill(Object object) {
        RootEntity entity = (RootEntity)object;
        if (ObjectUtil.isNull(entity)) {
            logger.warn("Insert operation failed - Reason: Entity is null after casting");
            return;
        }
        if (Objects.isNull(entity.getId())) {
            entity.setId(IdUtils.nextId());
        }
    }

    default public void insertFill(Object object) {
        RootEntity entity = (RootEntity)object;
        if (ObjectUtil.isNull(entity)) {
            logger.warn("Insert operation failed - Reason: Entity is null after casting");
            return;
        }
        entity.setCreateTime(ObjectUtil.isNotNull(entity.getCreateTime()) ? entity.getCreateTime() : new Date());
        entity.setUpdateTime(ObjectUtil.isNotNull(entity.getUpdateTime()) ? entity.getUpdateTime() : new Date());
        PermissionHandler permissionHandler = FlowEngine.permissionHandler();
        String handler = null;
        if (permissionHandler != null) {
            handler = permissionHandler.getHandler();
        }
        entity.setCreateBy(StringUtils.isNotEmpty(handler) ? handler : entity.getCreateBy());
        entity.setUpdateBy(StringUtils.isNotEmpty(handler) ? handler : entity.getUpdateBy());
    }

    default public void updateFill(Object object) {
        RootEntity entity = (RootEntity)object;
        if (ObjectUtil.isNull(entity)) {
            logger.warn("Insert operation failed - Reason: Entity is null after casting");
            return;
        }
        entity.setUpdateTime(ObjectUtil.isNotNull(entity.getUpdateTime()) ? entity.getUpdateTime() : new Date());
        PermissionHandler permissionHandler = FlowEngine.permissionHandler();
        String handler = null;
        if (permissionHandler != null) {
            handler = permissionHandler.getHandler();
        }
        entity.setUpdateBy(StringUtils.isNotEmpty(handler) ? handler : entity.getUpdateBy());
    }
}

