/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.service.impl;

import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.dto.DefJson;
import org.dromara.warm.flow.core.dto.NodeJson;
import org.dromara.warm.flow.core.dto.PathWayData;
import org.dromara.warm.flow.core.dto.SkipJson;
import org.dromara.warm.flow.core.entity.Instance;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.enums.ChartStatus;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.enums.SkipType;
import org.dromara.warm.flow.core.service.ChartService;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StreamUtils;
import org.dromara.warm.flow.core.utils.StringUtils;

public class ChartServiceImpl
implements ChartService {
    @Override
    public String startMetadata(PathWayData pathWayData) {
        DefJson defJson = FlowEngine.defService().queryDesign(pathWayData.getDefId());
        List<NodeJson> nodeList = defJson.getNodeList();
        Map<String, NodeJson> nodeMap = StreamUtils.toMap(nodeList, NodeJson::getNodeCode, node -> node.setStatus(ChartStatus.NOT_DONE.getKey()));
        Map<String, SkipJson> skipMap = nodeList.stream().map(NodeJson::getSkipList).flatMap(Collection::stream).collect(Collectors.toMap(this::getSkipKey, skip -> skip.setStatus(ChartStatus.NOT_DONE.getKey())));
        pathWayData.getPathWayNodes().forEach(node -> ((NodeJson)nodeMap.get(node.getNodeCode())).setStatus(ChartStatus.DONE.getKey()));
        pathWayData.getPathWaySkips().forEach(skip -> ((SkipJson)skipMap.get(this.getSkipKey((Skip)skip))).setStatus(ChartStatus.DONE.getKey()));
        pathWayData.getTargetNodes().forEach(node -> ((NodeJson)nodeMap.get(node.getNodeCode())).setStatus(NodeType.isEnd(node.getNodeType()) != false ? ChartStatus.DONE.getKey() : ChartStatus.TO_DO.getKey()));
        return FlowEngine.jsonConvert.objToStr(defJson);
    }

    @Override
    public String skipMetadata(PathWayData pathWayData) {
        Instance instance = (Instance)FlowEngine.insService().getById(pathWayData.getInsId());
        DefJson defJson = FlowEngine.jsonConvert.strToBean(instance.getDefJson(), DefJson.class);
        List<NodeJson> nodeList = defJson.getNodeList();
        List skipList = StreamUtils.toListAll(defJson.getNodeList(), NodeJson::getSkipList);
        Map<String, NodeJson> nodeMap = StreamUtils.toMap(nodeList, NodeJson::getNodeCode, node -> node);
        Map<String, SkipJson> skipMap = StreamUtils.toMap(skipList, this::getSkipKey, skip -> skip);
        pathWayData.getPathWayNodes().forEach(node -> {
            NodeJson nodeJson = (NodeJson)nodeMap.get(node.getNodeCode());
            if (SkipType.isPass(pathWayData.getSkipType()).booleanValue()) {
                nodeJson.setStatus(ChartStatus.DONE.getKey());
            } else if (SkipType.isReject(pathWayData.getSkipType()).booleanValue()) {
                nodeJson.setStatus(ChartStatus.NOT_DONE.getKey());
            }
        });
        pathWayData.getPathWaySkips().forEach(skip -> {
            SkipJson skipJson = (SkipJson)skipMap.get(this.getSkipKey((Skip)skip));
            if (SkipType.isPass(pathWayData.getSkipType()).booleanValue()) {
                skipJson.setStatus(ChartStatus.DONE.getKey());
            } else if (SkipType.isReject(pathWayData.getSkipType()).booleanValue()) {
                skipJson.setStatus(ChartStatus.NOT_DONE.getKey());
            }
        });
        pathWayData.getTargetNodes().forEach(node -> {
            NodeJson nodeJson = (NodeJson)nodeMap.get(node.getNodeCode());
            if (NodeType.isEnd(node.getNodeType()).booleanValue()) {
                nodeJson.setStatus(ChartStatus.DONE.getKey());
            } else {
                nodeJson.setStatus(ChartStatus.TO_DO.getKey());
            }
        });
        if (SkipType.isReject(pathWayData.getSkipType()).booleanValue()) {
            Map<String, List<SkipJson>> skipNextMap = StreamUtils.groupByKeyFilter(skip -> SkipType.isReject(skip.getSkipType()) == false, skipList, SkipJson::getNowNodeCode);
            pathWayData.getTargetNodes().forEach(node -> this.rejectReset(node.getNodeCode(), skipNextMap, nodeMap));
        }
        pathWayData.getTargetNodes().forEach(node -> {
            if (NodeType.isEnd(node.getNodeType()).booleanValue()) {
                nodeList.forEach(nodeJson -> {
                    if (ChartStatus.isToDo(nodeJson.getStatus()).booleanValue()) {
                        nodeJson.setStatus(ChartStatus.NOT_DONE.getKey());
                    }
                });
            }
        });
        return FlowEngine.jsonConvert.objToStr(defJson);
    }

    @Override
    public List<String> getChartRgb(String modelValue) {
        ArrayList<String> chartStatusColor = new ArrayList<String>();
        Color done = ChartStatus.getDone(modelValue);
        chartStatusColor.add(done.getRed() + "," + done.getGreen() + "," + done.getBlue());
        Color toDo = ChartStatus.getToDo(modelValue);
        chartStatusColor.add(toDo.getRed() + "," + toDo.getGreen() + "," + toDo.getBlue());
        Color notDone = ChartStatus.getNotDone(modelValue);
        chartStatusColor.add(notDone.getRed() + "," + notDone.getGreen() + "," + notDone.getBlue());
        return chartStatusColor;
    }

    private String getSkipKey(SkipJson skip) {
        return StringUtils.join(new String[]{skip.getNowNodeCode(), skip.getSkipType(), skip.getSkipCondition(), skip.getNextNodeCode()}, ":");
    }

    private String getSkipKey(Skip skip) {
        return StringUtils.join(new String[]{skip.getNowNodeCode(), skip.getSkipType(), skip.getSkipCondition(), skip.getNextNodeCode()}, ":");
    }

    private void rejectReset(String nodeCode, Map<String, List<SkipJson>> skipNextMap, Map<String, NodeJson> nodeMap) {
        List<SkipJson> oneNextSkips = skipNextMap.get(nodeCode);
        if (CollUtil.isNotEmpty(oneNextSkips)) {
            oneNextSkips.forEach(oneNextSkip -> {
                if (ObjectUtil.isNotNull(oneNextSkip) && !ChartStatus.isNotDone(oneNextSkip.getStatus()).booleanValue()) {
                    oneNextSkip.setStatus(ChartStatus.NOT_DONE.getKey());
                    NodeJson nodeJson = (NodeJson)nodeMap.get(oneNextSkip.getNextNodeCode());
                    if (ObjectUtil.isNotNull(nodeJson) && !ChartStatus.isNotDone(nodeJson.getStatus()).booleanValue()) {
                        nodeJson.setStatus(ChartStatus.NOT_DONE.getKey());
                        this.rejectReset(nodeJson.getNodeCode(), skipNextMap, nodeMap);
                    }
                }
            });
        }
    }
}

