/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.service.impl;

import java.util.Collections;
import java.util.List;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.Form;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.enums.PublishStatus;
import org.dromara.warm.flow.core.orm.dao.FlowFormDao;
import org.dromara.warm.flow.core.orm.service.impl.WarmServiceImpl;
import org.dromara.warm.flow.core.service.FormService;
import org.dromara.warm.flow.core.utils.AssertUtil;
import org.dromara.warm.flow.core.utils.ClassUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.page.Page;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FormServiceImpl
extends WarmServiceImpl<FlowFormDao<Form>, Form>
implements FormService {
    public static final Logger LOGGER = LoggerFactory.getLogger(FormServiceImpl.class);

    public FormService setDao(FlowFormDao<Form> warmDao) {
        this.warmDao = warmDao;
        return this;
    }

    @Override
    public boolean publish(Long id) {
        Form form = this.getById(id);
        AssertUtil.isTrue(form.getIsPublish().equals(PublishStatus.PUBLISHED.getKey()), "\u5f53\u524d\u8868\u5355\u72b6\u6001\u5df2\u53d1\u5e03");
        form.setIsPublish(PublishStatus.PUBLISHED.getKey());
        return this.updateById(form);
    }

    @Override
    public boolean unPublish(Long id) {
        Form form = this.getById(id);
        List<Node> nodes = FlowEngine.nodeService().list(FlowEngine.newNode().setFormPath("" + form.getId()));
        AssertUtil.isNotEmpty(nodes, "\u6d41\u7a0b\u8868\u5355\u5df2\u4f7f\u7528\uff0c\u4e0d\u53ef\u64cd\u4f5c!");
        List<Definition> definitions = FlowEngine.defService().list(FlowEngine.newDef().setFormPath("" + form.getId()));
        AssertUtil.isNotEmpty(definitions, "\u6d41\u7a0b\u8868\u5355\u5df2\u4f7f\u7528\uff0c\u4e0d\u53ef\u64cd\u4f5c!");
        AssertUtil.isTrue(form.getIsPublish().equals(PublishStatus.UNPUBLISHED.getKey()), "\u5f53\u524d\u8868\u5355\u72b6\u6001\u672a\u53d1\u5e03");
        form.setIsPublish(PublishStatus.UNPUBLISHED.getKey());
        return this.updateById(form);
    }

    @Override
    public boolean save(Form form) {
        form.setVersion(this.getNewVersion(form));
        return super.save(form);
    }

    @Override
    public boolean copyForm(Long id) {
        Form form = ClassUtil.clone(this.getById(id));
        AssertUtil.isTrue(ObjectUtil.isNull(form), "\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u5b58\u5728!");
        FlowEngine.dataFillHandler().idFill(form.setId(null));
        form.setVersion(this.getNewVersion(form)).setIsPublish(PublishStatus.UNPUBLISHED.getKey()).setCreateTime(null).setUpdateTime(null);
        return this.save(form);
    }

    @Override
    public Form getByCode(String formCode, String formVersion) {
        List<Form> list = this.list(FlowEngine.newForm().setFormCode(formCode).setVersion(formVersion));
        AssertUtil.isTrue(CollUtil.isEmpty(list), "\u672a\u627e\u5230\u5f85\u529e\u4efb\u52a1!");
        AssertUtil.isTrue(list.size() > 1, "\u8868\u5355\u6570\u636e\u9519\u8bef, \u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u6392\u67e5!");
        return list.get(0);
    }

    @Override
    public Form getById(Long id) {
        AssertUtil.isNull(id, "ID\u4e0d\u80fd\u4e3a\u7a7a");
        return (Form)super.getById(id);
    }

    @Override
    public Page<Form> publishedPage(String formName, Integer pageNum, Integer pageSize) {
        return this.page(FlowEngine.newForm().setFormName(formName).setIsPublish(1), Page.pageOf(pageNum, pageSize));
    }

    @Override
    public boolean saveContent(Long id, String formContent) {
        Form form = this.getById(id);
        AssertUtil.isTrue(form.getIsPublish().equals(PublishStatus.PUBLISHED.getKey()), "\u5f53\u524d\u8868\u5355\u72b6\u6001\u5df2\u53d1\u5e03");
        form.setFormContent(formContent);
        return this.updateById(form);
    }

    private String getNewVersion(Form form) {
        List<String> formCodeList = Collections.singletonList(form.getFormCode());
        List forms = ((FlowFormDao)this.getDao()).queryByCodeList(formCodeList);
        int highestVersion = 0;
        for (Form otherForm : forms) {
            if (!form.getFormCode().equals(otherForm.getFormCode())) continue;
            try {
                int version = Integer.parseInt(otherForm.getVersion());
                if (version <= highestVersion) continue;
                highestVersion = version;
            }
            catch (NumberFormatException e) {
                LOGGER.error("\u7248\u672c\u683c\u5f0f\u5316\u5f02\u5e38 - {}", (Object)e.getLocalizedMessage());
            }
        }
        String version = "1";
        if (highestVersion > 0) {
            version = String.valueOf(highestVersion + 1);
        }
        return version;
    }
}

