/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.dto.FlowCombine;
import org.dromara.warm.flow.core.dto.FlowParams;
import org.dromara.warm.flow.core.dto.PathWayData;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.HisTask;
import org.dromara.warm.flow.core.entity.Instance;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Task;
import org.dromara.warm.flow.core.entity.User;
import org.dromara.warm.flow.core.enums.ActivityStatus;
import org.dromara.warm.flow.core.enums.FlowStatus;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.enums.SkipType;
import org.dromara.warm.flow.core.listener.ListenerVariable;
import org.dromara.warm.flow.core.orm.dao.FlowInstanceDao;
import org.dromara.warm.flow.core.orm.service.impl.WarmServiceImpl;
import org.dromara.warm.flow.core.service.InsService;
import org.dromara.warm.flow.core.utils.AssertUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ExpressionUtil;
import org.dromara.warm.flow.core.utils.ListenerUtil;
import org.dromara.warm.flow.core.utils.StreamUtils;
import org.dromara.warm.flow.core.utils.StringUtils;

public class InsServiceImpl
extends WarmServiceImpl<FlowInstanceDao<Instance>, Instance>
implements InsService {
    public InsService setDao(FlowInstanceDao<Instance> warmDao) {
        this.warmDao = warmDao;
        return this;
    }

    @Override
    public Instance start(String businessId, FlowParams flowParams) {
        AssertUtil.isNull(flowParams.getFlowCode(), "\u6d41\u7a0b\u7f16\u7801\u7f3a\u5931!");
        AssertUtil.isEmpty(businessId, "\u4e1a\u52a1id\u4e3a\u7a7a!");
        Definition definition = FlowEngine.defService().getPublishByFlowCode(flowParams.getFlowCode());
        AssertUtil.isNull(definition, "\u6d41\u7a0b\u5b9a\u4e49\u4e0d\u5b58\u5728!");
        FlowCombine flowCombine = FlowEngine.defService().getFlowCombine(definition);
        Node startNode = StreamUtils.filterOne(flowCombine.getAllNodes(), t -> NodeType.isStart(t.getNodeType()));
        AssertUtil.isNull(startNode, "\u6d41\u7a0b\u7f3a\u5c11\u5f00\u59cb\u8282\u70b9!");
        AssertUtil.isTrue(definition.getActivityStatus().equals(ActivityStatus.SUSPENDED.getKey()), "\u5f53\u524d\u6d41\u7a0b\u5b9a\u4e49\u5df2\u6302\u8d77\uff0c\u4e0d\u53ef\u5f00\u542f\u65b0\u7684\u6d41\u7a0b");
        flowParams.skipType(SkipType.PASS.getKey());
        ListenerUtil.executeListener(new ListenerVariable(definition, null, startNode, flowParams.getVariable()).setFlowParams(flowParams), "start");
        PathWayData pathWayData = new PathWayData().setDefId(startNode.getDefinitionId()).setSkipType(flowParams.getSkipType());
        List<Node> nextNodes = FlowEngine.nodeService().getNextNodeList(startNode, null, flowParams.getSkipType(), flowParams.getVariable(), pathWayData, flowCombine);
        Instance instance = this.setStartInstance(nextNodes.get(0), businessId, flowParams);
        HisTask hisTask = this.setHisTask(nextNodes, flowParams, startNode, instance.getId());
        List<Task> addTasks = StreamUtils.toList(nextNodes, node -> FlowEngine.taskService().addTask((Node)node, instance, definition, flowParams));
        if (CollUtil.isNotEmpty(addTasks)) {
            ExpressionUtil.evalVariable(addTasks, flowParams);
        }
        pathWayData.getTargetNodes().addAll(nextNodes);
        instance.setDefJson(FlowEngine.chartService().startMetadata(pathWayData));
        ListenerUtil.executeListener(new ListenerVariable(definition, instance, startNode, flowParams.getVariable(), null, nextNodes, addTasks).setFlowParams(flowParams), "assignment");
        this.saveFlowInfo(instance, addTasks, hisTask, flowParams);
        ListenerUtil.endCreateListener(new ListenerVariable(definition, instance, startNode, flowParams.getVariable(), null, nextNodes, addTasks).setFlowParams(flowParams));
        return instance;
    }

    @Override
    public List<Instance> listByDefIds(List<Long> defIds) {
        return ((FlowInstanceDao)this.getDao()).getByDefIds(defIds);
    }

    @Override
    public boolean remove(List<Long> instanceIds) {
        return this.toRemoveTask(instanceIds);
    }

    @Override
    public List<Instance> getByDefId(Long definitionId) {
        return this.list(FlowEngine.newIns().setDefinitionId(definitionId));
    }

    private HisTask setHisTask(List<Node> nextNodes, FlowParams flowParams, Node startNode, Long instanceId) {
        Task startTask = FlowEngine.newTask().setInstanceId(instanceId).setDefinitionId(startNode.getDefinitionId()).setNodeCode(startNode.getNodeCode()).setNodeName(startNode.getNodeName()).setNodeType(startNode.getNodeType());
        FlowEngine.dataFillHandler().idFill(startTask);
        return FlowEngine.hisTaskService().setSkipInsHis(startTask, nextNodes, flowParams);
    }

    private void saveFlowInfo(Instance instance, List<Task> addTasks, HisTask hisTask, FlowParams flowParams) {
        FlowEngine.taskService().setInsFinishInfo(instance, addTasks, flowParams);
        if (CollUtil.isNotEmpty(addTasks)) {
            List<User> users = FlowEngine.userService().taskAddUsers(addTasks);
            FlowEngine.taskService().saveBatch(addTasks);
            FlowEngine.userService().saveBatch(users);
        }
        FlowEngine.hisTaskService().save(hisTask);
        this.save(instance);
    }

    private Instance setStartInstance(Node firstBetweenNode, String businessId, FlowParams flowParams) {
        Instance instance = FlowEngine.newIns();
        Date now = new Date();
        FlowEngine.dataFillHandler().idFill(instance);
        instance.setDefinitionId(firstBetweenNode.getDefinitionId()).setBusinessId(businessId).setNodeType(firstBetweenNode.getNodeType()).setNodeCode(firstBetweenNode.getNodeCode()).setNodeName(firstBetweenNode.getNodeName()).setFlowStatus(StringUtils.emptyDefault(flowParams.getFlowStatus(), FlowStatus.TOBESUBMIT.getKey())).setActivityStatus(ActivityStatus.ACTIVITY.getKey()).setVariable(FlowEngine.jsonConvert.objToStr(flowParams.getVariable())).setCreateTime(now).setUpdateTime(now).setCreateBy(flowParams.getHandler()).setUpdateBy(flowParams.getHandler()).setExt(flowParams.getExt());
        return instance;
    }

    private boolean toRemoveTask(List<Long> instanceIds) {
        AssertUtil.isEmpty(instanceIds, "\u6d41\u7a0b\u5b9e\u4f8bid\u4e0d\u80fd\u4e3a\u7a7a!");
        ArrayList<Long> taskIds = new ArrayList<Long>();
        instanceIds.forEach(instanceId -> taskIds.addAll(FlowEngine.taskService().list(FlowEngine.newTask().setInstanceId((Long)instanceId)).stream().map(Task::getId).collect(Collectors.toList())));
        if (CollUtil.isNotEmpty(taskIds)) {
            FlowEngine.userService().deleteByTaskIds(taskIds);
        }
        FlowEngine.taskService().deleteByInsIds(instanceIds);
        FlowEngine.hisTaskService().deleteByInsIds(instanceIds);
        return FlowEngine.insService().removeByIds(instanceIds);
    }

    @Override
    public boolean active(Long id) {
        Instance instance = (Instance)this.getById(id);
        AssertUtil.isTrue(ActivityStatus.isActivity(instance.getActivityStatus()), "\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u7ecf\u6fc0\u6d3b");
        instance.setActivityStatus(ActivityStatus.ACTIVITY.getKey());
        return this.updateById(instance);
    }

    @Override
    public boolean unActive(Long id) {
        Instance instance = (Instance)this.getById(id);
        AssertUtil.isTrue(ActivityStatus.isSuspended(instance.getActivityStatus()), "\u5f53\u524d\u6d41\u7a0b\u5b9e\u4f8b\u5df2\u7ecf\u6fc0\u6d3b");
        instance.setActivityStatus(ActivityStatus.SUSPENDED.getKey());
        return this.updateById(instance);
    }

    @Override
    public void removeVariables(Long instanceId, String ... keys) {
        Instance instance = (Instance)FlowEngine.insService().getById(instanceId);
        if (instance != null) {
            Map<String, Object> variableMap = instance.getVariableMap();
            for (String key : keys) {
                variableMap.remove(key);
            }
            instance.setVariable(FlowEngine.jsonConvert.objToStr(variableMap));
            FlowEngine.insService().updateById(instance);
        }
    }
}

