/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.service.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.entity.Task;
import org.dromara.warm.flow.core.entity.User;
import org.dromara.warm.flow.core.enums.UserType;
import org.dromara.warm.flow.core.orm.dao.FlowUserDao;
import org.dromara.warm.flow.core.orm.service.impl.WarmServiceImpl;
import org.dromara.warm.flow.core.service.UserService;
import org.dromara.warm.flow.core.utils.ArrayUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.StreamUtils;

public class UserServiceImpl
extends WarmServiceImpl<FlowUserDao<User>, User>
implements UserService {
    public UserService setDao(FlowUserDao<User> warmDao) {
        this.warmDao = warmDao;
        return this;
    }

    @Override
    public List<User> taskAddUsers(List<Task> addTasks) {
        ArrayList<User> taskUserList = new ArrayList<User>();
        if (CollUtil.isNotEmpty(addTasks)) {
            StreamUtils.toList(addTasks, task -> taskUserList.addAll(this.taskAddUser((Task)task)));
        }
        return taskUserList;
    }

    @Override
    public List<User> taskAddUser(Task task) {
        List<User> userList = StreamUtils.toList(task.getPermissionList(), permission -> this.structureUser(task.getId(), (String)permission, UserType.APPROVAL.getKey()));
        task.setUserList(userList);
        return userList;
    }

    @Override
    public void deleteByTaskIds(List<Long> ids) {
        ((FlowUserDao)this.getDao()).deleteByTaskIds(ids);
    }

    @Override
    public List<String> getPermission(Long associated, String ... types) {
        if (ArrayUtil.isEmpty(types)) {
            return StreamUtils.toList(this.list(FlowEngine.newUser().setAssociated(associated)), User::getProcessedBy);
        }
        if (types.length == 1) {
            return StreamUtils.toList(this.list(FlowEngine.newUser().setAssociated(associated).setType(types[0])), User::getProcessedBy);
        }
        return StreamUtils.toList(((FlowUserDao)this.getDao()).listByAssociatedAndTypes(Collections.singletonList(associated), types), User::getProcessedBy);
    }

    @Override
    public List<User> listByAssociatedAndTypes(Long associated, String ... types) {
        if (ArrayUtil.isEmpty(types)) {
            return this.list(FlowEngine.newUser().setAssociated(associated));
        }
        if (types.length == 1) {
            return this.list(FlowEngine.newUser().setAssociated(associated).setType(types[0]));
        }
        return ((FlowUserDao)this.getDao()).listByAssociatedAndTypes(Collections.singletonList(associated), types);
    }

    @Override
    public List<User> getByAssociateds(List<Long> associateds, String ... types) {
        if (CollUtil.isNotEmpty(associateds) && associateds.size() == 1) {
            return this.listByAssociatedAndTypes(associateds.get(0), types);
        }
        return ((FlowUserDao)this.getDao()).listByAssociatedAndTypes(associateds, types);
    }

    @Override
    public List<User> listByProcessedBys(Long associated, String processedBy, String ... types) {
        if (ArrayUtil.isEmpty(types)) {
            return this.list(FlowEngine.newUser().setAssociated(associated).setProcessedBy(processedBy));
        }
        if (types.length == 1) {
            return this.list(FlowEngine.newUser().setAssociated(associated).setProcessedBy(processedBy).setType(types[0]));
        }
        return ((FlowUserDao)this.getDao()).listByProcessedBys(associated, Collections.singletonList(processedBy), types);
    }

    @Override
    public List<User> getByProcessedBys(Long associated, List<String> processedBys, String ... types) {
        if (CollUtil.isNotEmpty(processedBys) && processedBys.size() == 1) {
            return this.listByProcessedBys(associated, processedBys.get(0), types);
        }
        return ((FlowUserDao)this.getDao()).listByProcessedBys(associated, processedBys, types);
    }

    @Override
    public boolean updatePermission(Long associated, List<String> permissions, String type, boolean clear, String handler) {
        if (clear) {
            ((FlowUserDao)this.getDao()).delete(FlowEngine.newUser().setAssociated(associated).setCreateBy(handler));
        }
        this.saveBatch(StreamUtils.toList(permissions, permission -> this.structureUser(associated, (String)permission, type, handler)));
        return true;
    }

    @Override
    public List<User> structureUser(Long associated, List<String> permissionList, String type) {
        return StreamUtils.toList(permissionList, permission -> this.structureUser(associated, (String)permission, type, null));
    }

    @Override
    public User structureUser(Long associated, String permission, String type) {
        return this.structureUser(associated, permission, type, null);
    }

    @Override
    public List<User> structureUser(Long associated, List<String> permissionList, String type, String handler) {
        return StreamUtils.toList(permissionList, permission -> this.structureUser(associated, (String)permission, type, handler));
    }

    @Override
    public User structureUser(Long associated, String permission, String type, String handler) {
        Date now = new Date();
        User user = FlowEngine.newUser().setType(type).setProcessedBy(permission).setAssociated(associated).setCreateBy(handler);
        FlowEngine.dataFillHandler().idFill(user);
        return user;
    }
}

