/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import java.util.Collection;
import java.util.Map;
import org.dromara.warm.flow.core.exception.FlowException;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.MapUtil;
import org.dromara.warm.flow.core.utils.StringUtils;

public class AssertUtil {
    private AssertUtil() {
    }

    public static void isNull(Object obj, String errorMsg) {
        if (obj == null) {
            throw new FlowException(errorMsg);
        }
    }

    public static void isNotNull(Object obj, String errorMsg) {
        if (obj != null) {
            throw new FlowException(errorMsg);
        }
    }

    public static void isFalse(boolean obj, String errorMsg) {
        if (!obj) {
            throw new FlowException(errorMsg);
        }
    }

    public static void isTrue(boolean obj, String errorMsg) {
        if (obj) {
            throw new FlowException(errorMsg);
        }
    }

    public static void isNotEmpty(Object obj, String errorMsg) {
        if (obj != null) {
            if (obj instanceof String) {
                AssertUtil.isTrue(StringUtils.isNotEmpty((String)obj), errorMsg);
            } else if (obj instanceof Collection) {
                AssertUtil.isTrue(CollUtil.isNotEmpty((Collection)obj), errorMsg);
            } else if (obj instanceof Map) {
                AssertUtil.isTrue(MapUtil.isNotEmpty((Map)obj), errorMsg);
            } else {
                throw new FlowException("Unsupported type: " + obj.getClass().getName());
            }
        }
    }

    public static void isEmpty(Object obj, String errorMsg) {
        if (obj == null) {
            throw new FlowException(errorMsg);
        }
        if (obj instanceof String) {
            AssertUtil.isTrue(StringUtils.isEmpty((String)obj), errorMsg);
        } else if (obj instanceof Collection) {
            AssertUtil.isTrue(CollUtil.isEmpty((Collection)obj), errorMsg);
        } else if (obj instanceof Map) {
            AssertUtil.isTrue(MapUtil.isEmpty((Map)obj), errorMsg);
        } else {
            throw new FlowException("Unsupported type: " + obj.getClass().getName());
        }
    }

    public static <T> void contains(Collection<T> a, T b, String errorMsg) {
        if (CollUtil.isNotEmpty(a) && a.contains(b)) {
            throw new FlowException(errorMsg);
        }
    }

    public static <T> void notContains(Collection<T> a, T b, String errorMsg) {
        if (CollUtil.isEmpty(a) || !a.contains(b)) {
            throw new FlowException(errorMsg);
        }
    }
}

