/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.condition.ConditionStrategy;
import org.dromara.warm.flow.core.condition.ConditionStrategyEq;
import org.dromara.warm.flow.core.condition.ConditionStrategyGe;
import org.dromara.warm.flow.core.condition.ConditionStrategyGt;
import org.dromara.warm.flow.core.condition.ConditionStrategyLe;
import org.dromara.warm.flow.core.condition.ConditionStrategyLike;
import org.dromara.warm.flow.core.condition.ConditionStrategyLt;
import org.dromara.warm.flow.core.condition.ConditionStrategyNe;
import org.dromara.warm.flow.core.condition.ConditionStrategyNotLike;
import org.dromara.warm.flow.core.dto.FlowParams;
import org.dromara.warm.flow.core.entity.Task;
import org.dromara.warm.flow.core.exception.FlowException;
import org.dromara.warm.flow.core.handler.PermissionHandler;
import org.dromara.warm.flow.core.listener.ListenerStrategy;
import org.dromara.warm.flow.core.strategy.ExpressionStrategy;
import org.dromara.warm.flow.core.utils.ArrayUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.MapUtil;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.dromara.warm.flow.core.variable.DefaultVariableStrategy;
import org.dromara.warm.flow.core.variable.VariableStrategy;

public class ExpressionUtil {
    public static <T> void setExpression(ExpressionStrategy<T> expressionStrategy) {
        expressionStrategy.setExpression(expressionStrategy);
    }

    public static boolean evalCondition(String expression, Map<String, Object> variable) {
        return Boolean.TRUE.equals(ExpressionUtil.getValue(ConditionStrategy.EXPRESSION_STRATEGY_LIST, expression, variable, "\u6761\u4ef6\u8868\u8fbe\u5f0f\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a!"));
    }

    public static void evalVariable(List<Task> addTasks, FlowParams flowParams) {
        if (CollUtil.isEmpty(addTasks)) {
            return;
        }
        Map<String, Object> variable = flowParams.getVariable();
        addTasks.forEach(addTask -> {
            List<String> permissions = addTask.getPermissionList().stream().map(s -> {
                List<String> result = ExpressionUtil.evalVariable(s, variable);
                if (CollUtil.isNotEmpty(result)) {
                    return result;
                }
                return Collections.singletonList(s);
            }).filter(Objects::nonNull).flatMap(Collection::stream).distinct().collect(Collectors.toList());
            PermissionHandler permissionHandler = FlowEngine.permissionHandler();
            if (permissionHandler != null) {
                permissions = permissionHandler.convertPermissions(permissions);
            }
            permissions = ExpressionUtil.nextHandle(flowParams.isNextHandlerAppend(), flowParams.getNextHandler(), permissions);
            addTask.setPermissionList(permissions);
        });
    }

    public static List<String> nextHandle(boolean nextHandlerAppend, String[] nextHandler, List<String> permissions) {
        if (ArrayUtil.isEmpty(nextHandler)) {
            return permissions;
        }
        if (nextHandlerAppend) {
            permissions.addAll(new ArrayList<String>(Arrays.asList(nextHandler)));
        } else {
            permissions = new ArrayList<String>(Arrays.asList(nextHandler));
        }
        return permissions;
    }

    public static List<String> evalVariable(String expression, Map<String, Object> variable) {
        return (List)ExpressionUtil.getValue(VariableStrategy.EXPRESSION_STRATEGY_LIST, expression, variable, "\u529e\u7406\u4eba\u8868\u8fbe\u5f0f\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a!");
    }

    public static boolean evalListener(String expression, Map<String, Object> variable) {
        return Boolean.TRUE.equals(ExpressionUtil.getValue(ListenerStrategy.EXPRESSION_STRATEGY_LIST, expression, variable, "\u529e\u7406\u4eba\u8868\u8fbe\u5f0f\u7b56\u7565\u4e0d\u80fd\u4e3a\u7a7a!"));
    }

    private static <T> T getValue(List<ExpressionStrategy<T>> strategyList, String expression, Map<String, Object> variable, String errMsg) {
        if (StringUtils.isNotEmpty(expression)) {
            for (int i = strategyList.size() - 1; i >= 0; --i) {
                ExpressionStrategy<T> strategy = strategyList.get(i);
                if (strategy == null) {
                    throw new FlowException(errMsg);
                }
                if (!expression.startsWith(strategy.getType())) continue;
                if (StringUtils.isNotEmpty(strategy.interceptStr())) {
                    expression = expression.replace(strategy.getType() + strategy.interceptStr(), "");
                }
                return strategy.eval(expression, MapUtil.isEmpty(variable) ? new HashMap() : variable);
            }
        }
        return null;
    }

    static {
        ExpressionUtil.setExpression(new ConditionStrategyEq());
        ExpressionUtil.setExpression(new ConditionStrategyGe());
        ExpressionUtil.setExpression(new ConditionStrategyGt());
        ExpressionUtil.setExpression(new ConditionStrategyLe());
        ExpressionUtil.setExpression(new ConditionStrategyLike());
        ExpressionUtil.setExpression(new ConditionStrategyLt());
        ExpressionUtil.setExpression(new ConditionStrategyNe());
        ExpressionUtil.setExpression(new ConditionStrategyNotLike());
        ExpressionUtil.setExpression(new DefaultVariableStrategy());
    }
}

