/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.config;

import java.io.Serializable;
import java.util.List;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.enums.ChartStatus;
import org.dromara.warm.flow.core.json.JsonConvert;
import org.dromara.warm.flow.core.utils.ServiceLoaderUtil;

public class WarmFlow
implements Serializable {
    private boolean enabled = true;
    private boolean banner = true;
    private String keyType;
    private boolean logicDelete = false;
    private String logicDeleteValue = "2";
    private String logicNotDeleteValue = "0";
    private String dataFillHandlerPath;
    private String tenantHandlerPath;
    private String dataSourceType;
    private boolean ui = true;
    private String tokenName = "Authorization";
    private List<String> chartStatusColor;
    private List<String> chartStatusColorClassics;
    private List<String> chartStatusColorMimic;
    private boolean topTextShow = true;

    public void init() {
        FlowEngine.initTenantHandler(this.getTenantHandlerPath());
        FlowEngine.initDataFillHandler(this.getDataFillHandlerPath());
        FlowEngine.initPermissionHandler();
        FlowEngine.initGlobalListener();
        this.printBanner();
        ChartStatus.initCustomColor(this.getChartStatusColor(), this.getChartStatusColorClassics(), this.getChartStatusColorMimic());
        this.spiLoad();
    }

    public void spiLoad() {
        FlowEngine.jsonConvert = ServiceLoaderUtil.loadFirst(JsonConvert.class);
    }

    private void printBanner() {
        if (this.isBanner()) {
            System.out.println("\n   \u2584     \u2584                             \u2584\u2584\u2584\u2584\u2584\u2584   \u2584                     \n   \u2588  \u2588  \u2588  \u2584\u2584\u2584    \u2584 \u2584\u2584  \u2584\u2584\u2584\u2584\u2584         \u2588        \u2588     \u2584\u2584\u2584  \u2584     \u2584    \n   \u2580 \u2588\u2580\u2588 \u2588 \u2580   \u2588   \u2588\u2580  \u2580 \u2588 \u2588 \u2588  \u2584\u2584\u2584\u2584\u2584  \u2588\u2584\u2584\u2584\u2584\u2584   \u2588    \u2588\u2580 \u2580\u2588 \u2580\u2584 \u2584 \u2584\u2580    \n    \u2588\u2588 \u2588\u2588\u2580 \u2584\u2580\u2580\u2580\u2588   \u2588     \u2588 \u2588 \u2588         \u2588        \u2588    \u2588   \u2588  \u2588\u2584\u2588\u2584\u2588     \n    \u2588   \u2588  \u2580\u2584\u2584\u2580\u2588   \u2588     \u2588 \u2588 \u2588         \u2588        \u2588\u2584\u2584  \u2580\u2588\u2584\u2588\u2580   \u2588 \u2588      \n\n\u001b[32m   :: Warm-Flow ::     (v" + WarmFlow.class.getPackage().getImplementationVersion() + ")\u001b[0m\n");
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public boolean isBanner() {
        return this.banner;
    }

    public String getKeyType() {
        return this.keyType;
    }

    public boolean isLogicDelete() {
        return this.logicDelete;
    }

    public String getLogicDeleteValue() {
        return this.logicDeleteValue;
    }

    public String getLogicNotDeleteValue() {
        return this.logicNotDeleteValue;
    }

    public String getDataFillHandlerPath() {
        return this.dataFillHandlerPath;
    }

    public String getTenantHandlerPath() {
        return this.tenantHandlerPath;
    }

    public String getDataSourceType() {
        return this.dataSourceType;
    }

    public boolean isUi() {
        return this.ui;
    }

    public String getTokenName() {
        return this.tokenName;
    }

    public List<String> getChartStatusColor() {
        return this.chartStatusColor;
    }

    public List<String> getChartStatusColorClassics() {
        return this.chartStatusColorClassics;
    }

    public List<String> getChartStatusColorMimic() {
        return this.chartStatusColorMimic;
    }

    public boolean isTopTextShow() {
        return this.topTextShow;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setBanner(boolean banner) {
        this.banner = banner;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    public void setLogicDelete(boolean logicDelete) {
        this.logicDelete = logicDelete;
    }

    public void setLogicDeleteValue(String logicDeleteValue) {
        this.logicDeleteValue = logicDeleteValue;
    }

    public void setLogicNotDeleteValue(String logicNotDeleteValue) {
        this.logicNotDeleteValue = logicNotDeleteValue;
    }

    public void setDataFillHandlerPath(String dataFillHandlerPath) {
        this.dataFillHandlerPath = dataFillHandlerPath;
    }

    public void setTenantHandlerPath(String tenantHandlerPath) {
        this.tenantHandlerPath = tenantHandlerPath;
    }

    public void setDataSourceType(String dataSourceType) {
        this.dataSourceType = dataSourceType;
    }

    public void setUi(boolean ui) {
        this.ui = ui;
    }

    public void setTokenName(String tokenName) {
        this.tokenName = tokenName;
    }

    public void setChartStatusColor(List<String> chartStatusColor) {
        this.chartStatusColor = chartStatusColor;
    }

    public void setChartStatusColorClassics(List<String> chartStatusColorClassics) {
        this.chartStatusColorClassics = chartStatusColorClassics;
    }

    public void setChartStatusColorMimic(List<String> chartStatusColorMimic) {
        this.chartStatusColorMimic = chartStatusColorMimic;
    }

    public void setTopTextShow(boolean topTextShow) {
        this.topTextShow = topTextShow;
    }
}

