/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.enums;

import org.dromara.warm.flow.core.utils.ObjectUtil;

public enum FlowStatus {
    TOBESUBMIT("0", "\u5f85\u63d0\u4ea4"),
    APPROVAL("1", "\u5ba1\u6279\u4e2d"),
    PASS("2", "\u5ba1\u6279\u901a\u8fc7"),
    AUTO_PASS("3", "\u81ea\u52a8\u5b8c\u6210"),
    TERMINATE("4", "\u7ec8\u6b62"),
    NULLIFY("5", "\u4f5c\u5e9f"),
    CANCEL("6", "\u64a4\u9500"),
    RETRIEVE("7", "\u53d6\u56de"),
    FINISHED("8", "\u5df2\u5b8c\u6210"),
    REJECT("9", "\u5df2\u9000\u56de"),
    INVALID("10", "\u5931\u6548"),
    TASK_BACK("11", "\u62ff\u56de"),
    RE_START("12", "\u91cd\u542f");

    private final String key;
    private final String value;

    public static String getKeyByValue(String value) {
        for (FlowStatus item : FlowStatus.values()) {
            if (!item.getValue().equals(value)) continue;
            return item.getKey();
        }
        return null;
    }

    public static String getValueByKey(String key) {
        for (FlowStatus item : FlowStatus.values()) {
            if (!item.getKey().equals(key)) continue;
            return item.getValue();
        }
        return null;
    }

    public static FlowStatus getByKey(String key) {
        for (FlowStatus item : FlowStatus.values()) {
            if (!item.getKey().equals(key)) continue;
            return item;
        }
        return null;
    }

    public static Boolean isFinished(String key) {
        return ObjectUtil.isNotNull(key) && FINISHED.getKey().equals(key);
    }

    public String getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }

    private FlowStatus(String key, String value) {
        this.key = key;
        this.value = value;
    }
}

