/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.enums;

import org.dromara.warm.flow.core.utils.ObjectUtil;

public enum NodeType {
    START(0, "start"),
    BETWEEN(1, "between"),
    END(2, "end"),
    SERIAL(3, "serial"),
    PARALLEL(4, "parallel"),
    INCLUSIVE(5, "inclusive");

    private final Integer key;
    private final String value;

    public static Integer getKeyByValue(String value) {
        for (NodeType item : NodeType.values()) {
            if (!item.getValue().equals(value)) continue;
            return item.getKey();
        }
        return null;
    }

    public static String getValueByKey(Integer key) {
        for (NodeType item : NodeType.values()) {
            if (!item.getKey().equals(key)) continue;
            return item.getValue();
        }
        return null;
    }

    public static NodeType getByKey(Integer key) {
        for (NodeType item : NodeType.values()) {
            if (!item.getKey().equals(key)) continue;
            return item;
        }
        return null;
    }

    public static Boolean isStart(Integer key) {
        return ObjectUtil.isNotNull(key) && START.getKey().equals(key);
    }

    public static Boolean isBetween(Integer key) {
        return ObjectUtil.isNotNull(key) && BETWEEN.getKey().equals(key);
    }

    public static Boolean isEnd(Integer key) {
        return ObjectUtil.isNotNull(key) && END.getKey().equals(key);
    }

    public static Boolean isGateWay(Integer key) {
        return ObjectUtil.isNotNull(key) && (SERIAL.getKey().equals(key) || PARALLEL.getKey().equals(key) || INCLUSIVE.getKey().equals(key));
    }

    public static Boolean isGateWaySerial(Integer key) {
        return ObjectUtil.isNotNull(key) && SERIAL.getKey().equals(key);
    }

    public static Boolean isGateWayParallel(Integer key) {
        return ObjectUtil.isNotNull(key) && PARALLEL.getKey().equals(key);
    }

    public static Boolean isGateWayInclusive(Integer key) {
        return ObjectUtil.isNotNull(key) && INCLUSIVE.getKey().equals(key);
    }

    private NodeType(Integer key, String value) {
        this.key = key;
        this.value = value;
    }

    public Integer getKey() {
        return this.key;
    }

    public String getValue() {
        return this.value;
    }
}

