/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.service.impl;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.dto.FlowParams;
import org.dromara.warm.flow.core.entity.HisTask;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Task;
import org.dromara.warm.flow.core.entity.User;
import org.dromara.warm.flow.core.enums.CooperateType;
import org.dromara.warm.flow.core.enums.FlowStatus;
import org.dromara.warm.flow.core.enums.SkipType;
import org.dromara.warm.flow.core.orm.dao.FlowHisTaskDao;
import org.dromara.warm.flow.core.orm.service.impl.WarmServiceImpl;
import org.dromara.warm.flow.core.service.HisTaskService;
import org.dromara.warm.flow.core.utils.ArrayUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.SqlHelper;
import org.dromara.warm.flow.core.utils.StreamUtils;
import org.dromara.warm.flow.core.utils.StringUtils;

public class HisTaskServiceImpl
extends WarmServiceImpl<FlowHisTaskDao<HisTask>, HisTask>
implements HisTaskService {
    public HisTaskService setDao(FlowHisTaskDao<HisTask> warmDao) {
        this.warmDao = warmDao;
        return this;
    }

    @Override
    public List<HisTask> listByTaskIdAndCooperateTypes(Long taskId, Integer ... cooperateTypes) {
        if (ArrayUtil.isEmpty(cooperateTypes)) {
            return this.list(FlowEngine.newHisTask().setTaskId(taskId));
        }
        if (cooperateTypes.length == 1) {
            return this.list(FlowEngine.newHisTask().setTaskId(taskId).setCooperateType(cooperateTypes[0]));
        }
        return ((FlowHisTaskDao)this.getDao()).listByTaskIdAndCooperateTypes(taskId, cooperateTypes);
    }

    @Override
    public List<HisTask> getByInsAndNodeCodes(Long instanceId, List<String> nodeCodes) {
        return ((FlowHisTaskDao)this.getDao()).getByInsAndNodeCodes(instanceId, nodeCodes);
    }

    @Override
    public boolean deleteByInsIds(List<Long> instanceIds) {
        return SqlHelper.retBool(((FlowHisTaskDao)this.getDao()).deleteByInsIds(instanceIds));
    }

    @Override
    public HisTask setSkipInsHis(Task task, List<Node> nextNodes, FlowParams flowParams) {
        String flowStatus = this.getFlowStatus(flowParams);
        return this.setSkipHis(task, nextNodes, flowParams, flowStatus);
    }

    @Override
    public List<HisTask> setSkipHisList(List<Task> taskList, List<Node> nextNodes, FlowParams flowParams) {
        String flowStatus = this.getFlowStatus(flowParams);
        ArrayList<HisTask> hisTasks = new ArrayList<HisTask>();
        for (Task task : taskList) {
            HisTask hisTask = this.setSkipHis(task, nextNodes, flowParams, flowStatus);
            hisTasks.add(hisTask);
        }
        return hisTasks;
    }

    @Override
    public HisTask setSkipHisTask(Task task, Node nextNode, FlowParams flowParams) {
        String flowStatus = this.getFlowStatus(flowParams);
        return this.setSkipHis(task, CollUtil.toList(nextNode), flowParams, flowStatus);
    }

    @Override
    public HisTask setCooperateHis(Task task, Node node, FlowParams flowParams, List<String> collaborators) {
        String flowStatus = this.getFlowStatus(flowParams);
        HisTask hisTask = FlowEngine.newHisTask().setTaskId(task.getId()).setInstanceId(task.getInstanceId()).setCooperateType(ObjectUtil.isNotNull(flowParams.getCooperateType()) ? flowParams.getCooperateType() : CooperateType.APPROVAL.getKey()).setCollaborator(StreamUtils.join(collaborators, c -> c)).setNodeCode(task.getNodeCode()).setNodeName(task.getNodeName()).setNodeType(task.getNodeType()).setDefinitionId(task.getDefinitionId()).setTargetNodeCode(node.getNodeCode()).setTargetNodeName(node.getNodeName()).setApprover(flowParams.getHandler()).setSkipType(flowParams.getSkipType()).setFlowStatus(StringUtils.isNotEmpty(flowStatus) ? flowStatus : FlowStatus.APPROVAL.getKey()).setFormCustom(task.getFormCustom()).setFormPath(task.getFormPath()).setMessage(flowParams.getMessage()).setVariable(flowParams.getVariableStr()).setExt(flowParams.getHisTaskExt()).setCreateTime(task.getCreateTime());
        FlowEngine.dataFillHandler().idFill(hisTask);
        return hisTask;
    }

    @Override
    public HisTask setDeputeHisTask(Task task, FlowParams flowParams, User entrustedUser) {
        String flowStatus = this.getFlowStatus(flowParams);
        HisTask hisTask = FlowEngine.newHisTask().setTaskId(task.getId()).setInstanceId(task.getInstanceId()).setCooperateType(CooperateType.DEPUTE.getKey()).setNodeCode(task.getNodeCode()).setNodeName(task.getNodeName()).setNodeType(task.getNodeType()).setDefinitionId(task.getDefinitionId()).setTargetNodeCode(task.getNodeCode()).setTargetNodeName(task.getNodeName()).setApprover(flowParams.getHandler()).setCollaborator(entrustedUser.getCreateBy()).setSkipType(flowParams.getSkipType()).setFlowStatus(StringUtils.isNotEmpty(flowStatus) ? flowStatus : (SkipType.isReject(flowParams.getSkipType()) != false ? FlowStatus.REJECT.getKey() : FlowStatus.PASS.getKey())).setFormCustom(task.getFormCustom()).setFormPath(task.getFormPath()).setMessage(flowParams.getMessage()).setVariable(flowParams.getVariableStr()).setExt(flowParams.getHisTaskExt()).setCreateTime(task.getCreateTime());
        FlowEngine.dataFillHandler().idFill(hisTask);
        return hisTask;
    }

    @Override
    public HisTask setSignHisTask(Task task, FlowParams flowParams, BigDecimal nodeRatio, boolean isPass) {
        String flowStatus = this.getFlowStatus(flowParams);
        HisTask hisTask = FlowEngine.newHisTask().setTaskId(task.getId()).setInstanceId(task.getInstanceId()).setCooperateType(CooperateType.isCountersign(nodeRatio) ? CooperateType.COUNTERSIGN.getKey() : CooperateType.VOTE.getKey()).setNodeCode(task.getNodeCode()).setNodeName(task.getNodeName()).setNodeType(task.getNodeType()).setDefinitionId(task.getDefinitionId()).setApprover(flowParams.getHandler()).setMessage(flowParams.getMessage()).setSkipType(isPass ? SkipType.PASS.getKey() : SkipType.REJECT.getKey()).setFlowStatus(StringUtils.isNotEmpty(flowStatus) ? flowStatus : (isPass ? FlowStatus.PASS.getKey() : FlowStatus.REJECT.getKey())).setFormCustom(task.getFormCustom()).setFormPath(task.getFormPath()).setMessage(flowParams.getMessage()).setVariable(flowParams.getVariableStr()).setExt(flowParams.getHisTaskExt()).setCreateTime(task.getCreateTime());
        FlowEngine.dataFillHandler().idFill(hisTask);
        return hisTask;
    }

    @Override
    public List<HisTask> getByInsId(Long instanceId) {
        return FlowEngine.hisTaskService().list(FlowEngine.newHisTask().setInstanceId(instanceId));
    }

    private HisTask setSkipHis(Task task, List<Node> nextNodes, FlowParams flowParams, String flowStatus) {
        HisTask hisTask = FlowEngine.newHisTask().setTaskId(task.getId()).setInstanceId(task.getInstanceId()).setCooperateType(ObjectUtil.isNotNull(flowParams.getCooperateType()) ? flowParams.getCooperateType() : CooperateType.APPROVAL.getKey()).setNodeCode(task.getNodeCode()).setNodeName(task.getNodeName()).setNodeType(task.getNodeType()).setDefinitionId(task.getDefinitionId()).setTargetNodeCode(StreamUtils.join(nextNodes, Node::getNodeCode)).setTargetNodeName(StreamUtils.join(nextNodes, Node::getNodeName)).setApprover(flowParams.getHandler()).setSkipType(flowParams.getSkipType()).setFlowStatus(StringUtils.isNotEmpty(flowStatus) ? flowStatus : (SkipType.isReject(flowParams.getSkipType()) != false ? FlowStatus.REJECT.getKey() : FlowStatus.PASS.getKey())).setFormCustom(task.getFormCustom()).setFormPath(task.getFormPath()).setMessage(flowParams.getMessage()).setVariable(flowParams.getVariableStr()).setExt(flowParams.getHisTaskExt()).setCreateTime(task.getCreateTime());
        FlowEngine.dataFillHandler().idFill(hisTask);
        return hisTask;
    }

    private String getFlowStatus(FlowParams flowParams) {
        return StringUtils.emptyDefault(flowParams.getHisStatus(), flowParams.getFlowStatus());
    }
}

