/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.constant.FlowCons;
import org.dromara.warm.flow.core.entity.Definition;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Task;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.invoker.FrameInvoker;
import org.dromara.warm.flow.core.listener.GlobalListener;
import org.dromara.warm.flow.core.listener.Listener;
import org.dromara.warm.flow.core.listener.ListenerVariable;
import org.dromara.warm.flow.core.listener.ValueHolder;
import org.dromara.warm.flow.core.utils.ClassUtil;
import org.dromara.warm.flow.core.utils.ExpressionUtil;
import org.dromara.warm.flow.core.utils.MapUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StreamUtils;
import org.dromara.warm.flow.core.utils.StringUtils;

public class ListenerUtil {
    private ListenerUtil() {
    }

    public static void endCreateListener(ListenerVariable listenerVariable) {
        ListenerUtil.executeListener(listenerVariable, "finish");
        List<Task> tasks = listenerVariable.getNextTasks();
        listenerVariable.getNextNodes().forEach(node -> {
            if (!NodeType.isEnd(node.getNodeType()).booleanValue()) {
                Task nextTask = StreamUtils.filterOne(tasks, task -> task.getNodeCode().equals(node.getNodeCode()));
                listenerVariable.setNode((Node)node).setNextNodes(null).setTask(nextTask).setNextTasks(null);
                ListenerUtil.executeListener(listenerVariable, "create");
            }
        });
    }

    public static void executeListener(ListenerVariable listenerVariable, String type) {
        String listenerType = listenerVariable.getNode().getListenerType();
        ListenerUtil.execute(listenerVariable, type, listenerVariable.getNode().getListenerPath(), listenerType);
        Definition definition = listenerVariable.getDefinition();
        ListenerUtil.execute(listenerVariable, type, definition.getListenerPath(), definition.getListenerType());
        GlobalListener globalListener = FlowEngine.globalListener();
        if (ObjectUtil.isNotNull(globalListener)) {
            globalListener.notify(type, listenerVariable);
        }
    }

    public static void execute(ListenerVariable listenerVariable, String type, String listenerPaths, String listenerTypes) {
        if (StringUtils.isNotEmpty(listenerTypes)) {
            String[] listenerTypeArr = listenerTypes.split(",");
            for (int i = 0; i < listenerTypeArr.length; ++i) {
                Listener listener;
                String listenerType = listenerTypeArr[i].trim();
                if (!listenerType.equals(type) || !StringUtils.isNotEmpty(listenerPaths)) continue;
                String[] listenerPathArr = listenerPaths.split("@@");
                String listenerPath = listenerPathArr[i].trim();
                ValueHolder valueHolder = new ValueHolder();
                ListenerUtil.getListenerPath(listenerPath, valueHolder);
                Map<String, Object> expressionMap = MapUtil.newAndPut("listenerVariable", listenerVariable);
                if (ExpressionUtil.evalListener(listenerPath, expressionMap)) {
                    return;
                }
                Class<?> clazz = ClassUtil.getClazz(valueHolder.getPath());
                if (!ObjectUtil.isNotNull(clazz) || !Listener.class.isAssignableFrom(clazz) || !ObjectUtil.isNotNull(listener = (Listener)FrameInvoker.getBean(clazz))) continue;
                Map<String, Object> variable = listenerVariable.getVariable();
                if (MapUtil.isEmpty(variable)) {
                    variable = new HashMap<String, Object>();
                } else {
                    variable.remove("WarmListenerParam");
                }
                if (StringUtils.isNotEmpty(valueHolder.getParams())) {
                    variable.put("WarmListenerParam", valueHolder.getParams());
                }
                listener.notify(listenerVariable.setVariable(variable));
            }
        }
    }

    public static void getListenerPath(String listenerStr, ValueHolder valueHolder) {
        Matcher matcher = FlowCons.LISTENER_PATTERN.matcher(listenerStr);
        if (matcher.find()) {
            String path = matcher.group(1).replaceAll("[\\(\\)]", "");
            String params = matcher.group(2).replaceAll("[\\(\\)]", "");
            valueHolder.setPath(path);
            valueHolder.setParams(params);
        }
    }
}

