/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import java.util.HashMap;
import java.util.Map;
import org.dromara.warm.flow.core.utils.ArrayUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;

public class MapUtil {
    public static boolean isEmpty(Map<?, ?> map) {
        return ObjectUtil.isNull(map) || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !MapUtil.isEmpty(map);
    }

    public static <K, V> Map<K, V> emptyDefault(Map<K, V> map, Map<K, V> defaultMap) {
        return MapUtil.isEmpty(map) ? defaultMap : map;
    }

    @SafeVarargs
    public static <K, V> Map<K, V> mergeAll(Map<K, V> ... maps) {
        HashMap<K, V> map = new HashMap<K, V>();
        for (Map<K, V> m : maps) {
            if (!MapUtil.isNotEmpty(m)) continue;
            map.putAll(m);
        }
        return map;
    }

    public static <K, V> Map<K, V> mergeAll(Object ... values) {
        HashMap<Object, Object> map = new HashMap<Object, Object>();
        if (ArrayUtil.isNotEmpty(values)) {
            for (int i = 0; i < values.length - 1; i += 2) {
                Object key = values[i];
                Object value = values[i + 1];
                map.put(key, value);
            }
        }
        return map;
    }

    public static <K, V> Map<K, V> newAndPut(K k, V v) {
        HashMap<K, V> map = new HashMap<K, V>();
        map.put(k, v);
        return map;
    }
}

