/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import org.dromara.warm.flow.core.utils.ArrayUtil;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;

public class StringUtils {
    private static final String NULLSTR = "";
    private static final char SEPARATOR = '_';

    public static <T> T nvl(T value, T defaultValue) {
        return value != null ? value : defaultValue;
    }

    public static boolean isEmpty(String str) {
        return ObjectUtil.isNull(str) || NULLSTR.equals(str.trim());
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static String emptyDefault(String str, String defaultStr) {
        return StringUtils.isEmpty(str) ? defaultStr : str;
    }

    public static boolean hasEmpty(String ... strs) {
        if (ArrayUtil.isEmpty(strs)) {
            return true;
        }
        for (String str : strs) {
            if (!StringUtils.isEmpty(str)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAllNotEmpty(String ... args) {
        return false == StringUtils.hasEmpty(args);
    }

    public static String trim(String str) {
        return str == null ? NULLSTR : str.trim();
    }

    public static boolean containsAny(Collection<String> collection, String ... array) {
        if (CollUtil.isEmpty(collection) || ArrayUtil.isEmpty(array)) {
            return false;
        }
        for (String str : array) {
            if (!collection.contains(str)) continue;
            return true;
        }
        return false;
    }

    public static String substring(String str, int start) {
        if (str == null) {
            return NULLSTR;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (start < 0) {
            start = 0;
        }
        if (start > str.length()) {
            return NULLSTR;
        }
        return str.substring(start);
    }

    public static String substring(String str, int start, int end) {
        if (str == null) {
            return NULLSTR;
        }
        if (end < 0) {
            end = str.length() + end;
        }
        if (start < 0) {
            start = str.length() + start;
        }
        if (end > str.length()) {
            end = str.length();
        }
        if (start > end) {
            return NULLSTR;
        }
        if (start < 0) {
            start = 0;
        }
        if (end < 0) {
            end = 0;
        }
        return str.substring(start, end);
    }

    public static Set<String> str2Set(String str, String sep) {
        return new HashSet<String>(StringUtils.str2List(str, sep, true, false));
    }

    public static List<String> str2List(String str, String sep) {
        return StringUtils.str2List(str, sep, true, true);
    }

    public static List<String> str2List(String str, String sep, boolean filterBlank, boolean trim) {
        String[] split;
        ArrayList<String> list = new ArrayList<String>();
        if (StringUtils.isEmpty(str)) {
            return list;
        }
        if (filterBlank && StringUtils.isEmpty(str)) {
            return list;
        }
        for (String string : split = str.split(sep)) {
            if (filterBlank && StringUtils.isEmpty(string)) continue;
            if (trim) {
                string = string.trim();
            }
            list.add(string);
        }
        return list;
    }

    public static String toUnderScoreCase(String str) {
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean preCharIsUpperCase = true;
        boolean curreCharIsUpperCase = true;
        boolean nexteCharIsUpperCase = true;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            preCharIsUpperCase = i > 0 ? Character.isUpperCase(str.charAt(i - 1)) : false;
            curreCharIsUpperCase = Character.isUpperCase(c);
            if (i < str.length() - 1) {
                nexteCharIsUpperCase = Character.isUpperCase(str.charAt(i + 1));
            }
            if (preCharIsUpperCase && curreCharIsUpperCase && !nexteCharIsUpperCase) {
                sb.append('_');
            } else if (i != 0 && !preCharIsUpperCase && curreCharIsUpperCase) {
                sb.append('_');
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }

    public static boolean inStringIgnoreCase(String str, String ... strs) {
        if (str != null && strs != null) {
            for (String s : strs) {
                if (!str.equalsIgnoreCase(StringUtils.trim(s))) continue;
                return true;
            }
        }
        return false;
    }

    public static String convertToCamelCase(String name) {
        String[] camels;
        StringBuilder result = new StringBuilder();
        if (name == null || name.isEmpty()) {
            return NULLSTR;
        }
        if (!name.contains("_")) {
            return name.substring(0, 1).toUpperCase() + name.substring(1);
        }
        for (String camel : camels = name.split("_")) {
            if (camel.isEmpty()) continue;
            result.append(camel.substring(0, 1).toUpperCase());
            result.append(camel.substring(1).toLowerCase());
        }
        return result.toString();
    }

    public static String toCamelCase(String s) {
        if (s == null) {
            return null;
        }
        if (s.indexOf(95) == -1) {
            return s;
        }
        s = s.toLowerCase();
        StringBuilder sb = new StringBuilder(s.length());
        boolean upperCase = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '_') {
                upperCase = true;
                continue;
            }
            if (upperCase) {
                sb.append(Character.toUpperCase(c));
                upperCase = false;
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    public static final String padl(Number num, int size) {
        return StringUtils.padl(num.toString(), size, '0');
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final String padl(String s, int size, char c) {
        StringBuilder sb = new StringBuilder(size);
        if (s != null) {
            int len = s.length();
            if (s.length() > size) return s.substring(len - size, len);
            for (int i = size - len; i > 0; --i) {
                sb.append(c);
            }
            sb.append(s);
            return sb.toString();
        } else {
            for (int i = size; i > 0; --i) {
                sb.append(c);
            }
        }
        return sb.toString();
    }

    @SafeVarargs
    public static <T> String join(T ... elements) {
        return StringUtils.join((Object[])elements, null);
    }

    public static String join(Object[] array, String delimiter) {
        return array == null ? null : StringUtils.join(array, delimiter, 0, array.length);
    }

    public static String join(Object[] array, String delimiter, int startIndex, int endIndex) {
        if (array == null) {
            return null;
        }
        if (endIndex - startIndex <= 0) {
            return NULLSTR;
        }
        StringJoiner joiner = new StringJoiner(StringUtils.toStringOrEmpty(delimiter));
        for (int i = startIndex; i < endIndex; ++i) {
            joiner.add(StringUtils.toStringOrEmpty(array[i]));
        }
        return joiner.toString();
    }

    private static String toStringOrEmpty(Object obj) {
        return Objects.toString(obj, NULLSTR);
    }
}

