/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.core.variable;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dromara.warm.flow.core.strategy.ExpressionStrategy;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StreamUtils;

public interface VariableStrategy
extends ExpressionStrategy<List<String>> {
    public static final List<ExpressionStrategy<List<String>>> EXPRESSION_STRATEGY_LIST = new ArrayList<ExpressionStrategy<List<String>>>();

    @Override
    default public void setExpression(ExpressionStrategy<List<String>> expressionStrategy) {
        EXPRESSION_STRATEGY_LIST.add(expressionStrategy);
    }

    public Object preEval(String var1, Map<String, Object> var2);

    @Override
    default public List<String> eval(String expression, Map<String, Object> variable) {
        return this.afterEval(this.preEval(expression, variable));
    }

    default public List<String> afterEval(Object o) {
        if (ObjectUtil.isNull(o)) {
            return null;
        }
        if (o instanceof List) {
            return StreamUtils.toList((List)o, Object::toString);
        }
        if (o instanceof Object[]) {
            return Arrays.stream((Object[])o).map(Object::toString).collect(Collectors.toList());
        }
        return Collections.singletonList(o.toString());
    }
}

