/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.ui.service;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.config.WarmFlow;
import org.dromara.warm.flow.core.dto.ApiResult;
import org.dromara.warm.flow.core.dto.DefJson;
import org.dromara.warm.flow.core.dto.FlowDto;
import org.dromara.warm.flow.core.dto.FlowParams;
import org.dromara.warm.flow.core.dto.Tree;
import org.dromara.warm.flow.core.entity.Form;
import org.dromara.warm.flow.core.entity.Instance;
import org.dromara.warm.flow.core.enums.FormCustomEnum;
import org.dromara.warm.flow.core.enums.ModelEnum;
import org.dromara.warm.flow.core.exception.FlowException;
import org.dromara.warm.flow.core.invoker.FrameInvoker;
import org.dromara.warm.flow.core.utils.ExceptionUtil;
import org.dromara.warm.flow.core.utils.StreamUtils;
import org.dromara.warm.flow.core.utils.StringUtils;
import org.dromara.warm.flow.ui.dto.HandlerFeedBackDto;
import org.dromara.warm.flow.ui.dto.HandlerQuery;
import org.dromara.warm.flow.ui.service.CategoryService;
import org.dromara.warm.flow.ui.service.ChartExtService;
import org.dromara.warm.flow.ui.service.HandlerDictService;
import org.dromara.warm.flow.ui.service.HandlerSelectService;
import org.dromara.warm.flow.ui.service.NodeExtService;
import org.dromara.warm.flow.ui.utils.TreeUtil;
import org.dromara.warm.flow.ui.vo.Dict;
import org.dromara.warm.flow.ui.vo.HandlerFeedBackVo;
import org.dromara.warm.flow.ui.vo.HandlerSelectVo;
import org.dromara.warm.flow.ui.vo.NodeExt;
import org.dromara.warm.flow.ui.vo.WarmFlowVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WarmFlowService {
    private static final Logger log = LoggerFactory.getLogger(WarmFlowService.class);

    public static ApiResult<WarmFlowVo> config() {
        WarmFlowVo warmFlowVo = new WarmFlowVo();
        WarmFlow warmFlow = FlowEngine.getFlowConfig();
        String tokenName = warmFlow.getTokenName();
        if (StringUtils.isEmpty((String)tokenName)) {
            return ApiResult.fail((String)"\u672a\u914d\u7f6etokenName");
        }
        String[] tokenNames = tokenName.split(",");
        List<String> tokenNameList = Arrays.stream(tokenNames).filter(StringUtils::isNotEmpty).map(String::trim).collect(Collectors.toList());
        warmFlowVo.setTokenNameList(tokenNameList);
        return ApiResult.ok((Object)warmFlowVo);
    }

    public static ApiResult<Void> saveJson(DefJson defJson, boolean onlyNodeSkip) throws Exception {
        FlowEngine.defService().saveDef(defJson, onlyNodeSkip);
        return ApiResult.ok();
    }

    public static ApiResult<DefJson> queryDef(Long id) {
        try {
            DefJson defJson = id == null ? new DefJson().setModelValue(ModelEnum.CLASSICS.name()).setFormCustom(FormCustomEnum.N.name()) : FlowEngine.defService().queryDesign(id);
            CategoryService categoryService = (CategoryService)FrameInvoker.getBean(CategoryService.class);
            if (categoryService != null) {
                List<Tree> treeList = categoryService.queryCategory();
                defJson.setCategoryList(TreeUtil.buildTree(treeList));
            }
            return ApiResult.ok((Object)defJson);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6d41\u7a0bjson\u5b57\u7b26\u4e32", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u83b7\u53d6\u6d41\u7a0bjson\u5b57\u7b26\u4e32\u5931\u8d25", (Exception)e));
        }
    }

    public static ApiResult<DefJson> queryFlowChart(Long id) {
        try {
            Instance instance = (Instance)FlowEngine.insService().getById((Serializable)id);
            String defJsonStr = instance.getDefJson();
            DefJson defJson = (DefJson)FlowEngine.jsonConvert.strToBean(defJsonStr, DefJson.class);
            defJson.setInstance(instance);
            defJson.setChartStatusColor(FlowEngine.chartService().getChartRgb(defJson.getModelValue()));
            defJson.setTopTextShow(FlowEngine.getFlowConfig().isTopTextShow());
            ChartExtService chartExtService = (ChartExtService)FrameInvoker.getBean(ChartExtService.class);
            if (chartExtService != null) {
                chartExtService.initPromptContent(defJson);
                chartExtService.execute(defJson);
            }
            return ApiResult.ok((Object)defJson);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u6d41\u7a0b\u56fe", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u83b7\u53d6\u6d41\u7a0b\u56fe\u5931\u8d25", (Exception)e));
        }
    }

    public static ApiResult<List<String>> handlerType() {
        try {
            HandlerSelectService handlerSelectService = (HandlerSelectService)FrameInvoker.getBean(HandlerSelectService.class);
            if (handlerSelectService == null) {
                return ApiResult.ok(Collections.emptyList());
            }
            List<String> handlerType = handlerSelectService.getHandlerType();
            return ApiResult.ok(handlerType);
        }
        catch (Exception e) {
            log.error("\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868tabs\u9875\u7b7e\u5f02\u5e38", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868tabs\u9875\u7b7e\u5931\u8d25", (Exception)e));
        }
    }

    public static ApiResult<HandlerSelectVo> handlerResult(HandlerQuery query) {
        try {
            HandlerSelectService handlerSelectService = (HandlerSelectService)FrameInvoker.getBean(HandlerSelectService.class);
            if (handlerSelectService == null) {
                return ApiResult.ok((Object)new HandlerSelectVo());
            }
            HandlerSelectVo handlerSelectVo = handlerSelectService.getHandlerSelect(query);
            return ApiResult.ok((Object)handlerSelectVo);
        }
        catch (Exception e) {
            log.error("\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868\u7ed3\u679c\u5931\u8d25", (Exception)e));
        }
    }

    public static ApiResult<List<HandlerFeedBackVo>> handlerFeedback(HandlerFeedBackDto handlerFeedBackDto) {
        try {
            HandlerSelectService handlerSelectService = (HandlerSelectService)FrameInvoker.getBean(HandlerSelectService.class);
            if (handlerSelectService == null) {
                List handlerFeedBackVos = StreamUtils.toList(handlerFeedBackDto.getStorageIds(), storageId -> new HandlerFeedBackVo((String)storageId, null));
                return ApiResult.ok((Object)handlerFeedBackVos);
            }
            List<HandlerFeedBackVo> handlerFeedBackVos = handlerSelectService.handlerFeedback(handlerFeedBackDto.getStorageIds());
            return ApiResult.ok(handlerFeedBackVos);
        }
        catch (Exception e) {
            log.error("\u529e\u7406\u4eba\u6743\u9650\u540d\u79f0\u56de\u663e", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u529e\u7406\u4eba\u6743\u9650\u540d\u79f0\u56de\u663e", (Exception)e));
        }
    }

    public static ApiResult<List<Dict>> handlerDict() {
        try {
            HandlerDictService handlerDictService = (HandlerDictService)FrameInvoker.getBean(HandlerDictService.class);
            if (handlerDictService == null) {
                ArrayList<Dict> dictList = new ArrayList<Dict>();
                Dict dict = new Dict();
                dict.setLabel("\u9ed8\u8ba4\u8868\u8fbe\u5f0f");
                dict.setValue("${handler}");
                Dict dict1 = new Dict();
                dict1.setLabel("spel\u8868\u8fbe\u5f0f");
                dict1.setValue("#{@user.evalVar(#handler)}");
                Dict dict2 = new Dict();
                dict2.setLabel("\u5176\u4ed6");
                dict2.setValue("");
                dictList.add(dict);
                dictList.add(dict1);
                dictList.add(dict2);
                return ApiResult.ok(dictList);
            }
            return ApiResult.ok(handlerDictService.getHandlerDict());
        }
        catch (Exception e) {
            log.error("\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868\u7ed3\u679c\u5f02\u5e38", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u529e\u7406\u4eba\u6743\u9650\u8bbe\u7f6e\u5217\u8868\u7ed3\u679c\u5931\u8d25", (Exception)e));
        }
    }

    public static ApiResult<List<Form>> publishedForm() {
        try {
            return ApiResult.ok((Object)FlowEngine.formService().list((Object)FlowEngine.newForm().setIsPublish(Integer.valueOf(1))));
        }
        catch (Exception e) {
            log.error("\u5df2\u53d1\u5e03\u8868\u5355\u5217\u8868\u5f02\u5e38", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u5df2\u53d1\u5e03\u8868\u5355\u5217\u8868\u5f02\u5e38", (Exception)e));
        }
    }

    public static ApiResult<String> getFormContent(Long id) {
        try {
            return ApiResult.ok((Object)FlowEngine.formService().getById(id).getFormContent());
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8868\u5355\u5185\u5bb9\u5b57\u7b26\u4e32", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u83b7\u53d6\u8868\u5355\u5185\u5bb9\u5b57\u7b26\u4e32\u5931\u8d25", (Exception)e));
        }
    }

    public static ApiResult<Void> saveFormContent(FlowDto flowDto) {
        FlowEngine.formService().saveContent(flowDto.getId(), flowDto.getFormContent());
        return ApiResult.ok();
    }

    public static ApiResult<FlowDto> load(Long taskId) {
        FlowParams flowParams = FlowParams.build();
        return ApiResult.ok((Object)FlowEngine.taskService().load(taskId, flowParams));
    }

    public static ApiResult<FlowDto> hisLoad(Long hisTaskId) {
        FlowParams flowParams = FlowParams.build();
        return ApiResult.ok((Object)FlowEngine.taskService().hisLoad(hisTaskId, flowParams));
    }

    public static ApiResult<Instance> handle(Map<String, Object> formData, Long taskId, String skipType, String message, String nodeCode) {
        FlowParams flowParams = FlowParams.build().skipType(skipType).nodeCode(nodeCode).message(message);
        flowParams.formData(formData);
        return ApiResult.ok((Object)FlowEngine.taskService().skip(taskId, flowParams));
    }

    public static ApiResult<List<NodeExt>> nodeExt() {
        try {
            NodeExtService nodeExtService = (NodeExtService)FrameInvoker.getBean(NodeExtService.class);
            if (nodeExtService == null) {
                return ApiResult.ok(Collections.emptyList());
            }
            List<NodeExt> nodeExts = nodeExtService.getNodeExt();
            return ApiResult.ok(nodeExts);
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u8282\u70b9\u6269\u5c55\u5c5e\u6027", (Throwable)e);
            throw new FlowException(ExceptionUtil.handleMsg((String)"\u83b7\u53d6\u8282\u70b9\u6269\u5c55\u5c5e\u6027\u5931\u8d25", (Exception)e));
        }
    }
}

