/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.ui.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.dromara.warm.flow.core.dto.FlowPage;
import org.dromara.warm.flow.core.dto.Tree;
import org.dromara.warm.flow.core.utils.CollUtil;
import org.dromara.warm.flow.core.utils.MapUtil;
import org.dromara.warm.flow.core.utils.ObjectUtil;
import org.dromara.warm.flow.core.utils.StreamUtils;
import org.dromara.warm.flow.ui.dto.HandlerFunDto;
import org.dromara.warm.flow.ui.dto.HandlerQuery;
import org.dromara.warm.flow.ui.dto.TreeFunDto;
import org.dromara.warm.flow.ui.utils.TreeUtil;
import org.dromara.warm.flow.ui.vo.HandlerAuth;
import org.dromara.warm.flow.ui.vo.HandlerFeedBackVo;
import org.dromara.warm.flow.ui.vo.HandlerSelectVo;

public interface HandlerSelectService {
    public List<String> getHandlerType();

    public HandlerSelectVo getHandlerSelect(HandlerQuery var1);

    default public List<HandlerFeedBackVo> handlerFeedback(List<String> storageIds) {
        ArrayList<HandlerFeedBackVo> handlerFeedBackVos = new ArrayList<HandlerFeedBackVo>();
        if (CollUtil.isEmpty(storageIds)) {
            return handlerFeedBackVos;
        }
        HashMap authMap = new HashMap();
        List<String> handlerTypes = this.getHandlerType();
        if (CollUtil.isEmpty(handlerTypes)) {
            return handlerFeedBackVos;
        }
        for (String handlerType : handlerTypes) {
            FlowPage<HandlerAuth> handlerAuths;
            List rows;
            HandlerQuery handlerQuery = new HandlerQuery();
            handlerQuery.setHandlerType(handlerType);
            HandlerSelectVo handlerSelectVo = this.getHandlerSelect(handlerQuery);
            if (!ObjectUtil.isNotNull((Object)handlerSelectVo) || !CollUtil.isNotEmpty((Collection)(rows = (handlerAuths = handlerSelectVo.getHandlerAuths()).getRows()))) continue;
            authMap.putAll(StreamUtils.toMap((Collection)rows, HandlerAuth::getStorageId, HandlerAuth::getHandlerName));
        }
        for (String storageId : storageIds) {
            handlerFeedBackVos.add(new HandlerFeedBackVo(storageId, MapUtil.isEmpty(authMap) ? "" : (String)authMap.get(storageId)));
        }
        return handlerFeedBackVos;
    }

    default public <T> HandlerSelectVo getHandlerSelectVo(HandlerFunDto<T> handlerFunDto) {
        ArrayList<HandlerAuth> handlerAuths = new ArrayList<HandlerAuth>();
        for (T obj : handlerFunDto.getList()) {
            handlerAuths.add(new HandlerAuth().setStorageId(handlerFunDto.getStorageId() == null ? null : handlerFunDto.getStorageId().apply(obj)).setHandlerCode(handlerFunDto.getHandlerCode() == null ? null : handlerFunDto.getHandlerCode().apply(obj)).setHandlerName(handlerFunDto.getHandlerName() == null ? null : handlerFunDto.getHandlerName().apply(obj)).setCreateTime(handlerFunDto.getCreateTime() == null ? null : handlerFunDto.getCreateTime().apply(obj)).setGroupName(handlerFunDto.getGroupName() == null ? null : handlerFunDto.getGroupName().apply(obj)));
        }
        return this.getResult(handlerAuths, handlerFunDto.getTotal());
    }

    default public <T, R> HandlerSelectVo getHandlerSelectVo(HandlerFunDto<T> handlerFunDto, TreeFunDto<R> treeFunDto) {
        HandlerSelectVo handlerSelectVo = this.getHandlerSelectVo(handlerFunDto);
        List treeList = StreamUtils.toList(treeFunDto.getList(), org -> new Tree().setId(treeFunDto.getId() == null ? null : treeFunDto.getId().apply(org)).setName(treeFunDto.getName() == null ? null : treeFunDto.getName().apply(org)).setParentId(treeFunDto.getParentId() == null ? null : treeFunDto.getParentId().apply(org)));
        return handlerSelectVo.setTreeSelections(TreeUtil.buildTree(treeList));
    }

    default public HandlerSelectVo getResult(List<HandlerAuth> handlerAuths, long total) {
        return new HandlerSelectVo().setHandlerAuths((FlowPage<HandlerAuth>)new FlowPage().setCode(200).setMsg("\u67e5\u8be2\u6210\u529f").setRows(handlerAuths).setTotal(total));
    }
}

