/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.ui.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.dromara.warm.flow.core.dto.Tree;
import org.dromara.warm.flow.core.utils.StringUtils;

public class TreeUtil {
    private TreeUtil() {
    }

    public static List<Tree> buildTree(List<Tree> trees) {
        List<Tree> returnList = new ArrayList<Tree>();
        List tempList = trees.stream().map(Tree::getId).collect(Collectors.toList());
        for (Tree dept : trees) {
            if (tempList.contains(dept.getParentId())) continue;
            TreeUtil.recursionFn(trees, dept);
            returnList.add(dept);
        }
        if (returnList.isEmpty()) {
            returnList = trees;
        }
        return returnList;
    }

    private static void recursionFn(List<Tree> list, Tree t) {
        List<Tree> childList = TreeUtil.getChildList(list, t);
        t.setChildren(childList);
        for (Tree tChild : childList) {
            if (!TreeUtil.hasChild(list, tChild)) continue;
            TreeUtil.recursionFn(list, tChild);
        }
    }

    private static boolean hasChild(List<Tree> list, Tree t) {
        return !TreeUtil.getChildList(list, t).isEmpty();
    }

    private static List<Tree> getChildList(List<Tree> list, Tree t) {
        ArrayList<Tree> tlist = new ArrayList<Tree>();
        for (Tree n : list) {
            if (!StringUtils.isNotEmpty((String)n.getParentId()) || !n.getParentId().equals(t.getId())) continue;
            tlist.add(n);
        }
        return tlist;
    }
}

