/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.aspect;

import java.util.Iterator;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.aspect.CopyAspectChainCallback;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.recorder.FileRecorder;

public class CopyAspectChain {
    private CopyAspectChainCallback callback;
    private Iterator<FileStorageAspect> aspectIterator;

    public CopyAspectChain(Iterable<FileStorageAspect> aspects, CopyAspectChainCallback callback) {
        this.aspectIterator = aspects.iterator();
        this.callback = callback;
    }

    public FileInfo next(FileInfo srcFileInfo, CopyPretreatment pre, FileStorage fileStorage, FileRecorder fileRecorder) {
        if (this.aspectIterator.hasNext()) {
            return this.aspectIterator.next().copyAround(this, srcFileInfo, pre, fileStorage, fileRecorder);
        }
        return this.callback.run(srcFileInfo, pre, fileStorage, fileRecorder);
    }

    public CopyAspectChainCallback getCallback() {
        return this.callback;
    }

    public Iterator<FileStorageAspect> getAspectIterator() {
        return this.aspectIterator;
    }

    public void setCallback(CopyAspectChainCallback callback) {
        this.callback = callback;
    }

    public void setAspectIterator(Iterator<FileStorageAspect> aspectIterator) {
        this.aspectIterator = aspectIterator;
    }
}

