/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.copy;

import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.constant.Constant;
import org.dromara.x.file.storage.core.copy.CopyActuator;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.recorder.FileRecorder;

public class CopyPretreatment {
    private final FileStorageService fileStorageService;
    private final FileInfo fileInfo;
    private Constant.CopyMode copyMode = Constant.CopyMode.AUTO;
    private String platform;
    private String path;
    private String filename;
    private String thFilename;
    private ProgressListener progressListener;
    private Boolean notSupportMetadataThrowException = true;
    private Boolean notSupportAclThrowException = true;

    public CopyPretreatment(FileInfo fileInfo, FileStorageService fileStorageService) {
        this.fileStorageService = fileStorageService;
        this.fileInfo = fileInfo;
        this.platform = fileInfo.getPlatform();
        this.path = fileInfo.getPath();
        this.filename = fileInfo.getFilename();
        this.thFilename = fileInfo.getThFilename();
    }

    public CopyPretreatment setCopyMode(boolean flag, Constant.CopyMode copyMode) {
        if (flag) {
            this.copyMode = copyMode;
        }
        return this;
    }

    public CopyPretreatment setPlatform(boolean flag, String platform) {
        if (flag) {
            this.platform = platform;
        }
        return this;
    }

    public CopyPretreatment setPath(boolean flag, String path) {
        if (flag) {
            this.path = path;
        }
        return this;
    }

    public CopyPretreatment setFilename(boolean flag, String filename) {
        if (flag) {
            this.filename = filename;
        }
        return this;
    }

    public CopyPretreatment setThFilename(boolean flag, String thFilename) {
        if (flag) {
            this.thFilename = thFilename;
        }
        return this;
    }

    public CopyPretreatment setProgressListener(Consumer<Long> progressListener) {
        return this.setProgressListener((Long progressSize, Long allSize) -> progressListener.accept((Long)progressSize));
    }

    public CopyPretreatment setProgressListener(boolean flag, Consumer<Long> progressListener) {
        if (flag) {
            this.setProgressListener((Long progressSize, Long allSize) -> progressListener.accept((Long)progressSize));
        }
        return this;
    }

    public CopyPretreatment setProgressListener(final BiConsumer<Long, Long> progressListener) {
        return this.setProgressListener(new ProgressListener(){

            @Override
            public void start() {
            }

            @Override
            public void progress(long progressSize, Long allSize) {
                progressListener.accept(progressSize, allSize);
            }

            @Override
            public void finish() {
            }
        });
    }

    public CopyPretreatment setProgressListener(boolean flag, BiConsumer<Long, Long> progressListener) {
        if (flag) {
            this.setProgressListener(progressListener);
        }
        return this;
    }

    public CopyPretreatment setProgressListener(ProgressListener progressListener) {
        this.progressListener = progressListener;
        return this;
    }

    public CopyPretreatment setProgressListener(boolean flag, ProgressListener progressListener) {
        if (flag) {
            this.progressListener = progressListener;
        }
        return this;
    }

    public CopyPretreatment setNotSupportMetadataThrowException(boolean flag, Boolean notSupportMetadataThrowException) {
        if (flag) {
            this.notSupportMetadataThrowException = notSupportMetadataThrowException;
        }
        return this;
    }

    public CopyPretreatment setNotSupportAclThrowException(boolean flag, Boolean notSupportAclThrowException) {
        if (flag) {
            this.notSupportAclThrowException = notSupportAclThrowException;
        }
        return this;
    }

    public FileInfo copy() {
        return new CopyActuator(this).execute();
    }

    public FileInfo copy(FileStorage fileStorage, FileRecorder fileRecorder, List<FileStorageAspect> aspectList) {
        return new CopyActuator(this).execute(fileStorage, fileRecorder, aspectList);
    }

    public FileStorageService getFileStorageService() {
        return this.fileStorageService;
    }

    public FileInfo getFileInfo() {
        return this.fileInfo;
    }

    public Constant.CopyMode getCopyMode() {
        return this.copyMode;
    }

    public String getPlatform() {
        return this.platform;
    }

    public String getPath() {
        return this.path;
    }

    public String getFilename() {
        return this.filename;
    }

    public String getThFilename() {
        return this.thFilename;
    }

    public ProgressListener getProgressListener() {
        return this.progressListener;
    }

    public Boolean getNotSupportMetadataThrowException() {
        return this.notSupportMetadataThrowException;
    }

    public Boolean getNotSupportAclThrowException() {
        return this.notSupportAclThrowException;
    }

    public CopyPretreatment setCopyMode(Constant.CopyMode copyMode) {
        this.copyMode = copyMode;
        return this;
    }

    public CopyPretreatment setPlatform(String platform) {
        this.platform = platform;
        return this;
    }

    public CopyPretreatment setPath(String path) {
        this.path = path;
        return this;
    }

    public CopyPretreatment setFilename(String filename) {
        this.filename = filename;
        return this;
    }

    public CopyPretreatment setThFilename(String thFilename) {
        this.thFilename = thFilename;
        return this;
    }

    public CopyPretreatment setNotSupportMetadataThrowException(Boolean notSupportMetadataThrowException) {
        this.notSupportMetadataThrowException = notSupportMetadataThrowException;
        return this;
    }

    public CopyPretreatment setNotSupportAclThrowException(Boolean notSupportAclThrowException) {
        this.notSupportAclThrowException = notSupportAclThrowException;
        return this;
    }
}

