/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.file;

import java.io.File;
import java.io.IOException;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.file.FileWrapperAdapter;
import org.dromara.x.file.storage.core.file.LocalFileWrapper;
import org.dromara.x.file.storage.core.tika.ContentTypeDetect;

public class LocalFileWrapperAdapter
implements FileWrapperAdapter {
    private ContentTypeDetect contentTypeDetect;

    @Override
    public boolean isSupport(Object source) {
        return source instanceof File || source instanceof LocalFileWrapper;
    }

    @Override
    public FileWrapper getFileWrapper(Object source, String name, String contentType, Long size) throws IOException {
        if (source instanceof LocalFileWrapper) {
            return this.updateFileWrapper((LocalFileWrapper)source, name, contentType, size);
        }
        File file = (File)source;
        if (name == null) {
            name = file.getName();
        }
        if (contentType == null) {
            contentType = this.contentTypeDetect.detect(file);
        }
        if (size == null) {
            size = file.length();
        }
        return new LocalFileWrapper(file, name, contentType, size);
    }

    public ContentTypeDetect getContentTypeDetect() {
        return this.contentTypeDetect;
    }

    public void setContentTypeDetect(ContentTypeDetect contentTypeDetect) {
        this.contentTypeDetect = contentTypeDetect;
    }

    public LocalFileWrapperAdapter() {
    }

    public LocalFileWrapperAdapter(ContentTypeDetect contentTypeDetect) {
        this.contentTypeDetect = contentTypeDetect;
    }
}

