/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.hash;

import cn.hutool.core.util.HexUtil;
import java.security.MessageDigest;
import org.dromara.x.file.storage.core.exception.FileStorageRuntimeException;
import org.dromara.x.file.storage.core.hash.HashCalculator;

public class MessageDigestHashCalculator
implements HashCalculator {
    private final MessageDigest messageDigest;
    private volatile String value;

    public MessageDigestHashCalculator(String name) {
        try {
            this.messageDigest = MessageDigest.getInstance(name);
        }
        catch (Exception e) {
            throw new FileStorageRuntimeException("\u521b\u5efa StandardHashCalculator \u5931\u8d25\uff0c\u6682\u4e0d\u652f\u6301\uff1a" + name, e);
        }
    }

    public MessageDigestHashCalculator(MessageDigest messageDigest) {
        this.messageDigest = messageDigest;
    }

    @Override
    public String getName() {
        return this.messageDigest.getAlgorithm();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getValue() {
        if (this.value == null) {
            MessageDigestHashCalculator messageDigestHashCalculator = this;
            synchronized (messageDigestHashCalculator) {
                if (this.value == null) {
                    this.value = HexUtil.encodeHexStr((byte[])this.messageDigest.digest());
                }
            }
        }
        return this.value;
    }

    @Override
    public void update(byte[] bytes) {
        this.messageDigest.update(bytes);
    }
}

