/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.io.StreamProgress;
import cn.hutool.core.util.IdUtil;
import cn.hutool.core.util.StrUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.StandardCopyOption;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.InputStreamPlus;
import org.dromara.x.file.storage.core.ProgressListener;
import org.dromara.x.file.storage.core.UploadPretreatment;
import org.dromara.x.file.storage.core.copy.CopyPretreatment;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.exception.ExceptionFactory;
import org.dromara.x.file.storage.core.file.FileWrapper;
import org.dromara.x.file.storage.core.move.MovePretreatment;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.platform.MultipartUploadSupportInfo;
import org.dromara.x.file.storage.core.upload.AbortMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.CompleteMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.FilePartInfo;
import org.dromara.x.file.storage.core.upload.FilePartInfoList;
import org.dromara.x.file.storage.core.upload.InitiateMultipartUploadPretreatment;
import org.dromara.x.file.storage.core.upload.ListPartsPretreatment;
import org.dromara.x.file.storage.core.upload.UploadPartPretreatment;
import org.dromara.x.file.storage.core.util.Tools;

@Deprecated
public class LocalFileStorage
implements FileStorage {
    private String basePath;
    private String platform;
    private String domain;

    public LocalFileStorage(FileStorageProperties.LocalConfig config) {
        this.platform = config.getPlatform();
        this.basePath = config.getBasePath();
        this.domain = config.getDomain();
    }

    public String getAbsolutePath(String path) {
        return this.basePath + path;
    }

    @Override
    public String getFileKey(FileInfo fileInfo) {
        return Tools.getNotNull(fileInfo.getPath(), "") + Tools.getNotNull(fileInfo.getFilename(), "");
    }

    @Override
    public String getThFileKey(FileInfo fileInfo) {
        if (StrUtil.isBlank((CharSequence)fileInfo.getThFilename())) {
            return null;
        }
        return Tools.getNotNull(fileInfo.getPath(), "") + Tools.getNotNull(fileInfo.getThFilename(), "");
    }

    @Override
    public boolean save(FileInfo fileInfo, UploadPretreatment pre) {
        fileInfo.setBasePath(this.basePath);
        String newFileKey = this.getFileKey(fileInfo);
        fileInfo.setUrl(this.domain + newFileKey);
        Check.uploadNotSupportAcl(this.platform, fileInfo, pre);
        Check.uploadNotSupportMetadata(this.platform, fileInfo, pre);
        try {
            byte[] thumbnailBytes;
            File newFile = FileUtil.touch((String)this.getAbsolutePath(newFileKey));
            FileWrapper fileWrapper = pre.getFileWrapper();
            if (fileWrapper.supportTransfer()) {
                ProgressListener.quickStart(pre.getProgressListener(), fileWrapper.getSize());
                fileWrapper.transferTo(newFile);
                ProgressListener.quickFinish(pre.getProgressListener(), fileWrapper.getSize());
                if (fileInfo.getSize() == null) {
                    fileInfo.setSize(newFile.length());
                }
            } else {
                InputStreamPlus in = pre.getInputStreamPlus();
                FileUtil.writeFromStream((InputStream)in, (File)newFile);
                if (fileInfo.getSize() == null) {
                    fileInfo.setSize(in.getProgressSize());
                }
            }
            if ((thumbnailBytes = pre.getThumbnailBytes()) != null) {
                String newThFileKey = this.getThFileKey(fileInfo);
                fileInfo.setThUrl(this.domain + newThFileKey);
                FileUtil.writeBytes((byte[])thumbnailBytes, (String)this.getAbsolutePath(newThFileKey));
            }
            return true;
        }
        catch (IOException e) {
            try {
                FileUtil.del((String)this.getAbsolutePath(newFileKey));
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.upload(fileInfo, this.platform, e);
        }
    }

    @Override
    public MultipartUploadSupportInfo isSupportMultipartUpload() {
        return MultipartUploadSupportInfo.supportAll().setListPartsSupportMaxParts(10000);
    }

    @Override
    public void initiateMultipartUpload(FileInfo fileInfo, InitiateMultipartUploadPretreatment pre) {
        fileInfo.setBasePath(this.basePath);
        String newFileKey = this.getFileKey(fileInfo);
        fileInfo.setUrl(this.domain + newFileKey);
        Check.uploadNotSupportAcl(this.platform, fileInfo, pre);
        Check.uploadNotSupportMetadata(this.platform, fileInfo, pre);
        try {
            String uploadId = IdUtil.objectId();
            String parent = FileUtil.file((String)this.getAbsolutePath(newFileKey)).getParent();
            FileUtil.mkdir((File)FileUtil.file((String)parent, (String)uploadId));
            fileInfo.setUploadId(uploadId);
        }
        catch (Exception e) {
            throw ExceptionFactory.initiateMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfo uploadPart(UploadPartPretreatment pre) {
        FilePartInfo filePartInfo;
        block8: {
            FileInfo fileInfo = pre.getFileInfo();
            String newFileKey = this.getFileKey(fileInfo);
            pre.setHashCalculatorMd5();
            InputStreamPlus in = pre.getInputStreamPlus();
            try {
                String parent = FileUtil.file((String)this.getAbsolutePath(newFileKey)).getParent();
                File dir = FileUtil.file((String)parent, (String)fileInfo.getUploadId());
                File part = FileUtil.file((File)dir, (String)String.valueOf(pre.getPartNumber()));
                FileUtil.writeFromStream((InputStream)in, (File)part);
                String etag = pre.getHashCalculatorManager().getHashInfo().getMd5();
                LocalPartInfo partInfo = new LocalPartInfo(pre.getPartNumber(), etag, part.length(), new Date(part.lastModified()));
                FileUtil.appendUtf8String((String)(partInfo.toIndexString() + "\n"), (File)FileUtil.file((File)dir, (String)"index"));
                FilePartInfo filePartInfo2 = new FilePartInfo(fileInfo);
                filePartInfo2.setETag(etag);
                filePartInfo2.setPartNumber(pre.getPartNumber());
                filePartInfo2.setPartSize(in.getProgressSize());
                filePartInfo2.setCreateTime(new Date());
                filePartInfo = filePartInfo2;
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw ExceptionFactory.uploadPart(fileInfo, this.platform, e);
                }
            }
            in.close();
        }
        return filePartInfo;
    }

    @Override
    public void completeMultipartUpload(CompleteMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        try {
            File newFile = FileUtil.file((String)this.getAbsolutePath(newFileKey));
            String parent = newFile.getParent();
            File dir = FileUtil.file((String)parent, (String)fileInfo.getUploadId());
            List partInfoList = pre.getPartInfoList().stream().sorted(Comparator.comparingInt(FilePartInfo::getPartNumber)).collect(Collectors.toList());
            final Long fileSize = fileInfo.getSize();
            final long[] allProgressSize = new long[]{0L};
            final ProgressListener progressListener = pre.getProgressListener();
            ProgressListener.quickStart(progressListener, fileSize);
            try (BufferedOutputStream out = FileUtil.getOutputStream((File)newFile);){
                for (FilePartInfo partInfo : partInfoList) {
                    final File partFile = FileUtil.file((File)dir, (String)String.valueOf(partInfo.getPartNumber()));
                    if (progressListener == null) {
                        FileUtil.writeToStream((File)partFile, (OutputStream)out);
                        continue;
                    }
                    BufferedInputStream in = FileUtil.getInputStream((File)partFile);
                    try {
                        IoUtil.copy((InputStream)in, (OutputStream)out, (int)8192, (StreamProgress)new StreamProgress(){

                            public void start() {
                            }

                            public void progress(long total, long progressSize) {
                                ProgressListener.quickProgress(progressListener, allProgressSize[0] + progressSize, fileSize);
                            }

                            public void finish() {
                                allProgressSize[0] = allProgressSize[0] + partFile.length();
                            }
                        });
                    }
                    finally {
                        if (in == null) continue;
                        ((InputStream)in).close();
                    }
                }
            }
            ProgressListener.quickFinish(progressListener);
            if (fileSize == null) {
                fileInfo.setSize(newFile.length());
            }
            FileUtil.del((File)dir);
        }
        catch (Exception e) {
            try {
                FileUtil.del((String)this.getAbsolutePath(newFileKey));
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.completeMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public void abortMultipartUpload(AbortMultipartUploadPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        try {
            File newFile = FileUtil.file((String)this.getAbsolutePath(newFileKey));
            String parent = newFile.getParent();
            File dir = FileUtil.file((String)parent, (String)fileInfo.getUploadId());
            FileUtil.del((File)dir);
        }
        catch (Exception e) {
            throw ExceptionFactory.abortMultipartUpload(fileInfo, this.platform, e);
        }
    }

    @Override
    public FilePartInfoList listParts(ListPartsPretreatment pre) {
        FileInfo fileInfo = pre.getFileInfo();
        String newFileKey = this.getFileKey(fileInfo);
        try {
            String parent = FileUtil.file((String)this.getAbsolutePath(newFileKey)).getParent();
            File dir = FileUtil.file((String)parent, (String)fileInfo.getUploadId());
            List partTextInfoList = FileUtil.readUtf8Lines((File)FileUtil.file((File)dir, (String)"index"));
            List localPartInfoList = partTextInfoList.stream().map(LocalPartInfo::new).filter(p -> p.getPartNumber() > pre.getPartNumberMarker()).sorted(Comparator.comparingInt(LocalPartInfo::getPartNumber)).collect(Collectors.toList());
            FilePartInfoList list = new FilePartInfoList();
            list.setFileInfo(fileInfo);
            list.setMaxParts(pre.getMaxParts());
            list.setPartNumberMarker(pre.getPartNumberMarker());
            if (localPartInfoList.size() > pre.getMaxParts()) {
                list.setIsTruncated(true);
                localPartInfoList = localPartInfoList.subList(0, pre.getMaxParts());
                list.setNextPartNumberMarker(((LocalPartInfo)localPartInfoList.get(localPartInfoList.size() - 1)).getPartNumber());
            } else {
                list.setIsTruncated(false);
            }
            list.setList(localPartInfoList.stream().map(p -> {
                FilePartInfo filePartInfo = new FilePartInfo(fileInfo);
                filePartInfo.setETag(p.getEtag());
                filePartInfo.setPartNumber(p.getPartNumber());
                filePartInfo.setPartSize(p.getSize());
                filePartInfo.setLastModified(p.getLastModified());
                return filePartInfo;
            }).collect(Collectors.toList()));
            return list;
        }
        catch (Exception e) {
            throw ExceptionFactory.listParts(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean delete(FileInfo fileInfo) {
        try {
            if (fileInfo.getThFilename() != null) {
                FileUtil.del((String)this.getAbsolutePath(this.getThFileKey(fileInfo)));
            }
            return FileUtil.del((String)this.getAbsolutePath(this.getFileKey(fileInfo)));
        }
        catch (Exception e) {
            throw ExceptionFactory.delete(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean exists(FileInfo fileInfo) {
        try {
            return new File(this.getAbsolutePath(this.getFileKey(fileInfo))).exists();
        }
        catch (Exception e) {
            throw ExceptionFactory.exists(fileInfo, this.platform, e);
        }
    }

    @Override
    public void download(FileInfo fileInfo, Consumer<InputStream> consumer) {
        try (BufferedInputStream in = FileUtil.getInputStream((String)this.getAbsolutePath(this.getFileKey(fileInfo)));){
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.download(fileInfo, this.platform, e);
        }
    }

    @Override
    public void downloadTh(FileInfo fileInfo, Consumer<InputStream> consumer) {
        Check.downloadThBlankThFilename(this.platform, fileInfo);
        try (BufferedInputStream in = FileUtil.getInputStream((String)this.getAbsolutePath(this.getThFileKey(fileInfo)));){
            consumer.accept(in);
        }
        catch (Exception e) {
            throw ExceptionFactory.downloadTh(fileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameCopy() {
        return true;
    }

    @Override
    public void sameCopy(FileInfo srcFileInfo, FileInfo destFileInfo, CopyPretreatment pre) {
        Check.sameCopyNotSupportAcl(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameCopyNotSupportMetadata(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameCopyBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        File srcFile = new File(this.getAbsolutePath(this.getFileKey(srcFileInfo)));
        if (!srcFile.exists()) {
            throw ExceptionFactory.sameCopyNotFound(srcFileInfo, destFileInfo, this.platform, null);
        }
        File destThFile = null;
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
            String destThFileKey = this.getThFileKey(destFileInfo);
            destFileInfo.setThUrl(this.domain + destThFileKey);
            try {
                File srcThFile = new File(this.getAbsolutePath(this.getThFileKey(srcFileInfo)));
                destThFile = FileUtil.touch((String)this.getAbsolutePath(destThFileKey));
                FileUtil.copyFile((File)srcThFile, (File)destThFile, (StandardCopyOption[])new StandardCopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            }
            catch (Exception e) {
                try {
                    FileUtil.del(destThFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ExceptionFactory.sameCopyTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        String destFileKey = this.getFileKey(destFileInfo);
        destFileInfo.setUrl(this.domain + destFileKey);
        File destFile = null;
        try {
            destFile = FileUtil.touch((String)this.getAbsolutePath(destFileKey));
            if (pre.getProgressListener() == null) {
                FileUtil.copyFile((File)srcFile, (File)destFile, (StandardCopyOption[])new StandardCopyOption[]{StandardCopyOption.REPLACE_EXISTING});
            } else {
                InputStreamPlus in = new InputStreamPlus(FileUtil.getInputStream((File)srcFile), pre.getProgressListener(), srcFile.length());
                FileUtil.writeFromStream((InputStream)in, (File)destFile);
            }
        }
        catch (Exception e) {
            try {
                FileUtil.del(destThFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                FileUtil.del((File)destFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameCopy(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    @Override
    public boolean isSupportSameMove() {
        return true;
    }

    @Override
    public void sameMove(FileInfo srcFileInfo, FileInfo destFileInfo, MovePretreatment pre) {
        Check.sameMoveNotSupportAcl(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameMoveNotSupportMetadata(this.platform, srcFileInfo, destFileInfo, pre);
        Check.sameMoveBasePath(this.platform, this.basePath, srcFileInfo, destFileInfo);
        File srcFile = new File(this.getAbsolutePath(this.getFileKey(srcFileInfo)));
        if (!srcFile.exists()) {
            throw ExceptionFactory.sameMoveNotFound(srcFileInfo, destFileInfo, this.platform, null);
        }
        File srcThFile = null;
        File destThFile = null;
        if (StrUtil.isNotBlank((CharSequence)srcFileInfo.getThFilename())) {
            String destThFileKey = this.getThFileKey(destFileInfo);
            destFileInfo.setThUrl(this.domain + destThFileKey);
            try {
                srcThFile = new File(this.getAbsolutePath(this.getThFileKey(srcFileInfo)));
                destThFile = FileUtil.touch((String)this.getAbsolutePath(destThFileKey));
                FileUtil.move((File)srcThFile, (File)destThFile, (boolean)true);
            }
            catch (Exception e) {
                try {
                    FileUtil.del(destThFile);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw ExceptionFactory.sameMoveTh(srcFileInfo, destFileInfo, this.platform, e);
            }
        }
        String destFileKey = this.getFileKey(destFileInfo);
        destFileInfo.setUrl(this.domain + destFileKey);
        File destFile = null;
        try {
            destFile = FileUtil.touch((String)this.getAbsolutePath(destFileKey));
            ProgressListener.quickStart(pre.getProgressListener(), srcFile.length());
            FileUtil.move((File)srcFile, (File)destFile, (boolean)true);
            ProgressListener.quickFinish(pre.getProgressListener(), srcFile.length());
        }
        catch (Exception e) {
            if (destThFile != null) {
                try {
                    FileUtil.move(destThFile, (File)srcThFile, (boolean)true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            try {
                if (srcFile.exists()) {
                    FileUtil.del((File)destFile);
                } else if (destFile != null) {
                    FileUtil.move((File)destFile, (File)srcFile, (boolean)true);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw ExceptionFactory.sameMove(srcFileInfo, destFileInfo, this.platform, e);
        }
    }

    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }

    @Override
    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public LocalFileStorage() {
    }

    public static class LocalPartInfo {
        private Integer partNumber;
        private String etag;
        private Long size;
        private Date lastModified;

        public LocalPartInfo(String text) {
            String[] arr = text.split("_");
            this.partNumber = Integer.parseInt(arr[0]);
            this.etag = arr[1];
            this.size = Long.parseLong(arr[2]);
            this.lastModified = new Date(Long.parseLong(arr[3]));
        }

        public String toIndexString() {
            return this.partNumber + "_" + this.etag + "_" + this.size + "_" + this.lastModified.getTime();
        }

        public Integer getPartNumber() {
            return this.partNumber;
        }

        public String getEtag() {
            return this.etag;
        }

        public Long getSize() {
            return this.size;
        }

        public Date getLastModified() {
            return this.lastModified;
        }

        public void setPartNumber(Integer partNumber) {
            this.partNumber = partNumber;
        }

        public void setEtag(String etag) {
            this.etag = etag;
        }

        public void setSize(Long size) {
            this.size = size;
        }

        public void setLastModified(Date lastModified) {
            this.lastModified = lastModified;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LocalPartInfo)) {
                return false;
            }
            LocalPartInfo other = (LocalPartInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Integer this$partNumber = this.getPartNumber();
            Integer other$partNumber = other.getPartNumber();
            if (this$partNumber == null ? other$partNumber != null : !((Object)this$partNumber).equals(other$partNumber)) {
                return false;
            }
            Long this$size = this.getSize();
            Long other$size = other.getSize();
            if (this$size == null ? other$size != null : !((Object)this$size).equals(other$size)) {
                return false;
            }
            String this$etag = this.getEtag();
            String other$etag = other.getEtag();
            if (this$etag == null ? other$etag != null : !this$etag.equals(other$etag)) {
                return false;
            }
            Date this$lastModified = this.getLastModified();
            Date other$lastModified = other.getLastModified();
            return !(this$lastModified == null ? other$lastModified != null : !((Object)this$lastModified).equals(other$lastModified));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LocalPartInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Integer $partNumber = this.getPartNumber();
            result = result * 59 + ($partNumber == null ? 43 : ((Object)$partNumber).hashCode());
            Long $size = this.getSize();
            result = result * 59 + ($size == null ? 43 : ((Object)$size).hashCode());
            String $etag = this.getEtag();
            result = result * 59 + ($etag == null ? 43 : $etag.hashCode());
            Date $lastModified = this.getLastModified();
            result = result * 59 + ($lastModified == null ? 43 : ((Object)$lastModified).hashCode());
            return result;
        }

        public String toString() {
            return "LocalFileStorage.LocalPartInfo(partNumber=" + this.partNumber + ", etag=" + this.etag + ", size=" + this.size + ", lastModified=" + this.lastModified + ")";
        }

        public LocalPartInfo() {
        }

        public LocalPartInfo(Integer partNumber, String etag, Long size, Date lastModified) {
            this.partNumber = partNumber;
            this.etag = etag;
            this.size = size;
            this.lastModified = lastModified;
        }
    }
}

