/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.platform;

import cn.hutool.core.util.StrUtil;
import com.qcloud.cos.COSClient;
import com.qcloud.cos.ClientConfig;
import com.qcloud.cos.auth.BasicCOSCredentials;
import com.qcloud.cos.auth.COSCredentials;
import com.qcloud.cos.region.Region;
import org.dromara.x.file.storage.core.FileStorageProperties;
import org.dromara.x.file.storage.core.platform.FileStorageClientFactory;

public class TencentCosFileStorageClientFactory
implements FileStorageClientFactory<COSClient> {
    private String platform;
    private String secretId;
    private String secretKey;
    private String region;
    private volatile COSClient client;

    public TencentCosFileStorageClientFactory(FileStorageProperties.TencentCosConfig config) {
        this.platform = config.getPlatform();
        this.secretId = config.getSecretId();
        this.secretKey = config.getSecretKey();
        this.region = config.getRegion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public COSClient getClient() {
        if (this.client == null) {
            TencentCosFileStorageClientFactory tencentCosFileStorageClientFactory = this;
            synchronized (tencentCosFileStorageClientFactory) {
                if (this.client == null) {
                    ClientConfig clientConfig = new ClientConfig();
                    if (StrUtil.isNotBlank((CharSequence)this.region)) {
                        clientConfig.setRegion(new Region(this.region));
                    }
                    this.client = new COSClient((COSCredentials)new BasicCOSCredentials(this.secretId, this.secretKey), clientConfig);
                }
            }
        }
        return this.client;
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.shutdown();
            this.client = null;
        }
    }

    @Override
    public String getPlatform() {
        return this.platform;
    }

    public String getSecretId() {
        return this.secretId;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getRegion() {
        return this.region;
    }

    public void setPlatform(String platform) {
        this.platform = platform;
    }

    public void setSecretId(String secretId) {
        this.secretId = secretId;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public void setClient(COSClient client) {
        this.client = client;
    }

    public TencentCosFileStorageClientFactory() {
    }
}

