/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.x.file.storage.core.upload;

import java.util.concurrent.CopyOnWriteArrayList;
import org.dromara.x.file.storage.core.FileInfo;
import org.dromara.x.file.storage.core.FileStorageService;
import org.dromara.x.file.storage.core.aspect.AbortMultipartUploadAspectChain;
import org.dromara.x.file.storage.core.aspect.FileStorageAspect;
import org.dromara.x.file.storage.core.exception.Check;
import org.dromara.x.file.storage.core.platform.FileStorage;
import org.dromara.x.file.storage.core.recorder.FileRecorder;
import org.dromara.x.file.storage.core.upload.AbortMultipartUploadPretreatment;

public class AbortMultipartUploadActuator {
    private final FileStorageService fileStorageService;
    private final AbortMultipartUploadPretreatment pre;

    public AbortMultipartUploadActuator(AbortMultipartUploadPretreatment pre) {
        this.pre = pre;
        this.fileStorageService = pre.getFileStorageService();
    }

    public FileInfo execute() {
        FileInfo fileInfo = this.pre.getFileInfo();
        Check.abortMultipartUpload(fileInfo);
        Object fileStorage = this.fileStorageService.getFileStorageVerify(fileInfo.getPlatform());
        CopyOnWriteArrayList<FileStorageAspect> aspectList = this.fileStorageService.getAspectList();
        FileRecorder fileRecorder = this.fileStorageService.getFileRecorder();
        return new AbortMultipartUploadAspectChain(aspectList, (_pre, _fileStorage, _fileRecorder) -> {
            FileInfo _fileInfo = _pre.getFileInfo();
            _fileStorage.abortMultipartUpload(_pre);
            _fileRecorder.deleteFilePartByUploadId(_fileInfo.getUploadId());
            _fileRecorder.delete(_fileInfo.getUrl());
            return _fileInfo;
        }).next(this.pre, (FileStorage)fileStorage, fileRecorder);
    }
}

