/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.nativeaccess.jdk;

import java.lang.foreign.Arena;
import java.lang.foreign.FunctionDescriptor;
import java.lang.foreign.Linker;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.StructLayout;
import java.lang.foreign.ValueLayout;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.VarHandle;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.nativeaccess.jdk.LinkerHelper;
import org.elasticsearch.nativeaccess.jdk.MemorySegmentUtil;
import org.elasticsearch.nativeaccess.lib.PosixCLibrary;

class JdkPosixCLibrary
implements PosixCLibrary {
    private static final Logger logger = LogManager.getLogger(JdkPosixCLibrary.class);
    private static final StructLayout CAPTURE_ERRNO_LAYOUT = Linker.Option.captureStateLayout();
    static final Linker.Option CAPTURE_ERRNO_OPTION = Linker.Option.captureCallState("errno");
    private static final VarHandle errno$vh = MemorySegmentUtil.varHandleWithoutOffset(CAPTURE_ERRNO_LAYOUT, MemoryLayout.PathElement.groupElement("errno"));
    private static final MethodHandle geteuid$mh = LinkerHelper.downcallHandle("geteuid", FunctionDescriptor.of(ValueLayout.JAVA_INT, new MemoryLayout[0]), new Linker.Option[0]);
    private static final MethodHandle strerror$mh = LinkerHelper.downcallHandle("strerror", FunctionDescriptor.of(ValueLayout.ADDRESS, ValueLayout.JAVA_INT), new Linker.Option[0]);
    private static final MethodHandle getrlimit$mh = JdkPosixCLibrary.downcallHandleWithErrno("getrlimit", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT, ValueLayout.ADDRESS));
    private static final MethodHandle mlockall$mh = JdkPosixCLibrary.downcallHandleWithErrno("mlockall", FunctionDescriptor.of(ValueLayout.JAVA_INT, ValueLayout.JAVA_INT));
    static final MemorySegment errnoState = Arena.ofAuto().allocate(CAPTURE_ERRNO_LAYOUT);

    JdkPosixCLibrary() {
    }

    static MethodHandle downcallHandleWithErrno(String function, FunctionDescriptor functionDescriptor) {
        return LinkerHelper.downcallHandle(function, functionDescriptor, CAPTURE_ERRNO_OPTION);
    }

    @Override
    public int errno() {
        return errno$vh.get(errnoState);
    }

    @Override
    public String strerror(int errno) {
        try {
            MemorySegment str = strerror$mh.invokeExact(errno);
            return MemorySegmentUtil.getString(str.reinterpret(Long.MAX_VALUE), 0L);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public int geteuid() {
        try {
            return geteuid$mh.invokeExact();
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public PosixCLibrary.RLimit newRLimit() {
        return new JdkRLimit();
    }

    @Override
    public int getrlimit(int resource, PosixCLibrary.RLimit rlimit) {
        assert (rlimit instanceof JdkRLimit);
        JdkRLimit jdkRlimit = (JdkRLimit)rlimit;
        try {
            return getrlimit$mh.invokeExact(errnoState, resource, jdkRlimit.segment);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    @Override
    public int mlockall(int flags) {
        try {
            return mlockall$mh.invokeExact(errnoState, flags);
        }
        catch (Throwable t) {
            throw new AssertionError((Object)t);
        }
    }

    static class JdkRLimit
    implements PosixCLibrary.RLimit {
        private static final MemoryLayout layout = MemoryLayout.structLayout(ValueLayout.JAVA_LONG, ValueLayout.JAVA_LONG);
        private static final VarHandle rlim_cur$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(0L));
        private static final VarHandle rlim_max$vh = MemorySegmentUtil.varHandleWithoutOffset(layout, MemoryLayout.PathElement.groupElement(1L));
        private final MemorySegment segment;

        JdkRLimit() {
            Arena arena = Arena.ofAuto();
            this.segment = arena.allocate(layout);
        }

        @Override
        public long rlim_cur() {
            return rlim_cur$vh.get(this.segment);
        }

        @Override
        public long rlim_max() {
            return rlim_max$vh.get(this.segment);
        }

        public String toString() {
            return "JdkRLimit[rlim_cur=" + this.rlim_cur() + ", rlim_max=" + this.rlim_max();
        }
    }
}

